/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;

public abstract class AbstractChangePoint
implements JsonpSerializable {
    private final double pValue;
    private final int changePoint;

    protected AbstractChangePoint(AbstractBuilder<?> builder) {
        this.pValue = ApiTypeHelper.requireNonNull(builder.pValue, (Object)this, "pValue", 0.0);
        this.changePoint = ApiTypeHelper.requireNonNull(builder.changePoint, (Object)this, "changePoint", 0);
    }

    public final double pValue() {
        return this.pValue;
    }

    public final int changePoint() {
        return this.changePoint;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("p_value");
        generator.write(this.pValue);
        generator.writeKey("change_point");
        generator.write(this.changePoint);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAbstractChangePointDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::pValue, JsonpDeserializer.doubleDeserializer(), "p_value");
        op.add(AbstractBuilder::changePoint, JsonpDeserializer.integerDeserializer(), "change_point");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private Double pValue;
        private Integer changePoint;

        public final BuilderT pValue(double value) {
            this.pValue = value;
            return (BuilderT)this.self();
        }

        public final BuilderT changePoint(int value) {
            this.changePoint = value;
            return (BuilderT)this.self();
        }

        @Override
        protected abstract BuilderT self();
    }
}

