/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeClassificationSummary;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeOutlierDetectionSummary;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.DataframeRegressionSummary;
import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.ResponseBodyVariant;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ResponseBody
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<ResponseBody> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ResponseBody::setupResponseBodyDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public ResponseBody(ResponseBodyVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._responseBodyKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private ResponseBody(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static ResponseBody of(Function<Builder, ObjectBuilder<ResponseBody>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isClassification() {
        return this._kind == Kind.Classification;
    }

    public DataframeClassificationSummary classification() {
        return (DataframeClassificationSummary)TaggedUnionUtils.get(this, Kind.Classification);
    }

    public boolean isOutlierDetection() {
        return this._kind == Kind.OutlierDetection;
    }

    public DataframeOutlierDetectionSummary outlierDetection() {
        return (DataframeOutlierDetectionSummary)TaggedUnionUtils.get(this, Kind.OutlierDetection);
    }

    public boolean isRegression() {
        return this._kind == Kind.Regression;
    }

    public DataframeRegressionSummary regression() {
        return (DataframeRegressionSummary)TaggedUnionUtils.get(this, Kind.Regression);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        generator.writeKey(this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupResponseBodyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classification, DataframeClassificationSummary._DESERIALIZER, "classification");
        op.add(Builder::outlierDetection, DataframeOutlierDetectionSummary._DESERIALIZER, "outlier_detection");
        op.add(Builder::regression, DataframeRegressionSummary._DESERIALIZER, "regression");
    }

    public static enum Kind implements JsonEnum
    {
        Classification("classification"),
        OutlierDetection("outlier_detection"),
        Regression("regression");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ResponseBody> {
        private Kind _kind;
        private Object _value;

        @Override
        protected Builder self() {
            return this;
        }

        public ObjectBuilder<ResponseBody> classification(DataframeClassificationSummary v) {
            this._kind = Kind.Classification;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseBody> classification(Function<DataframeClassificationSummary.Builder, ObjectBuilder<DataframeClassificationSummary>> fn) {
            return this.classification(fn.apply(new DataframeClassificationSummary.Builder()).build());
        }

        public ObjectBuilder<ResponseBody> outlierDetection(DataframeOutlierDetectionSummary v) {
            this._kind = Kind.OutlierDetection;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseBody> outlierDetection(Function<DataframeOutlierDetectionSummary.Builder, ObjectBuilder<DataframeOutlierDetectionSummary>> fn) {
            return this.outlierDetection(fn.apply(new DataframeOutlierDetectionSummary.Builder()).build());
        }

        public ObjectBuilder<ResponseBody> regression(DataframeRegressionSummary v) {
            this._kind = Kind.Regression;
            this._value = v;
            return this;
        }

        public ObjectBuilder<ResponseBody> regression(Function<DataframeRegressionSummary.Builder, ObjectBuilder<DataframeRegressionSummary>> fn) {
            return this.regression(fn.apply(new DataframeRegressionSummary.Builder()).build());
        }

        @Override
        public ResponseBody build() {
            this._checkSingleUse();
            return new ResponseBody(this);
        }
    }
}

