/*
 * Decompiled with CFR 0.152.
 */
package co.leantechniques.maven.buildtime;

import co.leantechniques.maven.buildtime.MojoExecutionName;
import co.leantechniques.maven.buildtime.MojoTimer;
import co.leantechniques.maven.buildtime.SystemClock;
import co.leantechniques.maven.buildtime.TimerVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTimer
implements Comparable<ProjectTimer> {
    private final String projectName;
    private final ConcurrentMap<String, MojoTimer> dataStore;
    private final SystemClock systemClock;

    public ProjectTimer(String projectName, ConcurrentMap<String, MojoTimer> dataStore, SystemClock systemClock) {
        this.dataStore = dataStore;
        this.systemClock = systemClock;
        this.projectName = projectName;
    }

    public ProjectTimer(String projectName, SystemClock systemClock) {
        this(projectName, new ConcurrentHashMap<String, MojoTimer>(), systemClock);
    }

    public void stopTimerFor(MojoExecutionName me) {
        this.getMojoTimer(me).stop();
    }

    public void startTimerFor(MojoExecutionName name) {
        this.getMojoTimer(name).start();
    }

    public MojoTimer getMojoTimer(MojoExecutionName name) {
        if (!this.dataStore.containsKey(name.getName())) {
            this.dataStore.putIfAbsent(name.getName(), new MojoTimer(this.projectName, name.getName(), this.systemClock));
        }
        return (MojoTimer)this.dataStore.get(name.getName());
    }

    public Long getDuration() {
        return this.getProjectEndTime() - this.getProjectStartTime();
    }

    public void accept(TimerVisitor visitor) {
        visitor.visit(this);
        ArrayList mojoTimers = new ArrayList(this.dataStore.values());
        Collections.sort(mojoTimers);
        for (MojoTimer mojoTimer : mojoTimers) {
            mojoTimer.accept(visitor);
        }
    }

    @Override
    public int compareTo(ProjectTimer that) {
        long thatStartTime;
        if (that == null) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        long thisStartTime = this.getProjectStartTime();
        if (thisStartTime > (thatStartTime = that.getProjectStartTime())) {
            return 1;
        }
        if (thisStartTime < thatStartTime) {
            return -1;
        }
        return 0;
    }

    public String getProjectName() {
        return this.projectName;
    }

    private long getProjectStartTime() {
        long startTime = Long.MAX_VALUE;
        for (MojoTimer mojoTimer : this.dataStore.values()) {
            startTime = Math.min(startTime, mojoTimer.getStartTime());
        }
        return startTime;
    }

    private long getProjectEndTime() {
        long endTime = 0L;
        for (MojoTimer mojoTimer : this.dataStore.values()) {
            endTime = Math.max(endTime, mojoTimer.getEndTime());
        }
        return endTime;
    }
}

