/*
 * Decompiled with CFR 0.152.
 */
package co.leantechniques.maven.buildtime.output;

import co.leantechniques.maven.buildtime.AbstractTimerVisitor;
import co.leantechniques.maven.buildtime.MavenHelper;
import co.leantechniques.maven.buildtime.MojoTimer;
import co.leantechniques.maven.buildtime.SessionTimer;
import co.leantechniques.maven.buildtime.output.Reporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Locale;
import org.apache.maven.execution.ExecutionEvent;
import org.slf4j.Logger;

public class CsvReporter
implements Reporter {
    private File getOutputFile(ExecutionEvent event) {
        String output = MavenHelper.getExecutionProperty(event, "buildtime.output.csv.file", "buildtime.csv");
        if (output != null) {
            File file = new File(output);
            if (file.isAbsolute()) {
                file.getParentFile().mkdirs();
            } else {
                File parent = new File("target");
                parent.mkdirs();
                file = new File(parent, output);
            }
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performReport(Logger logger, ExecutionEvent event, SessionTimer session) {
        File file;
        if (Boolean.parseBoolean(MavenHelper.getExecutionProperty(event, "buildtime.output.csv", "false")) && (file = this.getOutputFile(event)) != null) {
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(file);
                this.writeTo(session, printWriter);
            }
            catch (FileNotFoundException e) {
                logger.error("Could not write report", (Throwable)e);
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }

    public void writeTo(SessionTimer session, PrintWriter printWriter) {
        printWriter.println("\"Module\";\"Mojo\";\"Time\"");
        session.accept(new CsvReportVisitor(printWriter));
    }

    public static class CsvReportVisitor
    extends AbstractTimerVisitor {
        private PrintWriter printWriter;

        public CsvReportVisitor(PrintWriter printWriter) {
            this.printWriter = printWriter;
        }

        public void visit(MojoTimer mojoTimer) {
            this.printWriter.format(Locale.ENGLISH, "\"%s\";\"%s\";\"%.3f\"%n", mojoTimer.getProjectName(), mojoTimer.getName(), (double)mojoTimer.getDuration().longValue() / 1000.0);
        }
    }
}

