/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import co.leantechniques.maven.buildtime.SessionTimer;
import co.leantechniques.maven.buildtime.output.CsvReporter;
import co.leantechniques.maven.buildtime.output.LogReporter;
import co.leantechniques.maven.buildtime.output.Reporter;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.apache.maven.eventspy.EventSpy;
import org.apache.maven.execution.ExecutionEvent;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;

@Component(role=EventSpy.class, hint="timing")
public class BuildTimeEventSpy
extends AbstractEventSpy {
    @Requirement
    private Logger logger;
    private List<Reporter> reporters;
    private final SessionTimer session = new SessionTimer();

    public BuildTimeEventSpy(Logger logger, Reporter ... reporters) {
        this.logger = logger;
        this.reporters = Arrays.asList(reporters);
    }

    public BuildTimeEventSpy() {
        this.reporters = Arrays.asList(new LogReporter(), new CsvReporter());
    }

    public void init(EventSpy.Context context) throws Exception {
        super.init(context);
        this.logger.info("BuildTimeEventSpy is registered.");
    }

    public void onEvent(Object event) throws Exception {
        if (event instanceof ExecutionEvent) {
            this.onEvent((ExecutionEvent)event);
        }
    }

    private void onEvent(ExecutionEvent event) throws Exception {
        switch (event.getType()) {
            case MojoStarted: {
                this.session.mojoStarted(event.getProject(), event.getMojoExecution());
                break;
            }
            case MojoFailed: {
                this.session.mojoFailed(event.getProject(), event.getMojoExecution());
                break;
            }
            case MojoSucceeded: {
                this.session.mojoSucceeded(event.getProject(), event.getMojoExecution());
                break;
            }
            case SessionEnded: {
                this.doReport(event);
                break;
            }
        }
    }

    public void close() throws Exception {
        super.close();
    }

    private void doReport(ExecutionEvent event) {
        for (Reporter reporter : this.reporters) {
            reporter.performReport(this.logger, event, this.session);
        }
    }
}

