/*
 * Decompiled with CFR 0.152.
 */
import capsule.DependencyManager;
import capsule.PomReader;
import capsule.org.eclipse.aether.graph.Dependency;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MavenCapsule
extends Capsule {
    private static final String PROP_TREE = MavenCapsule.OPTION((String)"capsule.tree", (String)"false", (String)"printDependencyTree", (String)"Prints the capsule's dependency tree.");
    private static final String PROP_RESOLVE = MavenCapsule.OPTION((String)"capsule.resolve", (String)"false", (String)"resolve", (String)"Downloads all un-cached dependencies.");
    private static final String PROP_USE_LOCAL_REPO = MavenCapsule.OPTION((String)"capsule.local", null, null, (String)"Sets the path of the local Maven repository to use.");
    private static final String PROP_RESET = "capsule.reset";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PROP_PROFILE = "capsule.profile";
    private static final int PROFILE = MavenCapsule.emptyOrTrue(System.getProperty("capsule.profile")) ? 1 : 3;
    private static final Map.Entry<String, List<String>> ATTR_REPOSITORIES = MavenCapsule.ATTRIBUTE((String)"Repositories", (Object)MavenCapsule.T_LIST((Object)MavenCapsule.T_STRING()), Arrays.asList("central"), (boolean)true, (String)"A list of Maven repositories, each formatted as URL or NAME(URL)");
    private static final Map.Entry<String, Boolean> ATTR_ALLOW_SNAPSHOTS = MavenCapsule.ATTRIBUTE((String)"Allow-Snapshots", (Object)MavenCapsule.T_BOOL(), (Object)false, (boolean)true, (String)"Whether or not SNAPSHOT dependencies are allowed");
    private static final String ENV_CAPSULE_REPOS = "CAPSULE_REPOS";
    private static final String ENV_CAPSULE_LOCAL_REPO = "CAPSULE_LOCAL_REPO";
    private static final String POM_FILE = "pom.xml";
    private static final String DEPS_CACHE_NAME = "deps";
    private DependencyManager dependencyManager;
    private PomReader pom;
    private Path localRepo;
    private String version;
    private static final List<Path> UNRESOLVED = new ArrayList<Path>();
    private final Map<Dependency, List<Path>> dependencies = new HashMap<Dependency, List<Path>>();

    public MavenCapsule(Path jarFile) {
        super(jarFile);
    }

    public MavenCapsule(Capsule pred) {
        super(pred);
    }

    protected void finalizeCapsule() {
        this.pom = this.createPomReader();
        if (this.dependencyManager != null) {
            this.setDependencyRepositories((List)this.getAttribute(ATTR_REPOSITORIES));
        }
        super.finalizeCapsule();
    }

    void printDependencyTree(List<String> args) {
        this.verifyNonEmpty("Cannot print dependencies of a wrapper capsule.");
        STDOUT.println("Dependencies for " + this.getAppId());
        if (this.hasAttribute(ATTR_APP_ARTIFACT)) {
            String appArtifact = (String)this.getAttribute(ATTR_APP_ARTIFACT);
            if (MavenCapsule.isDependency(appArtifact)) {
                this.getDependencyManager().printDependencyTree(appArtifact, "jar", STDOUT);
            }
        } else {
            this.lookupAllDependencies();
            if (this.dependencies.isEmpty()) {
                STDOUT.println("No external dependencies.");
            } else {
                this.getDependencyManager().printDependencyTree(this.getUnresolved(), STDOUT);
            }
        }
    }

    void resolve(List<String> args) throws IOException, InterruptedException {
        this.verifyNonEmpty("Cannot resolve a wrapper capsule.");
        if (this.hasAttribute(ATTR_APP_ARTIFACT)) {
            String appArtifact = (String)this.getAttribute(ATTR_APP_ARTIFACT);
            this.lookup(appArtifact);
        }
        this.lookupAllDependencies();
        this.getDependencyManager().resolveDependencies(this.getUnresolved());
        MavenCapsule.log((int)1, (String)"Capsule resolved");
    }

    private void verifyNonEmpty(String message) {
        if (this.isEmptyCapsule()) {
            throw new IllegalArgumentException(message);
        }
    }

    private void lookupAllDependencies() {
        try {
            MavenCapsule.accessible(Capsule.class.getDeclaredMethod("lookupAllDependencies", new Class[0])).invoke((Object)this, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }

    private List<Dependency> getUnresolved() {
        ArrayList<Dependency> unresolved = new ArrayList<Dependency>();
        for (Map.Entry<Dependency, List<Path>> e : this.dependencies.entrySet()) {
            if (e.getValue() != UNRESOLVED) continue;
            unresolved.add(e.getKey());
        }
        return unresolved;
    }

    protected <T> T attribute(Map.Entry<String, T> attr) {
        if (ATTR_APP_ID.equals(attr)) {
            String id = (String)super.attribute(ATTR_APP_ID);
            if (id == null && this.pom != null) {
                id = this.pom.getGroupId() + "." + this.pom.getArtifactId();
            }
            return (T)id;
        }
        if (ATTR_APP_VERSION.equals(attr)) {
            String ver = (String)super.attribute(ATTR_APP_VERSION);
            if (ver == null && this.version != null) {
                ver = this.version;
            }
            if (ver == null && this.hasAttribute(ATTR_APP_ARTIFACT) && MavenCapsule.isDependency((String)this.getAttribute(ATTR_APP_ARTIFACT))) {
                ver = MavenCapsule.getAppArtifactVersion((String)this.getDependencyManager().getLatestVersion((String)this.getAttribute(ATTR_APP_VERSION), "jar"));
            }
            if (ver == null && this.pom != null) {
                ver = this.pom.getVersion();
            }
            this.version = ver;
            return (T)ver;
        }
        if (ATTR_DEPENDENCIES.equals(attr)) {
            ArrayList<Object> deps = (ArrayList<Object>)super.attribute(ATTR_DEPENDENCIES);
            if ((deps == null || deps.isEmpty()) && this.pom != null) {
                deps = new ArrayList<Object>();
                for (String[] d : this.pom.getDependencies()) {
                    deps.add(this.lookup(d[0], d[1], ATTR_DEPENDENCIES, null));
                }
            }
            return (T)deps;
        }
        if (ATTR_REPOSITORIES.equals(attr)) {
            ArrayList<String> repos = new ArrayList<String>();
            repos.addAll(MavenCapsule.nullToEmpty(MavenCapsule.split(MavenCapsule.getenv((String)ENV_CAPSULE_REPOS), "[,\\s]\\s*")));
            repos.addAll((Collection)super.attribute(ATTR_REPOSITORIES));
            if (this.pom != null) {
                MavenCapsule.addAllIfAbsent(repos, MavenCapsule.nullToEmpty(this.pom.getRepositories()));
            }
            return (T)repos;
        }
        return (T)super.attribute(attr);
    }

    protected Object lookup0(Object x, String type, Map.Entry<String, ?> attrContext, Object context) {
        String s;
        Object res = super.lookup0(x, type, attrContext, context);
        if (res == null && x instanceof String && MavenCapsule.isDependency(s = (String)x)) {
            Dependency dep = DependencyManager.toDependency(s, type.isEmpty() ? "jar" : type);
            if (!this.dependencies.containsKey(dep)) {
                this.dependencies.put(dep, UNRESOLVED);
            }
            return super.lookup0((Object)dep, type, attrContext, context);
        }
        return res;
    }

    protected List<Path> resolve0(Object x) {
        if (x instanceof Dependency) {
            Dependency d = (Dependency)x;
            if (this.dependencies.get(d) == UNRESOLVED) {
                long start = MavenCapsule.clock();
                Map<Dependency, List<Path>> resolved = this.getDependencyManager().resolveDependencies(this.getUnresolved());
                MavenCapsule.log((int)3, (String)("Maven resolved: " + resolved));
                this.dependencies.putAll(resolved);
                MavenCapsule.time("resolveAll", start);
            }
            assert (this.dependencies.get(d) != UNRESOLVED) : d;
            List<Path> y = this.dependencies.get(d);
            if (y == null) {
                return super.resolve0(x);
            }
            return this.resolve(y);
        }
        return super.resolve0(x);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PomReader createPomReader() {
        try (InputStream is = MavenCapsule.getEntryInputStream((Path)this.getJarFile(), (String)POM_FILE);){
            PomReader pomReader = is != null ? new PomReader(is) : null;
            return pomReader;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read pom.xml", e);
        }
    }

    private DependencyManager getDependencyManager() {
        DependencyManager dm = this.initDependencyManager();
        if (dm == null) {
            throw new RuntimeException("Capsule " + this.getJarFile() + " uses dependencies, while the necessary dependency management classes are not found in the capsule JAR");
        }
        return dm;
    }

    private DependencyManager initDependencyManager() {
        if (this.dependencyManager == null) {
            this.dependencyManager = this.createDependencyManager();
            if (this.dependencyManager != null) {
                this.setDependencyRepositories((List)this.getAttribute(ATTR_REPOSITORIES));
            }
        }
        return this.dependencyManager;
    }

    private DependencyManager createDependencyManager() {
        boolean reset = MavenCapsule.systemPropertyEmptyOrTrue(PROP_RESET);
        return this.createDependencyManager(this.getLocalRepo().toAbsolutePath(), reset, MavenCapsule.getLogLevel());
    }

    protected DependencyManager createDependencyManager(Path localRepo, boolean reset, int logLevel) {
        MavenCapsule ct = (MavenCapsule)this.getCallTarget(MavenCapsule.class);
        return ct != null ? ct.createDependencyManager(localRepo, reset, logLevel) : this.createDependencyManager0(localRepo, reset, logLevel);
    }

    private DependencyManager createDependencyManager0(Path localRepo, boolean reset, int logLevel) {
        return new DependencyManager(localRepo, reset, logLevel);
    }

    private void setDependencyRepositories(List<String> repositories) {
        this.getDependencyManager().setRepos(repositories, (Boolean)this.getAttribute(ATTR_ALLOW_SNAPSHOTS));
    }

    private Path getLocalRepo() {
        if (this.localRepo == null) {
            Path repo;
            String local = MavenCapsule.emptyToNull(MavenCapsule.expandCommandLinePath(MavenCapsule.propertyOrEnv(PROP_USE_LOCAL_REPO, ENV_CAPSULE_LOCAL_REPO)));
            if (local != null) {
                repo = MavenCapsule.toAbsolutePath(Paths.get(local, new String[0]));
            } else {
                repo = this.getCacheDir().resolve(DEPS_CACHE_NAME);
                try {
                    if (!Files.exists(repo, new LinkOption[0])) {
                        Files.createDirectory(repo, MavenCapsule.getPermissions((Path)repo.getParent()));
                    }
                    return repo;
                }
                catch (IOException e) {
                    MavenCapsule.log((int)2, (String)("Could not create local repo at " + repo));
                    if (MavenCapsule.isLogging((int)2)) {
                        e.printStackTrace(STDERR);
                    }
                    repo = null;
                }
            }
            this.localRepo = repo;
        }
        return this.localRepo;
    }

    private static boolean isDependency(String lib) {
        return lib.contains(":") && !lib.contains(":\\");
    }

    private static boolean systemPropertyEmptyOrTrue(String property) {
        return MavenCapsule.emptyOrTrue(MavenCapsule.getProperty((String)property));
    }

    private static boolean emptyOrTrue(String value) {
        if (value == null) {
            return false;
        }
        return value.isEmpty() || Boolean.parseBoolean(value);
    }

    private static String propertyOrEnv(String propName, String envVar) {
        String val = MavenCapsule.getProperty((String)propName);
        if (val == null) {
            val = MavenCapsule.emptyToNull(MavenCapsule.getenv((String)envVar));
        }
        return val;
    }

    private static String expandCommandLinePath(String str) {
        if (str == null) {
            return null;
        }
        return str.startsWith("~/") ? str.replace("~", MavenCapsule.getProperty((String)PROP_USER_HOME)) : str;
    }

    private static Path toAbsolutePath(Path p) {
        return p != null ? p.toAbsolutePath().normalize() : null;
    }

    private static <C extends Collection<T>, T> C addAllIfAbsent(C c, Collection<T> c1) {
        for (T e : c1) {
            if (c.contains(e)) continue;
            c.add(e);
        }
        return c;
    }

    private static <T> List<T> nullToEmpty(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private static <T extends Collection<?>> T emptyToNull(T c) {
        return c == null || c.isEmpty() ? null : (T)c;
    }

    private static String emptyToNull(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }

    private static List<String> split(String str, String separator) {
        if (str == null) {
            return null;
        }
        String[] es = str.split(separator);
        ArrayList<String> list = new ArrayList<String>(es.length);
        for (String e : es) {
            if ((e = e.trim()).isEmpty()) continue;
            list.add(e);
        }
        return list;
    }

    private static <T extends AccessibleObject> T accessible(T obj) {
        if (obj == null) {
            return null;
        }
        obj.setAccessible(true);
        return obj;
    }

    private static long clock() {
        return MavenCapsule.isLogging((int)PROFILE) ? System.nanoTime() : 0L;
    }

    private static void time(String op, long start) {
        MavenCapsule.time(op, start, MavenCapsule.isLogging((int)PROFILE) ? System.nanoTime() : 0L);
    }

    private static void time(String op, long start, long stop) {
        if (MavenCapsule.isLogging((int)PROFILE)) {
            MavenCapsule.log((int)PROFILE, (String)("PROFILE " + op + " " + (stop - start) / 1000000L + "ms"));
        }
    }
}

