/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.DependencyManager;
import capsule.org.eclipse.aether.artifact.Artifact;
import capsule.org.eclipse.aether.graph.Dependency;
import capsule.org.eclipse.aether.graph.Exclusion;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import java.util.Collection;

public class Dependencies {
    public static String toCapsuleRepositoryString(RemoteRepository rr) {
        return DependencyManager.WELL_KNOWN_REPOS.keySet().contains(rr.getId()) ? rr.getId() : rr.getUrl();
    }

    public static String toCapsuleDependencyString(Dependency d) {
        return Dependencies.toCapsuleArtifactString(d.getArtifact()) + Dependencies.toCapsuleExclusionsString(d.getExclusions());
    }

    private static String toCapsuleArtifactString(Artifact a) {
        return DependencyManager.artifactToCoords(a);
    }

    private static String toCapsuleExclusionsString(Collection<Exclusion> exclusions) {
        StringBuilder res = new StringBuilder();
        if (!exclusions.isEmpty()) {
            res.append("(");
            boolean starting = true;
            for (Exclusion e : exclusions) {
                if (!starting) {
                    res.append(",");
                } else {
                    starting = false;
                }
                res.append(e.getGroupId());
                res.append(":");
                if (e.getArtifactId() != null && e.getArtifactId().length() > 0) {
                    res.append(e.getArtifactId());
                    continue;
                }
                res.append("*");
            }
            res.append(")");
        }
        return res.toString();
    }
}

