/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.ConsoleDependencyGraphDumper;
import capsule.ConsoleRepositoryListener;
import capsule.ConsoleTransferListener;
import capsule.SystemProxySelector;
import capsule.UserSettings;
import capsule.io.takari.filemanager.FileManager;
import capsule.io.takari.filemanager.internal.DefaultFileManager;
import capsule.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import capsule.org.eclipse.aether.DefaultRepositorySystemSession;
import capsule.org.eclipse.aether.RepositoryException;
import capsule.org.eclipse.aether.RepositorySystem;
import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.artifact.Artifact;
import capsule.org.eclipse.aether.artifact.DefaultArtifact;
import capsule.org.eclipse.aether.collection.CollectRequest;
import capsule.org.eclipse.aether.collection.CollectResult;
import capsule.org.eclipse.aether.collection.DependencyCollectionException;
import capsule.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import capsule.org.eclipse.aether.graph.Dependency;
import capsule.org.eclipse.aether.graph.DependencyNode;
import capsule.org.eclipse.aether.graph.DependencyVisitor;
import capsule.org.eclipse.aether.graph.Exclusion;
import capsule.org.eclipse.aether.impl.DefaultServiceLocator;
import capsule.org.eclipse.aether.impl.SyncContextFactory;
import capsule.org.eclipse.aether.repository.LocalRepository;
import capsule.org.eclipse.aether.repository.Proxy;
import capsule.org.eclipse.aether.repository.ProxySelector;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.repository.RepositoryPolicy;
import capsule.org.eclipse.aether.resolution.DependencyRequest;
import capsule.org.eclipse.aether.resolution.DependencyResolutionException;
import capsule.org.eclipse.aether.resolution.DependencyResult;
import capsule.org.eclipse.aether.resolution.VersionRangeRequest;
import capsule.org.eclipse.aether.resolution.VersionRangeResult;
import capsule.org.eclipse.aether.resolution.VersionRequest;
import capsule.org.eclipse.aether.resolution.VersionResult;
import capsule.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import capsule.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import capsule.org.eclipse.aether.spi.io.FileProcessor;
import capsule.org.eclipse.aether.transport.file.FileTransporterFactory;
import capsule.org.eclipse.aether.transport.http.HttpTransporterFactory;
import capsule.org.eclipse.aether.util.graph.transformer.ConflictResolver;
import capsule.org.eclipse.aether.util.graph.transformer.JavaScopeDeriver;
import capsule.org.eclipse.aether.util.graph.transformer.JavaScopeSelector;
import capsule.org.eclipse.aether.util.graph.transformer.NearestVersionSelector;
import capsule.org.eclipse.aether.util.graph.transformer.SimpleOptionalitySelector;
import capsule.org.eclipse.aether.version.Version;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DependencyManager {
    static final Path DEFAULT_LOCAL_MAVEN = Paths.get(System.getProperty("user.home"), ".m2");
    static final Map<String, String> WELL_KNOWN_REPOS = Collections.unmodifiableMap(new HashMap<String, String>(){
        {
            this.put("central", "central(https://repo1.maven.org/maven2/)");
            this.put("central-http", "central(http://repo1.maven.org/maven2/)");
            this.put("jcenter", "jcenter(https://jcenter.bintray.com/)");
            this.put("jcenter-http", "jcenter(http://jcenter.bintray.com/)");
            this.put("local", "local(file:" + DEFAULT_LOCAL_MAVEN.resolve("repository") + ")");
        }
    });
    private final boolean forceRefresh;
    private final boolean offline;
    protected final RepositorySystem system;
    private final LocalRepository localRepo;
    private RepositorySystemSession session;
    private List<RemoteRepository> repos;
    private final int logLevel;
    private final UserSettings settings;
    private static final Pattern PAT_DEPENDENCY = Pattern.compile("(?<groupId>[^:\\(]+):(?<artifactId>[^:\\(]+)(:(?<version>\\(?[^:\\(]*))?(:(?<classifier>[^:\\(]+))?(\\((?<exclusions>[^\\(\\)]*)\\))?");
    private static final Pattern PAT_REPO = Pattern.compile("(?<id>[^(]+)(\\((?<url>[^\\)]+)\\))?");
    private static final FileManager takariFileManager = new DefaultFileManager();

    public DependencyManager(Path localRepoPath, boolean forceRefresh, int logLevel) {
        this.logLevel = logLevel;
        this.forceRefresh = forceRefresh;
        this.offline = DependencyManager.isPropertySet("capsule.offline", false);
        if (localRepoPath == null) {
            localRepoPath = DEFAULT_LOCAL_MAVEN.resolve("repository");
        }
        this.log(3, "DependencyManager - Offline: " + this.offline);
        this.log(3, "DependencyManager - Local repo: " + localRepoPath);
        this.localRepo = new LocalRepository(localRepoPath.toFile());
        this.settings = UserSettings.getInstance();
        this.system = DependencyManager.newRepositorySystem();
    }

    public final void setRepos(List<String> repos, boolean allowSnapshots) {
        if (repos == null) {
            repos = Arrays.asList("central");
        }
        ArrayList<RemoteRepository> rs = new ArrayList<RemoteRepository>();
        for (String r : repos) {
            RepositoryPolicy releasePolicy = this.maketReleasePolicy(r);
            RepositoryPolicy snapshotPolicy = allowSnapshots ? this.maketSnapshotPolicy(r) : new RepositoryPolicy(false, null, null);
            RemoteRepository repo = DependencyManager.createRepo(r, releasePolicy, snapshotPolicy);
            ProxySelector selector = this.getSession().getProxySelector();
            Proxy proxy = selector.getProxy(repo);
            if (proxy != null) {
                if (this.isLogging(3)) {
                    this.log(3, String.format("Setting proxy: '%s' for dependency: %s", proxy, repo));
                }
                repo = new RemoteRepository.Builder(repo).setProxy(proxy).build();
            }
            if (rs.contains(repo)) continue;
            rs.add(repo);
        }
        if (!Objects.equals(this.repos, rs)) {
            this.repos = rs;
            this.log(2, "Dependency manager repositories: " + this.repos);
        }
    }

    protected RepositoryPolicy maketReleasePolicy(String repo) {
        return new RepositoryPolicy(true, "never", "warn");
    }

    protected RepositoryPolicy maketSnapshotPolicy(String repo) {
        return this.maketReleasePolicy(repo);
    }

    private static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            @Override
            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable ex) {
                throw new RuntimeException("Service creation failed for type " + type.getName() + " with impl " + impl, ex);
            }
        });
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.setService(SyncContextFactory.class, LockingSyncContextFactory.class);
        locator.setService(FileProcessor.class, LockingFileProcessor.class);
        return locator.getService(RepositorySystem.class);
    }

    public RepositorySystemSession getSession() {
        if (this.session == null) {
            this.session = this.newRepositorySession(this.system, this.localRepo);
        }
        return this.session;
    }

    protected RepositorySystemSession newRepositorySession(RepositorySystem system, LocalRepository localRepo) {
        DefaultRepositorySystemSession s = MavenRepositorySystemUtils.newSession();
        s.setConfigProperty("aether.connector.connectTimeout", DependencyManager.propertyOrEnv("capsule.connect.timeout", "CAPSULE_CONNECT_TIMEOUT"));
        s.setConfigProperty("aether.connector.requestTimeout", DependencyManager.propertyOrEnv("capsule.request.timeout", "CAPSULE_REQUEST_TIMEOUT"));
        s.setConfigProperty("aether.conflictResolver.verbose", true);
        s.setOffline(this.offline);
        s.setUpdatePolicy(this.forceRefresh ? "always" : "never");
        s.setLocalRepositoryManager(system.newLocalRepositoryManager(s, localRepo));
        SystemProxySelector sysProxySelector = new SystemProxySelector(this.logLevel);
        s.setProxySelector(sysProxySelector.isValid() ? sysProxySelector : this.settings.getProxySelector());
        s.setMirrorSelector(this.settings.getMirrorSelector());
        s.setAuthenticationSelector(this.settings.getAuthSelector());
        s.setDependencyGraphTransformer(DependencyManager.newConflicResolver());
        if (this.logLevel > 0) {
            PrintStream out = DependencyManager.prefixStream(System.err, "CAPSULE: ");
            s.setTransferListener(new ConsoleTransferListener(this.isLogging(2), out));
            s.setRepositoryListener(new ConsoleRepositoryListener(this.isLogging(2), out));
        }
        return s;
    }

    private static ConflictResolver newConflicResolver() {
        return new ConflictResolver(new NearestVersionSelector(), new JavaScopeSelector(), new SimpleOptionalitySelector(), new JavaScopeDeriver());
    }

    private CollectRequest collect() {
        return new CollectRequest().setRepositories(this.repos);
    }

    public final void printDependencyTree(List<Dependency> deps, PrintStream out) {
        this.printDependencyTree(this.collect().setDependencies(deps), out);
    }

    public final void printDependencyTree(String coords, String type, PrintStream out) {
        this.printDependencyTree(this.collect().setRoot(DependencyManager.toDependency(coords, type)), out);
    }

    private void printDependencyTree(CollectRequest collectRequest, PrintStream out) {
        try {
            CollectResult collectResult = this.system.collectDependencies(this.getSession(), collectRequest);
            collectResult.getRoot().accept(new ConsoleDependencyGraphDumper(out));
        }
        catch (DependencyCollectionException e) {
            throw new RuntimeException(e);
        }
    }

    public final Map<Dependency, List<Path>> resolveDependencies(List<Dependency> deps) {
        HashMap<Dependency, List<Path>> resolved = new HashMap<Dependency, List<Path>>();
        List<DependencyNode> children = this.resolve0(this.collect().setDependencies(deps)).getRoot().getChildren();
        for (DependencyNode dn : children) {
            final ArrayList jars = new ArrayList();
            resolved.put(this.clean(dn.getDependency()), jars);
            dn.accept(new DependencyVisitor(){

                @Override
                public boolean visitEnter(DependencyNode node) {
                    jars.add(DependencyManager.path(node.getArtifact()));
                    return true;
                }

                @Override
                public boolean visitLeave(DependencyNode node) {
                    return true;
                }
            });
        }
        return resolved;
    }

    private Dependency clean(Dependency d) {
        Artifact a = d.getArtifact();
        return new Dependency((Artifact)new DefaultArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier(), a.getExtension(), a.getBaseVersion()), d.getScope(), d.getOptional(), d.getExclusions());
    }

    protected DependencyResult resolve0(CollectRequest collectRequest) {
        if (this.isLogging(3)) {
            this.log(3, "DependencyManager.resolve " + collectRequest);
        }
        try {
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, null);
            DependencyResult result = this.system.resolveDependencies(this.getSession(), dependencyRequest);
            if (this.isLogging(3)) {
                this.log(3, "DependencyManager.resolve: " + result);
            }
            return result;
        }
        catch (DependencyResolutionException e) {
            throw new RuntimeException("Error resolving dependencies.", e);
        }
    }

    private static Path path(Artifact artifact) {
        return artifact.getFile().toPath().toAbsolutePath();
    }

    public final String getLatestVersion(String coords, String type) {
        return DependencyManager.artifactToCoords(this.getLatestVersion0(coords, type));
    }

    protected Artifact getLatestVersion0(String coords, String type) {
        try {
            String version;
            Artifact artifact = DependencyManager.coordsToArtifact(coords, type);
            if (DependencyManager.isVersionRange(artifact.getVersion())) {
                VersionRangeRequest request = new VersionRangeRequest().setRepositories(this.repos).setArtifact(artifact);
                VersionRangeResult result = this.system.resolveVersionRange(this.getSession(), request);
                Version highestVersion = result.getHighestVersion();
                version = highestVersion != null ? highestVersion.toString() : null;
            } else {
                VersionRequest request = new VersionRequest().setRepositories(this.repos).setArtifact(artifact);
                VersionResult result = this.system.resolveVersion(this.getSession(), request);
                version = result.getVersion();
            }
            if (version == null) {
                throw new RuntimeException("Could not find any version of artifact " + coords + " (looking for: " + artifact + ")");
            }
            return artifact.setVersion(version);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public static final Dependency toDependency(String coords, String type) {
        return new Dependency(DependencyManager.coordsToArtifact(coords, type), "runtime", false, DependencyManager.getExclusions(coords));
    }

    static String artifactToCoords(Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty() ? ":" + artifact.getClassifier() : "");
    }

    private static boolean isVersionRange(String version) {
        return version.startsWith("(") || version.startsWith("[");
    }

    private static Artifact coordsToArtifact(String depString, String type) {
        Matcher m = PAT_DEPENDENCY.matcher(depString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse dependency: " + depString);
        }
        String groupId = m.group("groupId");
        String artifactId = m.group("artifactId");
        String version = m.group("version");
        if (version == null || version.isEmpty()) {
            version = "[0,)";
        }
        String classifier = m.group("classifier");
        return new DefaultArtifact(groupId, artifactId, classifier, type, version);
    }

    private static Collection<Exclusion> getExclusions(String depString) {
        Matcher m = PAT_DEPENDENCY.matcher(depString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse dependency: " + depString);
        }
        if (m.group("exclusions") == null || m.group("exclusions").isEmpty()) {
            return null;
        }
        List<String> exclusionPatterns = Arrays.asList(m.group("exclusions").split(","));
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>();
        for (String ex : exclusionPatterns) {
            String[] coords = ex.trim().split(":");
            if (coords.length != 2) {
                throw new IllegalArgumentException("Illegal exclusion dependency coordinates: " + depString + " (in exclusion " + ex + ")");
            }
            exclusions.add(new Exclusion(coords[0], coords[1], "*", "*"));
        }
        return exclusions;
    }

    static RemoteRepository createRepo(String repo, RepositoryPolicy releasePolicy, RepositoryPolicy snapshotPolicy) {
        Matcher m = PAT_REPO.matcher(repo);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse repository: " + repo);
        }
        String id = m.group("id");
        String url = m.group("url");
        if (url == null && WELL_KNOWN_REPOS.containsKey(id)) {
            return DependencyManager.createRepo(WELL_KNOWN_REPOS.get(id), releasePolicy, snapshotPolicy);
        }
        if (url == null) {
            url = id;
        }
        if (url.startsWith("file:")) {
            snapshotPolicy = releasePolicy = new RepositoryPolicy(releasePolicy.isEnabled(), releasePolicy.getUpdatePolicy(), "ignore");
        }
        return new RemoteRepository.Builder(id, "default", url).setReleasePolicy(releasePolicy).setSnapshotPolicy(snapshotPolicy).build();
    }

    private static PrintStream prefixStream(PrintStream out, final String prefix) {
        return new PrintStream((OutputStream)out){

            @Override
            public void println(String x) {
                super.println(prefix + x);
            }
        };
    }

    private static String propertyOrEnv(String propName, String envVar) {
        String val = System.getProperty(propName);
        if (val == null) {
            val = DependencyManager.emptyToNull(System.getenv(envVar));
        }
        return val;
    }

    private static Boolean isPropertySet(String property, boolean defaultValue) {
        String val = System.getProperty(property);
        if (val == null) {
            return defaultValue;
        }
        return "".equals(val) | Boolean.parseBoolean(val);
    }

    static String emptyToNull(String s) {
        if (s == null) {
            return null;
        }
        return (s = s.trim()).isEmpty() ? null : s;
    }

    protected final boolean isLogging(int level) {
        return level <= this.logLevel;
    }

    protected final void log(int level, String str) {
        if (this.isLogging(level)) {
            System.err.println("CAPSULE: " + str);
        }
    }

    public static class LockingSyncContextFactory
    extends capsule.io.takari.aether.concurrency.LockingSyncContextFactory {
        public LockingSyncContextFactory() {
            super(takariFileManager);
        }
    }

    public static class LockingFileProcessor
    extends capsule.io.takari.aether.concurrency.LockingFileProcessor {
        public LockingFileProcessor() {
            super(takariFileManager);
        }
    }
}

