/*
 * Decompiled with CFR 0.152.
 */
package capsule;

import capsule.org.apache.maven.model.Dependency;
import capsule.org.apache.maven.model.Exclusion;
import capsule.org.apache.maven.model.Model;
import capsule.org.apache.maven.model.Repository;
import capsule.org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class PomReader {
    private final Model pom;

    public PomReader(InputStream is) {
        try {
            this.pom = new MavenXpp3Reader().read(is);
        }
        catch (Exception e) {
            throw new RuntimeException("Error trying to read pom.", e);
        }
    }

    public String getArtifactId() {
        return this.pom.getArtifactId();
    }

    public String getGroupId() {
        return this.pom.getGroupId();
    }

    public String getVersion() {
        return this.pom.getVersion();
    }

    public List<String> getRepositories() {
        List<Repository> repos = this.pom.getRepositories();
        if (repos == null) {
            return null;
        }
        ArrayList<String> repositories = new ArrayList<String>(repos.size());
        for (Repository repo : repos) {
            repositories.add(PomReader.convert(repo));
        }
        return repositories;
    }

    public List<String[]> getDependencies() {
        List<Dependency> deps = this.pom.getDependencies();
        if (deps == null) {
            return null;
        }
        ArrayList<String[]> dependencies = new ArrayList<String[]>(deps.size());
        for (Dependency dep : deps) {
            if (!PomReader.includeDependency(dep)) continue;
            dependencies.add(new String[]{PomReader.convert(dep), dep.getType()});
        }
        return dependencies;
    }

    private static boolean includeDependency(Dependency dep) {
        if (dep.isOptional()) {
            return false;
        }
        if (dep.getScope() == null || dep.getScope().isEmpty()) {
            return true;
        }
        switch (dep.getScope().toLowerCase()) {
            case "compile": 
            case "runtime": {
                return true;
            }
        }
        return false;
    }

    private static String convert(Dependency dep) {
        return PomReader.dep2coords(dep) + PomReader.exclusions2desc(dep);
    }

    private static String dep2coords(Dependency dep) {
        return dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion() + (dep.getClassifier() != null && !dep.getClassifier().isEmpty() ? ":" + dep.getClassifier() : "");
    }

    private static String exclusions2desc(Dependency dep) {
        List<Exclusion> exclusions = dep.getExclusions();
        if (exclusions == null || exclusions.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        for (Exclusion ex : exclusions) {
            sb.append(PomReader.exclusion2coord(ex)).append(',');
        }
        sb.delete(sb.length() - 1, sb.length());
        sb.append(')');
        return sb.toString();
    }

    private static String exclusion2coord(Exclusion ex) {
        return ex.getGroupId() + ":" + ex.getArtifactId();
    }

    private static String convert(Repository repo) {
        if (repo.getId() != null && !repo.getId().isEmpty()) {
            return repo.getId() + "(" + repo.getUrl() + ")";
        }
        return repo.getUrl();
    }
}

