/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.client.protocol;

import capsule.org.apache.commons.logging.Log;
import capsule.org.apache.commons.logging.LogFactory;
import capsule.org.apache.http.HttpException;
import capsule.org.apache.http.HttpRequest;
import capsule.org.apache.http.HttpRequestInterceptor;
import capsule.org.apache.http.conn.HttpRoutedConnection;
import capsule.org.apache.http.conn.routing.HttpRoute;
import capsule.org.apache.http.protocol.HttpContext;
import java.io.IOException;

public class RequestClientConnControl
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            request.setHeader("Proxy-Connection", "Keep-Alive");
            return;
        }
        HttpRoutedConnection conn = (HttpRoutedConnection)context.getAttribute("http.connection");
        if (conn == null) {
            this.log.debug("HTTP connection not set in the context");
            return;
        }
        HttpRoute route = conn.getRoute();
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
        if (route.getHopCount() == 2 && !route.isTunnelled() && !request.containsHeader("Proxy-Connection")) {
            request.addHeader("Proxy-Connection", "Keep-Alive");
        }
    }
}

