/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.client.protocol;

import capsule.org.apache.http.HttpException;
import capsule.org.apache.http.HttpRequest;
import capsule.org.apache.http.auth.AuthState;
import capsule.org.apache.http.client.protocol.RequestAuthenticationBase;
import capsule.org.apache.http.protocol.HttpContext;
import java.io.IOException;

public class RequestTargetAuthentication
extends RequestAuthenticationBase {
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (request.containsHeader("Authorization")) {
            return;
        }
        AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (authState == null) {
            this.log.debug("Target auth state not set in the context");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Target auth state: " + (Object)((Object)authState.getState()));
        }
        this.process(authState, request, context);
    }
}

