/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.client.protocol;

import capsule.org.apache.http.Header;
import capsule.org.apache.http.HeaderElement;
import capsule.org.apache.http.HttpEntity;
import capsule.org.apache.http.HttpException;
import capsule.org.apache.http.HttpResponse;
import capsule.org.apache.http.HttpResponseInterceptor;
import capsule.org.apache.http.client.entity.DeflateDecompressingEntity;
import capsule.org.apache.http.client.entity.GzipDecompressingEntity;
import capsule.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        HeaderElement[] codecs;
        HeaderElement[] arr$;
        int len$;
        int i$;
        Header ceheader;
        HttpEntity entity = response.getEntity();
        if (entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null && (i$ = 0) < (len$ = (arr$ = (codecs = ceheader.getElements())).length)) {
            HeaderElement codec = arr$[i$];
            String codecname = codec.getName().toLowerCase(Locale.US);
            if ("gzip".equals(codecname) || "x-gzip".equals(codecname)) {
                response.setEntity(new GzipDecompressingEntity(response.getEntity()));
                if (context != null) {
                    context.setAttribute("http.client.response.uncompressed", true);
                }
                return;
            }
            if ("deflate".equals(codecname)) {
                response.setEntity(new DeflateDecompressingEntity(response.getEntity()));
                if (context != null) {
                    context.setAttribute("http.client.response.uncompressed", true);
                }
                return;
            }
            if ("identity".equals(codecname)) {
                return;
            }
            throw new HttpException("Unsupported Content-Coding: " + codec.getName());
        }
    }
}

