/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.conn.ssl;

import capsule.org.apache.http.conn.ConnectTimeoutException;
import capsule.org.apache.http.conn.HttpInetSocketAddress;
import capsule.org.apache.http.conn.scheme.HostNameResolver;
import capsule.org.apache.http.conn.scheme.LayeredSchemeSocketFactory;
import capsule.org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import capsule.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import capsule.org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import capsule.org.apache.http.conn.ssl.SSLInitializationException;
import capsule.org.apache.http.conn.ssl.StrictHostnameVerifier;
import capsule.org.apache.http.conn.ssl.X509HostnameVerifier;
import capsule.org.apache.http.params.HttpConnectionParams;
import capsule.org.apache.http.params.HttpParams;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;

public class SSLSocketFactory
implements LayeredSchemeSocketFactory,
SchemeLayeredSocketFactory {
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = new AllowAllHostnameVerifier();
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = new BrowserCompatHostnameVerifier();
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = new StrictHostnameVerifier();
    private final javax.net.ssl.SSLSocketFactory socketfactory;
    private final HostNameResolver nameResolver;
    private volatile X509HostnameVerifier hostnameVerifier;

    public static SSLSocketFactory getSocketFactory() throws SSLInitializationException {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, null, null);
            return new SSLSocketFactory(sslcontext, BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
        catch (KeyManagementException ex) {
            throw new SSLInitializationException(ex.getMessage(), ex);
        }
    }

    public SSLSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        if (sslContext == null) {
            throw new IllegalArgumentException("SSL context may not be null");
        }
        this.socketfactory = sslContext.getSocketFactory();
        this.hostnameVerifier = hostnameVerifier;
        this.nameResolver = null;
    }

    public SSLSocketFactory(javax.net.ssl.SSLSocketFactory socketfactory, X509HostnameVerifier hostnameVerifier) {
        if (socketfactory == null) {
            throw new IllegalArgumentException("SSL socket factory may not be null");
        }
        this.socketfactory = socketfactory;
        this.hostnameVerifier = hostnameVerifier;
        this.nameResolver = null;
    }

    public Socket createSocket(HttpParams params) throws IOException {
        SSLSocket sock = (SSLSocket)this.socketfactory.createSocket();
        this.prepareSocket(sock);
        return sock;
    }

    public Socket connectSocket(Socket socket, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sslsock;
        Socket sock;
        if (remoteAddress == null) {
            throw new IllegalArgumentException("Remote address may not be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        Socket socket2 = sock = socket != null ? socket : this.socketfactory.createSocket();
        if (localAddress != null) {
            sock.setReuseAddress(HttpConnectionParams.getSoReuseaddr(params));
            sock.bind(localAddress);
        }
        int connTimeout = HttpConnectionParams.getConnectionTimeout(params);
        int soTimeout = HttpConnectionParams.getSoTimeout(params);
        try {
            sock.setSoTimeout(soTimeout);
            sock.connect(remoteAddress, connTimeout);
        }
        catch (SocketTimeoutException ex) {
            throw new ConnectTimeoutException("Connect to " + remoteAddress + " timed out", ex);
        }
        String hostname = remoteAddress instanceof HttpInetSocketAddress ? ((HttpInetSocketAddress)remoteAddress).getHttpHost().getHostName() : remoteAddress.getHostName();
        if (sock instanceof SSLSocket) {
            sslsock = (SSLSocket)sock;
        } else {
            int port = remoteAddress.getPort();
            sslsock = (SSLSocket)this.socketfactory.createSocket(sock, hostname, port, true);
            this.prepareSocket(sslsock);
        }
        sslsock.startHandshake();
        if (this.hostnameVerifier != null) {
            try {
                this.hostnameVerifier.verify(hostname, sslsock);
            }
            catch (IOException iox) {
                try {
                    sslsock.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
                throw iox;
            }
        }
        return sslsock;
    }

    public boolean isSecure(Socket sock) throws IllegalArgumentException {
        if (sock == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (!(sock instanceof SSLSocket)) {
            throw new IllegalArgumentException("Socket not created by this factory");
        }
        if (sock.isClosed()) {
            throw new IllegalArgumentException("Socket is closed");
        }
        return true;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, HttpParams params) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.socketfactory.createSocket(socket, host, port, true);
        this.prepareSocket(sslSocket);
        sslSocket.startHandshake();
        if (this.hostnameVerifier != null) {
            this.hostnameVerifier.verify(host, sslSocket);
        }
        return sslSocket;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)this.socketfactory.createSocket(socket, host, port, autoClose);
        this.prepareSocket(sslSocket);
        sslSocket.startHandshake();
        if (this.hostnameVerifier != null) {
            this.hostnameVerifier.verify(host, sslSocket);
        }
        return sslSocket;
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
    }
}

