/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl.client;

import capsule.org.apache.http.HttpVersion;
import capsule.org.apache.http.client.protocol.RequestAddCookies;
import capsule.org.apache.http.client.protocol.RequestAuthCache;
import capsule.org.apache.http.client.protocol.RequestClientConnControl;
import capsule.org.apache.http.client.protocol.RequestDefaultHeaders;
import capsule.org.apache.http.client.protocol.RequestProxyAuthentication;
import capsule.org.apache.http.client.protocol.RequestTargetAuthentication;
import capsule.org.apache.http.client.protocol.ResponseProcessCookies;
import capsule.org.apache.http.conn.ClientConnectionManager;
import capsule.org.apache.http.impl.client.AbstractHttpClient;
import capsule.org.apache.http.params.HttpConnectionParams;
import capsule.org.apache.http.params.HttpParams;
import capsule.org.apache.http.params.HttpProtocolParams;
import capsule.org.apache.http.params.SyncBasicHttpParams;
import capsule.org.apache.http.protocol.BasicHttpProcessor;
import capsule.org.apache.http.protocol.HTTP;
import capsule.org.apache.http.protocol.RequestContent;
import capsule.org.apache.http.protocol.RequestExpectContinue;
import capsule.org.apache.http.protocol.RequestTargetHost;
import capsule.org.apache.http.protocol.RequestUserAgent;
import capsule.org.apache.http.util.VersionInfo;

public class DefaultHttpClient
extends AbstractHttpClient {
    public DefaultHttpClient(ClientConnectionManager conman) {
        super(conman, null);
    }

    public DefaultHttpClient() {
        super(null, null);
    }

    protected HttpParams createHttpParams() {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        DefaultHttpClient.setDefaultHttpParams(params);
        return params;
    }

    public static void setDefaultHttpParams(HttpParams params) {
        HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset(params, HTTP.DEF_CONTENT_CHARSET.name());
        HttpConnectionParams.setTcpNoDelay(params, true);
        HttpConnectionParams.setSocketBufferSize(params, 8192);
        VersionInfo vi = VersionInfo.loadVersionInfo("capsule.org.apache.http.client", DefaultHttpClient.class.getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        HttpProtocolParams.setUserAgent(params, "Apache-HttpClient/" + release + " (java 1.5)");
    }

    protected BasicHttpProcessor createHttpProcessor() {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor(new RequestDefaultHeaders());
        httpproc.addInterceptor(new RequestContent());
        httpproc.addInterceptor(new RequestTargetHost());
        httpproc.addInterceptor(new RequestClientConnControl());
        httpproc.addInterceptor(new RequestUserAgent());
        httpproc.addInterceptor(new RequestExpectContinue());
        httpproc.addInterceptor(new RequestAddCookies());
        httpproc.addInterceptor(new ResponseProcessCookies());
        httpproc.addInterceptor(new RequestAuthCache());
        httpproc.addInterceptor(new RequestTargetAuthentication());
        httpproc.addInterceptor(new RequestProxyAuthentication());
        return httpproc;
    }
}

