/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl.client;

import capsule.org.apache.http.auth.AuthScheme;
import capsule.org.apache.http.auth.AuthState;
import capsule.org.apache.http.auth.Credentials;
import capsule.org.apache.http.client.UserTokenHandler;
import capsule.org.apache.http.conn.HttpRoutedConnection;
import capsule.org.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

public class DefaultUserTokenHandler
implements UserTokenHandler {
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpRoutedConnection conn;
        Principal userPrincipal = null;
        AuthState targetAuthState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (targetAuthState != null && (userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = (AuthState)context.getAttribute("http.auth.proxy-scope");
            userPrincipal = DefaultUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = (HttpRoutedConnection)context.getAttribute("http.connection")).isOpen() && (sslsession = conn.getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

