/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.http.impl.io;

import capsule.org.apache.http.HttpException;
import capsule.org.apache.http.HttpResponse;
import capsule.org.apache.http.HttpResponseFactory;
import capsule.org.apache.http.NoHttpResponseException;
import capsule.org.apache.http.ParseException;
import capsule.org.apache.http.StatusLine;
import capsule.org.apache.http.impl.io.AbstractMessageParser;
import capsule.org.apache.http.io.SessionInputBuffer;
import capsule.org.apache.http.message.LineParser;
import capsule.org.apache.http.message.ParserCursor;
import capsule.org.apache.http.params.HttpParams;
import capsule.org.apache.http.util.CharArrayBuffer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, parser, params);
        if (responseFactory == null) {
            throw new IllegalArgumentException("Response factory may not be null");
        }
        this.responseFactory = responseFactory;
        this.lineBuf = new CharArrayBuffer(128);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int i = sessionBuffer.readLine(this.lineBuf);
        if (i == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

