/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model;

import capsule.org.apache.maven.model.InputLocation;
import capsule.org.apache.maven.model.InputLocationTracker;
import capsule.org.codehaus.plexus.util.xml.Xpp3Dom;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

public class ConfigurationContainer
implements InputLocationTracker,
Serializable,
Cloneable {
    private String inherited;
    private Object configuration;
    private Map<Object, InputLocation> locations;
    private boolean inheritanceApplied = true;

    public ConfigurationContainer clone() {
        try {
            ConfigurationContainer copy = (ConfigurationContainer)super.clone();
            if (this.configuration != null) {
                copy.configuration = new Xpp3Dom((Xpp3Dom)this.configuration);
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public String getInherited() {
        return this.inherited;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public void setConfiguration(Object configuration) {
        this.configuration = configuration;
    }

    public void setInherited(String inherited) {
        this.inherited = inherited;
    }

    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public boolean isInherited() {
        return this.inherited != null ? Boolean.parseBoolean(this.inherited) : true;
    }
}

