/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model;

import capsule.org.apache.maven.model.InputLocation;
import capsule.org.apache.maven.model.InputLocationTracker;
import capsule.org.apache.maven.model.ReportPlugin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Reporting
implements InputLocationTracker,
Serializable,
Cloneable {
    private String excludeDefaults;
    private String outputDirectory;
    private List<ReportPlugin> plugins;
    private Map<Object, InputLocation> locations;

    public Reporting clone() {
        try {
            Reporting copy = (Reporting)super.clone();
            if (this.plugins != null) {
                copy.plugins = new ArrayList<ReportPlugin>();
                for (ReportPlugin item : this.plugins) {
                    copy.plugins.add(item.clone());
                }
            }
            if (copy.locations != null) {
                copy.locations = new LinkedHashMap<Object, InputLocation>(copy.locations);
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getExcludeDefaults() {
        return this.excludeDefaults;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public List<ReportPlugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<ReportPlugin>();
        }
        return this.plugins;
    }

    public void setExcludeDefaults(String excludeDefaults) {
        this.excludeDefaults = excludeDefaults;
    }

    public void setLocation(Object key, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location);
        }
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setPlugins(List<ReportPlugin> plugins) {
        this.plugins = plugins;
    }

    public boolean isExcludeDefaults() {
        return this.excludeDefaults != null ? Boolean.parseBoolean(this.excludeDefaults) : false;
    }
}

