/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model.building;

import capsule.org.apache.maven.model.Model;
import capsule.org.apache.maven.model.Profile;
import capsule.org.apache.maven.model.building.ModelBuildingResult;
import capsule.org.apache.maven.model.building.ModelProblem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DefaultModelBuildingResult
implements ModelBuildingResult {
    private Model effectiveModel;
    private List<String> modelIds = new ArrayList<String>();
    private Map<String, Model> rawModels = new HashMap<String, Model>();
    private Map<String, List<Profile>> activePomProfiles = new HashMap<String, List<Profile>>();
    private List<Profile> activeExternalProfiles = new ArrayList<Profile>();
    private List<ModelProblem> problems = new ArrayList<ModelProblem>();

    @Override
    public Model getEffectiveModel() {
        return this.effectiveModel;
    }

    public DefaultModelBuildingResult setEffectiveModel(Model model) {
        this.effectiveModel = model;
        return this;
    }

    @Override
    public List<String> getModelIds() {
        return this.modelIds;
    }

    public DefaultModelBuildingResult addModelId(String modelId) {
        if (modelId == null) {
            throw new IllegalArgumentException("no model identifier specified");
        }
        this.modelIds.add(modelId);
        return this;
    }

    public DefaultModelBuildingResult setRawModel(String modelId, Model rawModel) {
        if (modelId == null) {
            throw new IllegalArgumentException("no model identifier specified");
        }
        this.rawModels.put(modelId, rawModel);
        return this;
    }

    public DefaultModelBuildingResult setActivePomProfiles(String modelId, List<Profile> activeProfiles) {
        if (modelId == null) {
            throw new IllegalArgumentException("no model identifier specified");
        }
        if (activeProfiles != null) {
            this.activePomProfiles.put(modelId, new ArrayList<Profile>(activeProfiles));
        } else {
            this.activePomProfiles.remove(modelId);
        }
        return this;
    }

    @Override
    public List<Profile> getActiveExternalProfiles() {
        return this.activeExternalProfiles;
    }

    public DefaultModelBuildingResult setActiveExternalProfiles(List<Profile> activeProfiles) {
        if (activeProfiles != null) {
            this.activeExternalProfiles = new ArrayList<Profile>(activeProfiles);
        } else {
            this.activeExternalProfiles.clear();
        }
        return this;
    }

    @Override
    public List<ModelProblem> getProblems() {
        return this.problems;
    }

    public DefaultModelBuildingResult setProblems(List<ModelProblem> problems) {
        if (problems != null) {
            this.problems = new ArrayList<ModelProblem>(problems);
        } else {
            this.problems.clear();
        }
        return this;
    }
}

