/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model.inheritance;

import capsule.org.apache.maven.model.Model;
import capsule.org.apache.maven.model.Plugin;
import capsule.org.apache.maven.model.PluginContainer;
import capsule.org.apache.maven.model.ReportPlugin;
import capsule.org.apache.maven.model.Reporting;
import capsule.org.apache.maven.model.building.ModelBuildingRequest;
import capsule.org.apache.maven.model.building.ModelProblemCollector;
import capsule.org.apache.maven.model.inheritance.InheritanceAssembler;
import capsule.org.apache.maven.model.merge.MavenModelMerger;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultInheritanceAssembler
implements InheritanceAssembler {
    private InheritanceModelMerger merger = new InheritanceModelMerger();

    @Override
    public void assembleModelInheritance(Model child, Model parent, ModelBuildingRequest request, ModelProblemCollector problems) {
        HashMap<String, String> hints = new HashMap<String, String>();
        hints.put("child-path-adjustment", this.getChildPathAdjustment(child, parent));
        this.merger.merge(child, parent, false, hints);
    }

    private String getChildPathAdjustment(Model child, Model parent) {
        String adjustment = "";
        if (parent != null) {
            String childName = child.getArtifactId();
            File childDirectory = child.getProjectDirectory();
            if (childDirectory != null) {
                childName = childDirectory.getName();
            }
            for (String module : parent.getModules()) {
                int lastSlash;
                String moduleName;
                if ((module = module.replace('\\', '/')).regionMatches(true, module.length() - 4, ".xml", 0, 4)) {
                    module = module.substring(0, module.lastIndexOf(47) + 1);
                }
                if ((moduleName = module).endsWith("/")) {
                    moduleName = moduleName.substring(0, moduleName.length() - 1);
                }
                if (!(moduleName = moduleName.substring((lastSlash = moduleName.lastIndexOf(47)) + 1)).equals(childName) || lastSlash < 0) continue;
                adjustment = module.substring(0, lastSlash);
                break;
            }
        }
        return adjustment;
    }

    protected static class InheritanceModelMerger
    extends MavenModelMerger {
        protected InheritanceModelMerger() {
        }

        @Override
        protected void mergePluginContainer_Plugins(PluginContainer target, PluginContainer source, boolean sourceDominant, Map<Object, Object> context) {
            List<Plugin> src = source.getPlugins();
            if (!src.isEmpty()) {
                List<Plugin> tgt = target.getPlugins();
                LinkedHashMap<Object, Plugin> master = new LinkedHashMap<Object, Plugin>(src.size() * 2);
                for (Plugin element : src) {
                    if (!element.isInherited() && element.getExecutions().isEmpty()) continue;
                    Plugin plugin = new Plugin();
                    plugin.setLocation("", element.getLocation(""));
                    plugin.setGroupId(null);
                    this.mergePlugin(plugin, element, sourceDominant, context);
                    Object key = this.getPluginKey(element);
                    master.put(key, plugin);
                }
                LinkedHashMap predecessors = new LinkedHashMap();
                ArrayList<Plugin> pending = new ArrayList<Plugin>();
                for (Plugin element : tgt) {
                    Object key = this.getPluginKey(element);
                    Plugin existing = (Plugin)master.get(key);
                    if (existing != null) {
                        this.mergePlugin(element, existing, sourceDominant, context);
                        master.put(key, element);
                        if (pending.isEmpty()) continue;
                        predecessors.put(key, pending);
                        pending = new ArrayList();
                        continue;
                    }
                    pending.add(element);
                }
                ArrayList<Plugin> result = new ArrayList<Plugin>(src.size() + tgt.size());
                for (Map.Entry entry : master.entrySet()) {
                    List pre = (List)predecessors.get(entry.getKey());
                    if (pre != null) {
                        result.addAll(pre);
                    }
                    result.add((Plugin)entry.getValue());
                }
                result.addAll(pending);
                target.setPlugins(result);
            }
        }

        @Override
        protected void mergePlugin(Plugin target, Plugin source, boolean sourceDominant, Map<Object, Object> context) {
            if (source.isInherited()) {
                this.mergeConfigurationContainer(target, source, sourceDominant, context);
            }
            this.mergePlugin_GroupId(target, source, sourceDominant, context);
            this.mergePlugin_ArtifactId(target, source, sourceDominant, context);
            this.mergePlugin_Version(target, source, sourceDominant, context);
            this.mergePlugin_Extensions(target, source, sourceDominant, context);
            this.mergePlugin_Dependencies(target, source, sourceDominant, context);
            this.mergePlugin_Executions(target, source, sourceDominant, context);
        }

        @Override
        protected void mergeReporting_Plugins(Reporting target, Reporting source, boolean sourceDominant, Map<Object, Object> context) {
            List<ReportPlugin> src = source.getPlugins();
            if (!src.isEmpty()) {
                Object key;
                List<ReportPlugin> tgt = target.getPlugins();
                LinkedHashMap<Object, ReportPlugin> merged = new LinkedHashMap<Object, ReportPlugin>((src.size() + tgt.size()) * 2);
                for (ReportPlugin element : src) {
                    key = this.getReportPluginKey(element);
                    if (!element.isInherited()) continue;
                    ReportPlugin plugin = new ReportPlugin();
                    plugin.setLocation("", element.getLocation(""));
                    plugin.setGroupId(null);
                    this.mergeReportPlugin(plugin, element, sourceDominant, context);
                    merged.put(key, plugin);
                }
                for (ReportPlugin element : tgt) {
                    key = this.getReportPluginKey(element);
                    ReportPlugin existing = (ReportPlugin)merged.get(key);
                    if (existing != null) {
                        this.mergeReportPlugin(element, existing, sourceDominant, context);
                    }
                    merged.put(key, element);
                }
                target.setPlugins(new ArrayList<ReportPlugin>(merged.values()));
            }
        }
    }
}

