/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.apache.maven.model.interpolation;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;

public class MavenBuildTimestamp {
    private String formattedTimestamp;

    public MavenBuildTimestamp() {
        this(new Date());
    }

    public MavenBuildTimestamp(Date time) {
        this(time, "yyyy-MM-dd'T'HH:mm:ss'Z'");
    }

    public MavenBuildTimestamp(Date time, Properties properties) {
        this(time, properties != null ? properties.getProperty("maven.build.timestamp.format") : null);
    }

    public MavenBuildTimestamp(Date time, String timestampFormat) {
        if (timestampFormat == null) {
            timestampFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        }
        if (time == null) {
            time = new Date();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(timestampFormat);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.formattedTimestamp = dateFormat.format(time);
    }

    public String formattedTimestamp() {
        return this.formattedTimestamp;
    }
}

