/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.impl.Installer;
import capsule.org.eclipse.aether.impl.MetadataGeneratorFactory;
import capsule.org.eclipse.aether.impl.RepositoryEventDispatcher;
import capsule.org.eclipse.aether.impl.SyncContextFactory;
import capsule.org.eclipse.aether.spi.io.FileProcessor;
import capsule.org.eclipse.aether.spi.locator.Service;
import capsule.org.eclipse.aether.spi.locator.ServiceLocator;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.spi.log.LoggerFactory;
import capsule.org.eclipse.aether.spi.log.NullLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultInstaller
implements Installer,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private FileProcessor fileProcessor;
    private RepositoryEventDispatcher repositoryEventDispatcher;
    private Collection<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    private SyncContextFactory syncContextFactory;

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setFileProcessor(locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher(locator.getService(RepositoryEventDispatcher.class));
        this.setMetadataGeneratorFactories(locator.getServices(MetadataGeneratorFactory.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultInstaller setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultInstaller setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public DefaultInstaller setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultInstaller setMetadataGeneratorFactories(Collection<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    public DefaultInstaller setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }
}

