/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.impl.OfflineController;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.spi.locator.Service;
import capsule.org.eclipse.aether.spi.locator.ServiceLocator;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.spi.log.LoggerFactory;
import capsule.org.eclipse.aether.spi.log.NullLoggerFactory;
import capsule.org.eclipse.aether.transfer.RepositoryOfflineException;
import capsule.org.eclipse.aether.util.ConfigUtils;
import java.util.regex.Pattern;
import javax.inject.Named;

@Named
public class DefaultOfflineController
implements OfflineController,
Service {
    private static final Pattern SEP = Pattern.compile("\\s*,\\s*");
    private Logger logger = NullLoggerFactory.LOGGER;

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
    }

    public DefaultOfflineController setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public void checkOffline(RepositorySystemSession session, RemoteRepository repository) throws RepositoryOfflineException {
        if (this.isOfflineProtocol(session, repository) || this.isOfflineHost(session, repository)) {
            return;
        }
        throw new RepositoryOfflineException(repository);
    }

    private boolean isOfflineProtocol(RepositorySystemSession session, RemoteRepository repository) {
        String protocol;
        String[] protocols = this.getConfig(session, "aether.offline.protocols");
        if (protocols != null && (protocol = repository.getProtocol()).length() > 0) {
            for (String p : protocols) {
                if (!p.equalsIgnoreCase(protocol)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOfflineHost(RepositorySystemSession session, RemoteRepository repository) {
        String host;
        String[] hosts = this.getConfig(session, "aether.offline.hosts");
        if (hosts != null && (host = repository.getHost()).length() > 0) {
            for (String h : hosts) {
                if (!h.equalsIgnoreCase(host)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getConfig(RepositorySystemSession session, String key) {
        String value = ConfigUtils.getString(session, "", key).trim();
        if (value.length() <= 0) {
            return null;
        }
        return SEP.split(value);
    }
}

