/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.impl.RepositoryConnectorProvider;
import capsule.org.eclipse.aether.internal.impl.PrioritizedComponent;
import capsule.org.eclipse.aether.internal.impl.PrioritizedComponents;
import capsule.org.eclipse.aether.internal.impl.Utils;
import capsule.org.eclipse.aether.repository.Authentication;
import capsule.org.eclipse.aether.repository.Proxy;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.spi.connector.RepositoryConnector;
import capsule.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import capsule.org.eclipse.aether.spi.locator.Service;
import capsule.org.eclipse.aether.spi.locator.ServiceLocator;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.spi.log.LoggerFactory;
import capsule.org.eclipse.aether.spi.log.NullLoggerFactory;
import capsule.org.eclipse.aether.transfer.NoRepositoryConnectorException;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Named;

@Named
public class DefaultRepositoryConnectorProvider
implements RepositoryConnectorProvider,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private Collection<RepositoryConnectorFactory> connectorFactories = new ArrayList<RepositoryConnectorFactory>();

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.connectorFactories = locator.getServices(RepositoryConnectorFactory.class);
    }

    public DefaultRepositoryConnectorProvider setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public RepositoryConnector newRepositoryConnector(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        if (repository == null) {
            throw new IllegalArgumentException("remote repository has not been specified");
        }
        PrioritizedComponents factories = new PrioritizedComponents(session);
        for (RepositoryConnectorFactory factory : this.connectorFactories) {
            factories.add(factory, factory.getPriority());
        }
        ArrayList<NoRepositoryConnectorException> errors = new ArrayList<NoRepositoryConnectorException>();
        for (PrioritizedComponent factory : factories.getEnabled()) {
            try {
                RepositoryConnector repositoryConnector = ((RepositoryConnectorFactory)factory.getComponent()).newInstance(session, repository);
                if (this.logger.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(repositoryConnector.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, repositoryConnector);
                    buffer.append(" with priority ").append(factory.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    this.logger.debug(buffer.toString());
                }
                return repositoryConnector;
            }
            catch (NoRepositoryConnectorException noRepositoryConnectorException) {
                errors.add(noRepositoryConnectorException);
            }
        }
        if (this.logger.isDebugEnabled() && errors.size() > 1) {
            String msg = "Could not obtain connector factory for " + repository;
            for (Exception exception : errors) {
                this.logger.debug(msg, exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No connector factories available");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available connector factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryConnectorException(repository, buffer.toString(), errors.size() == 1 ? (NoRepositoryConnectorException)errors.get(0) : null);
    }
}

