/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.RepositorySystem;
import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.RequestTrace;
import capsule.org.eclipse.aether.artifact.Artifact;
import capsule.org.eclipse.aether.collection.CollectRequest;
import capsule.org.eclipse.aether.collection.CollectResult;
import capsule.org.eclipse.aether.collection.DependencyCollectionException;
import capsule.org.eclipse.aether.graph.DependencyFilter;
import capsule.org.eclipse.aether.graph.DependencyVisitor;
import capsule.org.eclipse.aether.impl.ArtifactDescriptorReader;
import capsule.org.eclipse.aether.impl.ArtifactResolver;
import capsule.org.eclipse.aether.impl.DependencyCollector;
import capsule.org.eclipse.aether.impl.Deployer;
import capsule.org.eclipse.aether.impl.Installer;
import capsule.org.eclipse.aether.impl.LocalRepositoryProvider;
import capsule.org.eclipse.aether.impl.MetadataResolver;
import capsule.org.eclipse.aether.impl.RemoteRepositoryManager;
import capsule.org.eclipse.aether.impl.SyncContextFactory;
import capsule.org.eclipse.aether.impl.VersionRangeResolver;
import capsule.org.eclipse.aether.impl.VersionResolver;
import capsule.org.eclipse.aether.internal.impl.ArtifactRequestBuilder;
import capsule.org.eclipse.aether.repository.LocalRepository;
import capsule.org.eclipse.aether.repository.LocalRepositoryManager;
import capsule.org.eclipse.aether.repository.NoLocalRepositoryManagerException;
import capsule.org.eclipse.aether.resolution.ArtifactRequest;
import capsule.org.eclipse.aether.resolution.ArtifactResolutionException;
import capsule.org.eclipse.aether.resolution.ArtifactResult;
import capsule.org.eclipse.aether.resolution.DependencyRequest;
import capsule.org.eclipse.aether.resolution.DependencyResolutionException;
import capsule.org.eclipse.aether.resolution.DependencyResult;
import capsule.org.eclipse.aether.resolution.VersionRangeRequest;
import capsule.org.eclipse.aether.resolution.VersionRangeResolutionException;
import capsule.org.eclipse.aether.resolution.VersionRangeResult;
import capsule.org.eclipse.aether.resolution.VersionRequest;
import capsule.org.eclipse.aether.resolution.VersionResolutionException;
import capsule.org.eclipse.aether.resolution.VersionResult;
import capsule.org.eclipse.aether.spi.locator.Service;
import capsule.org.eclipse.aether.spi.locator.ServiceLocator;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.spi.log.LoggerFactory;
import capsule.org.eclipse.aether.spi.log.NullLoggerFactory;
import capsule.org.eclipse.aether.util.graph.visitor.FilteringDependencyVisitor;
import capsule.org.eclipse.aether.util.graph.visitor.TreeDependencyVisitor;
import java.util.List;
import javax.inject.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
public class DefaultRepositorySystem
implements RepositorySystem,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private VersionResolver versionResolver;
    private VersionRangeResolver versionRangeResolver;
    private ArtifactResolver artifactResolver;
    private MetadataResolver metadataResolver;
    private ArtifactDescriptorReader artifactDescriptorReader;
    private DependencyCollector dependencyCollector;
    private Installer installer;
    private Deployer deployer;
    private LocalRepositoryProvider localRepositoryProvider;
    private SyncContextFactory syncContextFactory;
    private RemoteRepositoryManager remoteRepositoryManager;

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setVersionResolver(locator.getService(VersionResolver.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
        this.setArtifactResolver(locator.getService(ArtifactResolver.class));
        this.setMetadataResolver(locator.getService(MetadataResolver.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setDependencyCollector(locator.getService(DependencyCollector.class));
        this.setInstaller(locator.getService(Installer.class));
        this.setDeployer(locator.getService(Deployer.class));
        this.setLocalRepositoryProvider(locator.getService(LocalRepositoryProvider.class));
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setSyncContextFactory(locator.getService(SyncContextFactory.class));
    }

    public DefaultRepositorySystem setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, this.getClass());
        return this;
    }

    public DefaultRepositorySystem setVersionResolver(VersionResolver versionResolver) {
        if (versionResolver == null) {
            throw new IllegalArgumentException("version resolver has not been specified");
        }
        this.versionResolver = versionResolver;
        return this;
    }

    public DefaultRepositorySystem setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        if (versionRangeResolver == null) {
            throw new IllegalArgumentException("version range resolver has not been specified");
        }
        this.versionRangeResolver = versionRangeResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactResolver(ArtifactResolver artifactResolver) {
        if (artifactResolver == null) {
            throw new IllegalArgumentException("artifact resolver has not been specified");
        }
        this.artifactResolver = artifactResolver;
        return this;
    }

    public DefaultRepositorySystem setMetadataResolver(MetadataResolver metadataResolver) {
        if (metadataResolver == null) {
            throw new IllegalArgumentException("metadata resolver has not been specified");
        }
        this.metadataResolver = metadataResolver;
        return this;
    }

    public DefaultRepositorySystem setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        if (artifactDescriptorReader == null) {
            throw new IllegalArgumentException("artifact descriptor reader has not been specified");
        }
        this.artifactDescriptorReader = artifactDescriptorReader;
        return this;
    }

    public DefaultRepositorySystem setDependencyCollector(DependencyCollector dependencyCollector) {
        if (dependencyCollector == null) {
            throw new IllegalArgumentException("dependency collector has not been specified");
        }
        this.dependencyCollector = dependencyCollector;
        return this;
    }

    public DefaultRepositorySystem setInstaller(Installer installer) {
        if (installer == null) {
            throw new IllegalArgumentException("installer has not been specified");
        }
        this.installer = installer;
        return this;
    }

    public DefaultRepositorySystem setDeployer(Deployer deployer) {
        if (deployer == null) {
            throw new IllegalArgumentException("deployer has not been specified");
        }
        this.deployer = deployer;
        return this;
    }

    public DefaultRepositorySystem setLocalRepositoryProvider(LocalRepositoryProvider localRepositoryProvider) {
        if (localRepositoryProvider == null) {
            throw new IllegalArgumentException("local repository provider has not been specified");
        }
        this.localRepositoryProvider = localRepositoryProvider;
        return this;
    }

    public DefaultRepositorySystem setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    public DefaultRepositorySystem setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    @Override
    public VersionResult resolveVersion(RepositorySystemSession session, VersionRequest request) throws VersionResolutionException {
        this.validateSession(session);
        return this.versionResolver.resolveVersion(session, request);
    }

    @Override
    public VersionRangeResult resolveVersionRange(RepositorySystemSession session, VersionRangeRequest request) throws VersionRangeResolutionException {
        this.validateSession(session);
        return this.versionRangeResolver.resolveVersionRange(session, request);
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        this.validateSession(session);
        return this.dependencyCollector.collectDependencies(session, request);
    }

    @Override
    public DependencyResult resolveDependencies(RepositorySystemSession session, DependencyRequest request) throws DependencyResolutionException {
        List<ArtifactResult> results;
        this.validateSession(session);
        RequestTrace trace = RequestTrace.newChild(request.getTrace(), request);
        DependencyResult result = new DependencyResult(request);
        DependencyCollectionException dce = null;
        ArtifactResolutionException are = null;
        if (request.getRoot() != null) {
            result.setRoot(request.getRoot());
        } else if (request.getCollectRequest() != null) {
            CollectResult collectResult;
            try {
                request.getCollectRequest().setTrace(trace);
                collectResult = this.dependencyCollector.collectDependencies(session, request.getCollectRequest());
            }
            catch (DependencyCollectionException e) {
                dce = e;
                collectResult = e.getResult();
            }
            result.setRoot(collectResult.getRoot());
            result.setCycles(collectResult.getCycles());
            result.setCollectExceptions(collectResult.getExceptions());
        } else {
            throw new IllegalArgumentException("dependency node or collect request missing");
        }
        ArtifactRequestBuilder builder = new ArtifactRequestBuilder(trace);
        DependencyFilter filter = request.getFilter();
        DependencyVisitor visitor = filter != null ? new FilteringDependencyVisitor(builder, filter) : builder;
        visitor = new TreeDependencyVisitor(visitor);
        result.getRoot().accept(visitor);
        List<ArtifactRequest> requests = builder.getRequests();
        try {
            results = this.artifactResolver.resolveArtifacts(session, requests);
        }
        catch (ArtifactResolutionException e) {
            are = e;
            results = e.getResults();
        }
        result.setArtifactResults(results);
        this.updateNodesWithResolvedArtifacts(results);
        if (dce != null) {
            throw new DependencyResolutionException(result, (Throwable)dce);
        }
        if (are != null) {
            throw new DependencyResolutionException(result, (Throwable)are);
        }
        return result;
    }

    private void updateNodesWithResolvedArtifacts(List<ArtifactResult> results) {
        for (ArtifactResult result : results) {
            Artifact artifact = result.getArtifact();
            if (artifact == null) continue;
            result.getRequest().getDependencyNode().setArtifact(artifact);
        }
    }

    @Override
    public LocalRepositoryManager newLocalRepositoryManager(RepositorySystemSession session, LocalRepository localRepository) {
        try {
            return this.localRepositoryProvider.newLocalRepositoryManager(session, localRepository);
        }
        catch (NoLocalRepositoryManagerException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private void validateSession(RepositorySystemSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Invalid repository system session: the session may not be null.");
        }
        if (session.getLocalRepositoryManager() == null) {
            this.invalidSession("LocalRepositoryManager");
        }
        if (session.getSystemProperties() == null) {
            this.invalidSession("SystemProperties");
        }
        if (session.getUserProperties() == null) {
            this.invalidSession("UserProperties");
        }
        if (session.getConfigProperties() == null) {
            this.invalidSession("ConfigProperties");
        }
        if (session.getMirrorSelector() == null) {
            this.invalidSession("MirrorSelector");
        }
        if (session.getProxySelector() == null) {
            this.invalidSession("ProxySelector");
        }
        if (session.getAuthenticationSelector() == null) {
            this.invalidSession("AuthenticationSelector");
        }
        if (session.getArtifactTypeRegistry() == null) {
            this.invalidSession("ArtifactTypeRegistry");
        }
        if (session.getData() == null) {
            this.invalidSession("Data");
        }
    }

    private void invalidSession(String name) {
        throw new IllegalArgumentException("Invalid repository system session: " + name + " is not set.");
    }
}

