/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl;

import capsule.org.eclipse.aether.RepositorySystemSession;
import capsule.org.eclipse.aether.artifact.Artifact;
import capsule.org.eclipse.aether.impl.OfflineController;
import capsule.org.eclipse.aether.metadata.Metadata;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.resolution.ResolutionErrorPolicy;
import capsule.org.eclipse.aether.resolution.ResolutionErrorPolicyRequest;
import capsule.org.eclipse.aether.transfer.RepositoryOfflineException;

final class Utils {
    Utils() {
    }

    public static int getPolicy(RepositorySystemSession session, Artifact artifact, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getArtifactPolicy(session, new ResolutionErrorPolicyRequest<Artifact>(artifact, repository));
    }

    public static int getPolicy(RepositorySystemSession session, Metadata metadata, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getMetadataPolicy(session, new ResolutionErrorPolicyRequest<Metadata>(metadata, repository));
    }

    public static void appendClassLoader(StringBuilder buffer, Object component) {
        ClassLoader loader = component.getClass().getClassLoader();
        if (loader != null && !loader.equals(Utils.class.getClassLoader())) {
            buffer.append(" from ").append(loader);
        }
    }

    public static void checkOffline(RepositorySystemSession session, OfflineController offlineController, RemoteRepository repository) throws RepositoryOfflineException {
        if (session.isOffline()) {
            offlineController.checkOffline(session, repository);
        }
    }
}

