/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.internal.impl.slf4j;

import capsule.org.eclipse.aether.spi.locator.Service;
import capsule.org.eclipse.aether.spi.locator.ServiceLocator;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.spi.log.LoggerFactory;
import capsule.org.slf4j.ILoggerFactory;
import capsule.org.slf4j.spi.LocationAwareLogger;
import javax.inject.Named;

@Named(value="slf4j")
public class Slf4jLoggerFactory
implements Service,
LoggerFactory {
    private static final boolean AVAILABLE;
    private ILoggerFactory factory;

    public static boolean isSlf4jAvailable() {
        return AVAILABLE;
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(ILoggerFactory.class));
    }

    public Slf4jLoggerFactory setLoggerFactory(ILoggerFactory factory) {
        this.factory = factory;
        return this;
    }

    public Logger getLogger(String name) {
        capsule.org.slf4j.Logger logger = this.getFactory().getLogger(name);
        if (logger instanceof LocationAwareLogger) {
            return new Slf4jLoggerEx((LocationAwareLogger)logger);
        }
        return new Slf4jLogger(logger);
    }

    private ILoggerFactory getFactory() {
        if (this.factory == null) {
            this.factory = capsule.org.slf4j.LoggerFactory.getILoggerFactory();
        }
        return this.factory;
    }

    static {
        boolean available;
        try {
            Slf4jLoggerFactory.class.getClassLoader().loadClass("capsule.org.slf4j.ILoggerFactory");
            available = true;
        }
        catch (Exception e) {
            available = false;
        }
        catch (LinkageError e) {
            available = false;
        }
        AVAILABLE = available;
    }

    private static final class Slf4jLoggerEx
    implements Logger {
        private static final String FQCN = Slf4jLoggerEx.class.getName();
        private final LocationAwareLogger logger;

        public Slf4jLoggerEx(LocationAwareLogger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String msg) {
            this.logger.log(null, FQCN, 10, msg, null, null);
        }

        public void debug(String msg, Throwable error) {
            this.logger.log(null, FQCN, 10, msg, null, error);
        }

        public void warn(String msg) {
            this.logger.log(null, FQCN, 30, msg, null, null);
        }

        public void warn(String msg, Throwable error) {
            this.logger.log(null, FQCN, 30, msg, null, error);
        }
    }

    private static final class Slf4jLogger
    implements Logger {
        private final capsule.org.slf4j.Logger logger;

        public Slf4jLogger(capsule.org.slf4j.Logger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String msg) {
            this.logger.debug(msg);
        }

        public void debug(String msg, Throwable error) {
            this.logger.debug(msg, error);
        }

        public void warn(String msg) {
            this.logger.warn(msg);
        }

        public void warn(String msg, Throwable error) {
            this.logger.warn(msg, error);
        }
    }
}

