/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.transfer;

import capsule.org.eclipse.aether.artifact.Artifact;
import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.transfer.ArtifactTransferException;

public class ArtifactNotFoundException
extends ArtifactTransferException {
    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository) {
        super(artifact, repository, ArtifactNotFoundException.getMessage(artifact, repository));
    }

    private static String getMessage(Artifact artifact, RemoteRepository repository) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("Could not find artifact ").append(artifact);
        buffer.append(ArtifactNotFoundException.getString(" in ", repository));
        if (artifact != null) {
            String downloadUrl;
            String localPath = artifact.getProperty("localPath", null);
            if (localPath != null && repository == null) {
                buffer.append(" at specified path ").append(localPath);
            }
            if ((downloadUrl = artifact.getProperty("downloadUrl", null)) != null) {
                buffer.append(", try downloading from ").append(downloadUrl);
            }
        }
        return buffer.toString();
    }

    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository, String message, boolean fromCache) {
        super(artifact, repository, message, fromCache);
    }

    public ArtifactNotFoundException(Artifact artifact, RemoteRepository repository, String message, Throwable cause) {
        super(artifact, repository, message, cause);
    }
}

