/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.eclipse.aether.transport.file;

import capsule.org.eclipse.aether.repository.RemoteRepository;
import capsule.org.eclipse.aether.spi.connector.transport.AbstractTransporter;
import capsule.org.eclipse.aether.spi.connector.transport.GetTask;
import capsule.org.eclipse.aether.spi.connector.transport.PeekTask;
import capsule.org.eclipse.aether.spi.connector.transport.TransportTask;
import capsule.org.eclipse.aether.spi.log.Logger;
import capsule.org.eclipse.aether.transfer.NoTransporterException;
import capsule.org.eclipse.aether.transport.file.PathUtils;
import capsule.org.eclipse.aether.transport.file.ResourceNotFoundException;
import java.io.File;
import java.io.FileInputStream;

final class FileTransporter
extends AbstractTransporter {
    private final Logger logger;
    private final File basedir;

    public FileTransporter(RemoteRepository repository, Logger logger) throws NoTransporterException {
        if (!"file".equalsIgnoreCase(repository.getProtocol())) {
            throw new NoTransporterException(repository);
        }
        this.logger = logger;
        this.basedir = new File(PathUtils.basedir(repository.getUrl())).getAbsoluteFile();
    }

    public int classify(Throwable error) {
        if (error instanceof ResourceNotFoundException) {
            return 1;
        }
        return 0;
    }

    protected void implPeek(PeekTask task) throws Exception {
        this.getFile(task, true);
    }

    protected void implGet(GetTask task) throws Exception {
        File file = this.getFile(task, true);
        this.utilGet(task, new FileInputStream(file), true, file.length(), false);
    }

    private File getFile(TransportTask task, boolean required) throws Exception {
        String path = task.getLocation().getPath();
        if (path.contains("../")) {
            throw new IllegalArgumentException("Illegal resource path: " + path);
        }
        File file = new File(this.basedir, path);
        if (required && !file.exists()) {
            throw new ResourceNotFoundException("Could not locate " + file);
        }
        return file;
    }

    protected void implClose() {
    }
}

