/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.sonatype.plexus.components.cipher;

import capsule.org.codehaus.plexus.logging.AbstractLogEnabled;
import capsule.org.sonatype.plexus.components.cipher.PBECipher;
import capsule.org.sonatype.plexus.components.cipher.PlexusCipher;
import capsule.org.sonatype.plexus.components.cipher.PlexusCipherException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultPlexusCipher
extends AbstractLogEnabled
implements PlexusCipher {
    private static final Pattern ENCRYPTED_STRING_PATTERN = Pattern.compile(".*?[^\\\\]?\\{(.*?[^\\\\])\\}.*");
    private final PBECipher _cipher = new PBECipher();

    public String decrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.decrypt64(str, passPhrase);
    }

    public String decryptDecorated(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        if (this.isEncryptedString(str)) {
            return this.decrypt(this.unDecorate(str), passPhrase);
        }
        return this.decrypt(str, passPhrase);
    }

    public boolean isEncryptedString(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        return matcher.matches() || matcher.find();
    }

    public String unDecorate(String str) throws PlexusCipherException {
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        if (matcher.matches() || matcher.find()) {
            return matcher.group(1);
        }
        throw new PlexusCipherException("default.plexus.cipher.badEncryptedPassword");
    }
}

