/*
 * Decompiled with CFR 0.152.
 */
package capsule.org.sonatype.plexus.components.cipher;

import capsule.org.sonatype.plexus.components.cipher.Base64;
import capsule.org.sonatype.plexus.components.cipher.PlexusCipherException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PBECipher {
    protected static int PBE_ITERATIONS = 1000;
    protected MessageDigest _digester;
    protected SecureRandom _secureRandom;
    protected boolean _onLinux = false;

    public PBECipher() throws PlexusCipherException {
        try {
            this._digester = MessageDigest.getInstance("SHA-256");
            if (System.getProperty("os.name", "blah").toLowerCase().indexOf("linux") != -1) {
                this._onLinux = true;
            }
            if (this._onLinux) {
                System.setProperty("securerandom.source", "file:/dev/./urandom");
            } else {
                this._secureRandom = new SecureRandom();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new PlexusCipherException(e);
        }
    }

    public String decrypt64(String encryptedText, String password) throws PlexusCipherException {
        try {
            byte[] allEncryptedBytes = Base64.decodeBase64(encryptedText.getBytes());
            int totalLen = allEncryptedBytes.length;
            byte[] salt = new byte[8];
            System.arraycopy(allEncryptedBytes, 0, salt, 0, 8);
            byte padLen = allEncryptedBytes[8];
            byte[] encryptedBytes = new byte[totalLen - 8 - 1 - padLen];
            System.arraycopy(allEncryptedBytes, 9, encryptedBytes, 0, encryptedBytes.length);
            Cipher cipher = this.createCipher(password.getBytes("UTF8"), salt, 2);
            byte[] clearBytes = cipher.doFinal(encryptedBytes);
            String clearText = new String(clearBytes, "UTF8");
            return clearText;
        }
        catch (Exception e) {
            throw new PlexusCipherException(e);
        }
    }

    private Cipher createCipher(byte[] pwdAsBytes, byte[] salt, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        this._digester.reset();
        byte[] keyAndIv = new byte[32];
        if (salt == null || salt.length == 0) {
            salt = null;
        }
        int currentPos = 0;
        while (currentPos < keyAndIv.length) {
            int stillNeed;
            byte[] result;
            this._digester.update(pwdAsBytes);
            if (salt != null) {
                this._digester.update(salt, 0, 8);
            }
            if ((result = this._digester.digest()).length > (stillNeed = keyAndIv.length - currentPos)) {
                byte[] b = new byte[stillNeed];
                System.arraycopy(result, 0, b, 0, b.length);
                result = b;
            }
            System.arraycopy(result, 0, keyAndIv, currentPos, result.length);
            if ((currentPos += result.length) >= keyAndIv.length) continue;
            this._digester.reset();
            this._digester.update(result);
        }
        byte[] key = new byte[16];
        byte[] iv = new byte[16];
        System.arraycopy(keyAndIv, 0, key, 0, key.length);
        System.arraycopy(keyAndIv, key.length, iv, 0, iv.length);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        return cipher;
    }
}

