/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.model;

import com.adobe.aem.dermis.api.bridge.OperationOptions;
import com.adobe.aem.dermis.api.bridge.Query;
import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.value.IValueMap;
import com.adobe.aemfd.dermis.authentication.model.AuthenticationDetails;
import com.adobe.aemfd.dermis.authentication.model.Configuration;
import org.apache.sling.commons.json.JSONObject;

public class ExecutionContext {
    private Query query;
    private AuthenticationDetails authDetails;
    private Configuration configuration;

    public ExecutionContext(Query query) {
        this.query = query;
    }

    public ExecutionContext(Query query, AuthenticationDetails authDetails) {
        this(query);
        this.authDetails = authDetails;
    }

    public ExecutionContext(Query query, AuthenticationDetails authDetails, Configuration configuration) {
        this(query, authDetails);
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public AuthenticationDetails getAuthDetails() {
        return this.authDetails;
    }

    public void setAuthDetails(AuthenticationDetails authDetails) {
        this.authDetails = authDetails;
    }

    public String getOperationId() {
        String operationId = null;
        if (this.query != null) {
            operationId = this.query.getOperationId();
        }
        return operationId;
    }

    public String getEntityId() {
        String entityId = null;
        if (this.query != null) {
            entityId = this.query.getEntityId();
        }
        return entityId;
    }

    public String getSchemaName() {
        OperationOptions options;
        String schemaName = null;
        if (this.query != null && (options = this.query.getOptions()) != null) {
            schemaName = options.getSchemaName();
        }
        return schemaName;
    }

    public JSONObject getArguments() {
        JSONObject arguments = null;
        if (this.query != null) {
            arguments = this.query.getArguments();
        }
        return arguments;
    }

    public IValueMap getArgumentsValueMap() {
        IValueMap args = null;
        if (this.query != null) {
            args = this.query.getArgumentsValueMap();
        }
        return args;
    }

    public String getConfigurationId() throws DermisException {
        String configurationId = null;
        if (this.configuration != null) {
            configurationId = this.configuration.getId();
        }
        return configurationId;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }
}

