/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideField;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

public class GuideCheckBox
extends GuideField {
    @Override
    public String getLabelForId() throws RepositoryException {
        return this.getId();
    }

    public Map getOptions() {
        Map options = FormsHelper.getOptions((SlingHttpServletRequest)this.slingRequest, (Resource)super.getResource());
        if (options == null) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Iterator keyset = options.keySet().iterator();
        String[] optionsInRes = (String[])this.resourceProps.get("options", String[].class);
        int index = 0;
        while (keyset.hasNext()) {
            String key = (String)keyset.next();
            if (optionsInRes != null && optionsInRes.length == options.size()) {
                ArrayList<String> keyValueString = GuideUtils.getOptions(optionsInRes[index], "options", this.i18n, true, super.getResource());
                String value = this.getAreOptionsRichText() != false ? GuideUtils.filterHtml(keyValueString.get(1), this.getXssapi()) : keyValueString.get(1);
                result.put(key, value);
            } else {
                String value = this.externalize((String)options.get(key), "options");
                value = this.getAreOptionsRichText() != false ? GuideUtils.filterHtml(value, this.getXssapi()) : value;
                result.put(key, value);
            }
            ++index;
        }
        return result;
    }

    public Boolean getAreOptionsRichText() {
        return (Boolean)this.resourceProps.get("richTextOptions", (Object)false);
    }

    public List getValues() {
        return FormsHelper.getValuesAsList((SlingHttpServletRequest)this.slingRequest, (Resource)super.getResource());
    }

    @Override
    public String getGuideFieldType() {
        return "guideCheckBoxGroup";
    }

    public String getAlignment() {
        return (String)this.resourceProps.get("alignment", (Object)"guideFieldHorizontalAlignment");
    }

    public String getInputType() {
        return "checkbox";
    }

    public String getItemClassName() {
        return "guideCheckBoxItem";
    }

    public String getItemsClass() {
        return "guideCheckBoxGroupItems";
    }
}

