/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.CustomJSONWriter;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.forms.common.service.FormDataXMLProviderRegistry;
import com.adobe.forms.foundation.fdinternal.utils.DocumentBuilderUtil;
import com.adobe.forms.foundation.util.ContentConverterUtils;
import com.adobe.granite.resourceresolverhelper.ResourceResolverHelper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtils {
    private static Logger logger = LoggerFactory.getLogger(XMLUtils.class);
    private static final String EMAIL = "email";
    private static final String COUNTRY_CODE = "countryCode";
    private static final String NUMBER = "number";
    private static final String PHONE = "phone";
    public static final String DEFAULT_NS_PATTERN_PREFIX = "xmlns=";
    public static final String IMPLICIT_AF_NS_PATTERN_PREFIX = "xmlns:defaultAFNS";
    public static final String xmlSkeleton = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<afData>\n  <afUnboundData>\n    <data></data>\n  </afUnboundData>\n  <afBoundData>\n    <data xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\"></data>\n  </afBoundData>\n</afData>\n";

    public static boolean checkIfStringHasIndexOperator(String bindRef) {
        boolean bContainsIndex = false;
        if (StringUtils.contains((CharSequence)bindRef, (CharSequence)"[")) {
            bContainsIndex = true;
        }
        return bContainsIndex;
    }

    public static String extractXsdRootElement(JSONObject guideJson) {
        String xsdRootEl = "";
        try {
            if (guideJson.has("xsdRootElement")) {
                xsdRootEl = guideJson.getString("xsdRootElement");
            } else {
                logger.debug("Unable to find xsdRootElement in guide JSON");
            }
        }
        catch (JSONException ex) {
            logger.debug("Unable to read xsdRootElement from guide JSON", (Throwable)ex);
        }
        return xsdRootEl;
    }

    public static String getXSDRootBindRef(JSONObject jsonObject, String xsdRoot) throws JSONException {
        String effectiveBindRef = "";
        if (XMLUtils.isXsd(jsonObject)) {
            effectiveBindRef = XMLUtils.getRelativeXpath(jsonObject.optString("bindRef", ""), xsdRoot);
        }
        return effectiveBindRef;
    }

    public static String getRelativeXpath(String bindRef, String root) {
        String xpath = "";
        if (StringUtils.isNotBlank((CharSequence)bindRef)) {
            xpath = bindRef;
            if (XMLUtils.isValidXsdRoot(root) && xpath.matches("/" + root + "(?:/.+)?") || StringUtils.equals((CharSequence)root, (CharSequence)"?")) {
                xpath = xpath.replaceFirst("^/[^/]+", "");
            }
        }
        return StringUtils.removeStart((String)xpath, (String)"/");
    }

    public static String getXMLfromXsdDom(Element doc) {
        return XMLUtils.getXMLfromXsdDom(doc, false);
    }

    public static String getXMLfromXsdDom(Element doc, Boolean omitXmlDeclaration) {
        String xmlStr = "";
        try {
            if (doc != null) {
                TransformerFactory transfac = TransformerFactory.newInstance();
                transfac.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer trans = transfac.newTransformer();
                trans.setOutputProperty("omit-xml-declaration", omitXmlDeclaration != false ? "yes" : "no");
                trans.setOutputProperty("method", "xml");
                trans.setOutputProperty("encoding", "UTF-8");
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                DOMSource source = new DOMSource(doc);
                trans.transform(source, result);
                xmlStr = sw.toString();
            }
        }
        catch (Exception e) {
            throw new GuideException(e);
        }
        return xmlStr;
    }

    public static void addChildNodesOfParentUnderRoot(org.w3c.dom.Node parent, org.w3c.dom.Node root) {
        Document document = root.getOwnerDocument();
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            root.appendChild(document.importNode(child, true));
        }
    }

    public static String getDorDataXmlPart(Document dorDoc, Document doc, String excludeFromDorIfHidden, boolean bSetXfaNameSpace, JSONObject guideJson) {
        try {
            Element nakedStateOverrideXml;
            Element nakedExcludeFromDoRXml;
            org.w3c.dom.Node root = null;
            Element nakedBoundXml = XMLUtils.getBoundDataXmlElement(doc);
            Element nakedUnBoundXml = XMLUtils.getUnboundDataXmlElement(doc);
            root = nakedBoundXml != null ? dorDoc.importNode(nakedBoundXml, false) : (nakedUnBoundXml != null ? dorDoc.importNode(nakedUnBoundXml, false) : dorDoc.createElement("data"));
            if (XMLUtils.isWrappedXml(doc)) {
                if (nakedUnBoundXml != null) {
                    XMLUtils.addChildNodesOfParentUnderRoot(nakedUnBoundXml, root);
                }
                if (nakedBoundXml != null) {
                    XMLUtils.addChildNodesOfParentUnderRoot(nakedBoundXml, root);
                }
            } else {
                root = dorDoc.importNode(doc.getDocumentElement(), true);
            }
            if (bSetXfaNameSpace) {
                XMLUtils.setXfaNameSpace((Element)root);
                XMLUtils.setXmlSchemaInstanceNamespace((Element)root);
            }
            if ((nakedExcludeFromDoRXml = XMLUtils.getSubmissionInfoDataXmlElement(doc, "excludeFromDoR")) != null) {
                root.appendChild(dorDoc.importNode(nakedExcludeFromDoRXml, true));
            }
            if ((nakedStateOverrideXml = XMLUtils.getSubmissionInfoDataXmlElement(doc, "stateOverrides")) != null && bSetXfaNameSpace) {
                nakedStateOverrideXml.setAttribute("xfa:dataNode", "dataGroup");
                root.appendChild(dorDoc.importNode(nakedStateOverrideXml, true));
            }
            XMLUtils.handleXfaDataNode((Element)root, guideJson, StringUtils.isNotEmpty((CharSequence)guideJson.optString("xsdRootElement")));
            XMLUtils.convertRTEValXfaCmplntHTML(root);
            return XMLUtils.getXMLfromXsdDom((Element)root);
        }
        catch (Exception e) {
            throw new GuideException("Error in getting dor data xml " + e.getMessage(), e);
        }
    }

    private static void handleXfaDataNode(Element root, JSONObject guideJson, boolean schemaHasRoot) {
        try {
            Iterator iterator = guideJson.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                Object value = guideJson.get(key);
                if (value instanceof JSONObject) {
                    XMLUtils.handleXfaDataNode(root, (JSONObject)value, schemaHasRoot);
                    continue;
                }
                if (StringUtils.equals((CharSequence)key, (CharSequence)"guideNodeClass")) {
                    boolean isContainer;
                    String guideNodeClass = (String)value;
                    boolean bl = isContainer = guideNodeClass.equals("guidePanel") || guideNodeClass.equals("rootPanelNode") || guideNodeClass.equals("guideTable") || guideNodeClass.equals("guideTableRow");
                    if (isContainer) {
                        String xPathExpression = null;
                        xPathExpression = guideJson.has("bindRef") ? XMLUtils.getXPathExprForBindRef(guideJson.getString("bindRef"), schemaHasRoot) : guideJson.optString("name");
                        XMLUtils.addDataNodeAttribute(xPathExpression, root, "dataGroup");
                    }
                }
                if (!StringUtils.equals((CharSequence)key, (CharSequence)"bindRef") || !StringUtils.contains((CharSequence)((String)value), (CharSequence)"/text()")) continue;
                String xPathExpression = XMLUtils.getXPathExprForBindRef(StringUtils.substringBefore((String)((String)value), (String)"/text()"), schemaHasRoot);
                XMLUtils.addDataNodeAttribute(xPathExpression, root, "dataValue");
            }
        }
        catch (JSONException e) {
            logger.error("Exception while parsing JSON ", (Throwable)e);
        }
        catch (XPathExpressionException e) {
            logger.error("Exception while adding data node attribute in XML " + e);
        }
    }

    private static String getXPathExprForBindRef(String bindRef, Boolean schemaHasRoot) {
        String xPathExpression = null;
        if (StringUtils.isNotEmpty((CharSequence)bindRef)) {
            int index;
            if (!schemaHasRoot.booleanValue()) {
                bindRef = "/data" + bindRef;
            }
            xPathExpression = (index = bindRef.indexOf(47, 1)) != -1 ? StringUtils.substring((String)bindRef, (int)(index + 1)) : null;
        }
        return xPathExpression;
    }

    private static void addDataNodeAttribute(String xPathExpression, Element element, String attributeValue) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList targetNodes = null;
        if (StringUtils.isNotEmpty((CharSequence)xPathExpression)) {
            targetNodes = (NodeList)xPath.evaluate(xPathExpression, element, XPathConstants.NODESET);
        }
        if (targetNodes != null) {
            int length = targetNodes.getLength();
            for (int i = 0; i < length; ++i) {
                ((Element)targetNodes.item(i)).setAttribute("xfa:dataNode", attributeValue);
            }
        }
    }

    public static void convertRTEValXfaCmplntHTML(org.w3c.dom.Node node) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList rteNodes = (NodeList)xPath.evaluate("//body", node, XPathConstants.NODESET);
            for (int i = 0; i < rteNodes.getLength(); ++i) {
                String rteString;
                org.w3c.dom.Node rteNode = rteNodes.item(i);
                if (!"http://www.w3.org/1999/xhtml".equals(rteNode.getAttributes().getNamedItem("xmlns").getNodeValue()) || !StringUtils.isNotBlank((CharSequence)(rteString = XMLUtils.getStringFromNode(rteNode.getParentNode(), true)))) continue;
                String resolvedRT = rteString.replaceAll("\r\n", "").replaceAll("\n", "");
                NodeList modifiedRteNodeList = XMLUtils.getNodeListFromXmlString(ContentConverterUtils.convertToXFAHTML((String)resolvedRT));
                org.w3c.dom.Node rteParentNode = rteNode.getParentNode();
                rteParentNode.removeChild(rteNode);
                XMLUtils.appendNodeListToNode(rteParentNode, modifiedRteNodeList);
            }
        }
        catch (Exception e) {
            throw new GuideException("Error in converting rte to html compliant xml." + e.getMessage(), e);
        }
    }

    public static Element getSubmissionInfoDataXmlElement(Document doc, String submitInfoPart) {
        try {
            if (XMLUtils.isWrappedXml(doc)) {
                XPath xPath = XPathFactory.newInstance().newXPath();
                String xPathString = "afSubmissionInfo";
                if (submitInfoPart != null && submitInfoPart.length() > 0) {
                    xPathString = xPathString + "/" + submitInfoPart;
                }
                org.w3c.dom.Node afSubmissionInfo = (org.w3c.dom.Node)xPath.evaluate(xPathString, doc.getDocumentElement(), XPathConstants.NODE);
                return (Element)afSubmissionInfo;
            }
            return null;
        }
        catch (Exception e) {
            throw new GuideException("Error in getting bound xml part" + e.getMessage(), e);
        }
    }

    public static Map<String, Object> getSignersMapForFormSourceFromDataXML(String data) {
        HashMap<String, Object> signerInfo = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)data)) {
            Element signersNode = XMLUtils.getSignersDataXmlElement(XMLUtils.strToDoc(data));
            if (signersNode != null) {
                NodeList children = signersNode.getChildNodes();
                for (int childCount = 0; childCount < children.getLength(); ++childCount) {
                    NodeList phones;
                    org.w3c.dom.Node child = children.item(childCount);
                    if (child.getNodeType() != 1) continue;
                    Element signerNode = (Element)child;
                    HashMap<String, Object> nodeDetails = new HashMap<String, Object>();
                    if (signerNode.getElementsByTagName(EMAIL).getLength() != 0) {
                        nodeDetails.put(EMAIL, signerNode.getElementsByTagName(EMAIL).item(0).getTextContent());
                    }
                    if ((phones = signerNode.getElementsByTagName(PHONE)).getLength() != 0) {
                        Element phoneNode = (Element)phones.item(0);
                        HashMap<String, String> phoneDetails = new HashMap<String, String>();
                        if (phoneNode.getElementsByTagName(COUNTRY_CODE).getLength() != 0) {
                            phoneDetails.put(COUNTRY_CODE, phoneNode.getElementsByTagName(COUNTRY_CODE).item(0).getTextContent());
                        }
                        if (phoneNode.getElementsByTagName(NUMBER).getLength() != 0) {
                            phoneDetails.put(NUMBER, phoneNode.getElementsByTagName(NUMBER).item(0).getTextContent());
                        }
                        if (phoneDetails.size() > 0) {
                            nodeDetails.put(PHONE, phoneDetails);
                        }
                    }
                    signerInfo.put(signerNode.getNodeName(), nodeDetails);
                }
            }
        } else {
            logger.error("Either data XML is null or empty or signers info is null");
        }
        return signerInfo;
    }

    public static String addSubmissionInfoMetaData(String data, String formContainerPath, String submissionTime) {
        String submissionData = data;
        Document dataDoc = XMLUtils.getDomFromXMLString(data, true);
        Element submissionInfoRootTag = null;
        XPath xPath = XPathFactory.newInstance().newXPath();
        if (dataDoc != null) {
            submissionInfoRootTag = XMLUtils.getSubmissionInfoDataXmlElement(dataDoc, null);
        }
        if (submissionInfoRootTag != null) {
            try {
                Element node;
                if (formContainerPath != null) {
                    String formDamPath = GuideUtils.convertGuideContainerPathToFMAssetPath(formContainerPath);
                    Element node2 = (Element)xPath.evaluate("afSubmissionInfo/afPath", dataDoc.getDocumentElement(), XPathConstants.NODE);
                    if (node2 == null) {
                        submissionInfoRootTag.appendChild(XMLUtils.createXMLTag(dataDoc, "afPath", formDamPath));
                    } else {
                        node2.setTextContent(formDamPath);
                    }
                }
                if ((node = (Element)xPath.evaluate("afSubmissionInfo/afSubmissionTime", dataDoc.getDocumentElement(), XPathConstants.NODE)) == null) {
                    submissionInfoRootTag.appendChild(XMLUtils.createXMLTag(dataDoc, "afSubmissionTime", submissionTime));
                } else {
                    node.setTextContent(submissionTime);
                }
                submissionData = XMLUtils.nodeToStr(dataDoc, false);
            }
            catch (XPathExpressionException e) {
                logger.debug("[AF]XMLUtils error in adding submission metaInfo", (Throwable)e);
            }
        }
        return submissionData;
    }

    public static String getSubmissionInfoDataXmlPart(Document doc, String submitInfoPart) {
        return XMLUtils.getXMLfromXsdDom(XMLUtils.getSubmissionInfoDataXmlElement(doc, submitInfoPart));
    }

    public static void setXfaNameSpace(Element data) {
        if (data != null) {
            data.setAttribute("xmlns:xfa", "http://www.xfa.org/schema/xfa-data/1.0/");
        }
    }

    public static void setXmlSchemaInstanceNamespace(Element data) {
        if (data != null) {
            data.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    public static String getBoundDataXmlPart(Document doc) {
        return XMLUtils.getXMLfromXsdDom(XMLUtils.getBoundDataXmlElement(doc));
    }

    public static Element getBoundDataXmlElement(Document doc) {
        try {
            if (XMLUtils.isWrappedXml(doc)) {
                XPath xPath = XPathFactory.newInstance().newXPath();
                org.w3c.dom.Node afBoundData = (org.w3c.dom.Node)xPath.evaluate("afBoundData/*", doc.getDocumentElement(), XPathConstants.NODE);
                return (Element)afBoundData;
            }
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new GuideException("Error in getting bound xml part" + e.getMessage(), e);
        }
    }

    public static String getUnboundDataXmlPart(Document doc) {
        return XMLUtils.getXMLfromXsdDom(XMLUtils.getUnboundDataXmlElement(doc));
    }

    public static Element getUnboundDataXmlElement(Document doc) {
        try {
            if (XMLUtils.isWrappedXml(doc)) {
                XPath xPath = XPathFactory.newInstance().newXPath();
                org.w3c.dom.Node afUnboundData = (org.w3c.dom.Node)xPath.evaluate("afUnboundData/*", doc.getDocumentElement(), XPathConstants.NODE);
                return (Element)afUnboundData;
            }
            return doc.getDocumentElement();
        }
        catch (Exception e) {
            throw new GuideException("Error in getting unbound xml part" + e.getMessage(), e);
        }
    }

    public static Element getSignersDataXmlElement(Document doc) {
        return XMLUtils.getSubmissionInfoDataXmlElement(doc, "signers");
    }

    public static org.w3c.dom.Node getChildNodeByName(org.w3c.dom.Node node, String childName) {
        org.w3c.dom.Node retNode = null;
        NodeList children = node.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (!StringUtils.equals((CharSequence)child.getNodeName(), (CharSequence)childName)) continue;
            retNode = child;
        }
        return retNode;
    }

    private static void populateBindRefDataMap(org.w3c.dom.Node data, Map<String, String> map, String parentPath) {
        if (data == null || data.getNodeType() != 1) {
            return;
        }
        NodeList children = data.getChildNodes();
        int length = children.getLength();
        if (length == 1 && children.item(0).getNodeType() == 1 || length > 1 && !XMLUtils.isRichTextDataNode(children)) {
            for (int i = 0; i < length; ++i) {
                XMLUtils.populateBindRefDataMap(children.item(i), map, parentPath + "/" + data.getNodeName());
            }
        } else {
            String value = data.getTextContent();
            if (StringUtils.isNotEmpty((CharSequence)value) && data.getNodeType() == 1) {
                map.put(parentPath + "/" + data.getNodeName(), value);
            }
        }
    }

    public static Map<String, String> getDataMap(Document document) throws JSONException {
        Map<String, String> boundDataMap;
        Element boundData;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Element unboundData = XMLUtils.getUnboundDataXmlElement(document);
        if (unboundData != null) {
            JSONObject json = (JSONObject)XMLUtils.getMapOfUnboundData(document).get("data");
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                dataMap.put(key, (String)json.get(key));
            }
        }
        if ((boundData = XMLUtils.getBoundDataXmlElement(document)) != null && !(boundDataMap = XMLUtils.getBoundDataMapWithBindRefKeys(document)).isEmpty()) {
            dataMap.putAll(boundDataMap);
        }
        return dataMap;
    }

    public static Map<String, String> getBoundDataMapWithBindRefKeys(Document document) {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        Element boundData = XMLUtils.getBoundDataXmlElement(document);
        if (boundData != null) {
            NodeList children = boundData.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                XMLUtils.populateBindRefDataMap(children.item(i), dataMap, "");
            }
        }
        return dataMap;
    }

    public static JSONObject getMapOfUnboundData(Document doc) {
        JSONObject xmlJSONObj = null;
        XPath xPath = XPathFactory.newInstance().newXPath();
        StringWriter stringWriter = new StringWriter();
        CustomJSONWriter jsonWriter = new CustomJSONWriter(stringWriter);
        try {
            Document unboundData = XMLUtils.strToDoc(XMLUtils.getUnboundDataXmlPart(doc));
            jsonWriter.object();
            jsonWriter.key("data").object();
            XMLUtils.convertUnboundedNodeToJson("data", xPath, unboundData, jsonWriter);
            jsonWriter.endObject();
            jsonWriter.endObject();
            String jsonStr = stringWriter.toString();
            xmlJSONObj = new JSONObject(jsonStr);
        }
        catch (Exception e) {
            throw new GuideException("Error in getting map of unbound data" + e.getMessage(), e);
        }
        return xmlJSONObj;
    }

    private static void convertUnboundedNodeToJson(String rootNodeName, XPath xPath, Document unboundedXMLData, CustomJSONWriter jsonWriter) throws XPathExpressionException {
        NodeList nodes = (NodeList)xPath.evaluate(rootNodeName + "/*", unboundedXMLData, XPathConstants.NODESET);
        if (nodes != null && nodes.getLength() > 0) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element node = (Element)nodes.item(i);
                String nodeName = node.getNodeName();
                String nodeValue = null;
                String childNodeName = rootNodeName + "/" + nodeName;
                NodeList childrenNodes = (NodeList)xPath.evaluate(childNodeName + "/*", unboundedXMLData, XPathConstants.NODESET);
                if (childrenNodes.getLength() == 0 || XMLUtils.isRichTextDataNode(childrenNodes)) {
                    nodeValue = XMLUtils.getXMLfromXsdDom((Element)xPath.evaluate(childNodeName + "/*", unboundedXMLData, XPathConstants.NODE), true);
                    if (nodeValue.length() == 0) {
                        nodeValue = node.getTextContent();
                    }
                    jsonWriter.key(nodeName).value(nodeValue);
                    continue;
                }
                jsonWriter.key(nodeName).object();
                XMLUtils.convertUnboundedNodeToJson(childNodeName, xPath, unboundedXMLData, jsonWriter);
                jsonWriter.endObject();
            }
        }
    }

    private static boolean isRichTextDataNode(NodeList childrenNodes) {
        boolean isRichText = false;
        if (childrenNodes != null && childrenNodes.item(0) != null && GuideConstants.RICH_TEXT_FIRST_TAG_NAME.equalsIgnoreCase(childrenNodes.item(0).getNodeName())) {
            isRichText = true;
        }
        return isRichText;
    }

    public static String getPrefillXmlWithoutBoundPart(Document doc) {
        try {
            if (XMLUtils.isWrappedXml(doc)) {
                XPath xPath = XPathFactory.newInstance().newXPath();
                org.w3c.dom.Node afBoundData = (org.w3c.dom.Node)xPath.evaluate("afBoundData", doc.getDocumentElement(), XPathConstants.NODE);
                if (afBoundData != null) {
                    doc.getDocumentElement().removeChild(afBoundData);
                }
                return XMLUtils.getXMLfromXsdDom(doc.getDocumentElement());
            }
            return XMLUtils.getXMLfromXsdDom(doc.getDocumentElement());
        }
        catch (Exception e) {
            throw new GuideException("Error in getting bound xml part" + e.getMessage(), e);
        }
    }

    public static String getXMLFromDom(Document doc, String tagName) {
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            org.w3c.dom.Node xmlNode = (org.w3c.dom.Node)xPath.evaluate(tagName + "/*", doc.getDocumentElement(), XPathConstants.NODE);
            return XMLUtils.getXMLfromXsdDom((Element)xmlNode);
        }
        catch (Exception e) {
            throw new GuideException("Error in Getting XML of the element <" + tagName + "> From DOM", e);
        }
    }

    @Deprecated
    public static InputStream getDataRefInputStream(String dataRef, FormDataXMLProviderRegistry formDataXMLProviderRegistry, ResourceResolverHelper resourceResolverHelper) {
        String xml = null;
        try {
            if (dataRef.startsWith("crx://")) {
                Resource fileResource = resourceResolverHelper.getResourceResolver().resolve(dataRef.substring(6));
                Node jcrNode = (Node)fileResource.adaptTo(Node.class);
                Node jcrContent = jcrNode.getNode("jcr:content");
                return jcrContent.getProperty("jcr:data").getBinary().getStream();
            }
            if (!(dataRef.startsWith("https://") || dataRef.startsWith("http://") || dataRef.startsWith("file://"))) {
                xml = formDataXMLProviderRegistry.getDataXMLFromService(dataRef);
                if (logger.isDebugEnabled()) {
                    logger.debug("[AEMForm] XML Recieved from Prefill Service = " + xml);
                }
                if (xml != null && xml.length() > 0) {
                    return new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
                }
                return null;
            }
            URL url = new URL(dataRef);
            return url.openStream();
        }
        catch (PathNotFoundException e) {
            logger.error("[AEMForm] unable to locate Data XML in the repository " + dataRef + ": " + e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error("[AEMForm] Exception while reading Data XML in the repository " + dataRef + ": " + e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("[AEMForm] Unable to read xml using UTF-8 encoding for the " + dataRef + "," + xml + ": " + e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error("[AEMForm] Malformed URL passed for getting the xml " + dataRef + ": " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("[AEMForm] Unable to read from the dataRef URL " + dataRef + ": " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Deprecated
    public static Document exportDocumentFromDataRef(String dataRef, DocumentBuilder builder, FormDataXMLProviderRegistry formDataXMLProviderRegistry, ResourceResolverHelper resourceResolverHelper) throws Exception {
        Document doc = null;
        if (dataRef.startsWith("crx://")) {
            Resource fileResource = resourceResolverHelper.getResourceResolver().resolve(dataRef.substring(6));
            if (fileResource instanceof NonExistingResource) {
                return null;
            }
            Node jcrNode = (Node)fileResource.adaptTo(Node.class);
            Node jcrContent = jcrNode.getNode("jcr:content");
            InputStream is = jcrContent.getProperty("jcr:data").getBinary().getStream();
            byte[] fileBytes = IOUtils.toByteArray((InputStream)is);
            is.close();
            doc = builder.parse(new ByteArrayInputStream(fileBytes));
        } else if (!(dataRef.startsWith("https://") || dataRef.startsWith("http://") || dataRef.startsWith("file://"))) {
            InputSource inputSource = new InputSource(new StringReader(formDataXMLProviderRegistry.getDataXMLFromService(dataRef)));
            doc = builder.parse(inputSource);
        }
        if (doc == null) {
            URL url = new URL(dataRef);
            InputStream in = url.openStream();
            doc = builder.parse(in);
            in.close();
        }
        return doc;
    }

    private static void addNodeToDocument(org.w3c.dom.Node currentNode, org.w3c.dom.Node toAdd, org.w3c.dom.Node refNode) {
        if (refNode != null) {
            currentNode.insertBefore(toAdd, refNode);
        } else {
            currentNode.appendChild(toAdd);
        }
    }

    public static org.w3c.dom.Node createNode(Document dataDoc, XPath xPath, org.w3c.dom.Node node, String path) throws XPathExpressionException {
        return XMLUtils.createNode(dataDoc, xPath, node, path, null);
    }

    public static org.w3c.dom.Node createNode(Document dataDoc, XPath xPath, org.w3c.dom.Node node, String path, org.w3c.dom.Node refNode) throws XPathExpressionException {
        String[] pathTokens = path.split("/");
        org.w3c.dom.Node currentNode = node;
        int pathTokensSize = pathTokens.length;
        for (int i = 0; i < pathTokensSize; ++i) {
            Element elNode;
            String pathToken = pathTokens[i];
            boolean isLastToken = i == pathTokensSize - 1;
            org.w3c.dom.Node newNode = (org.w3c.dom.Node)xPath.evaluate(pathToken, currentNode, XPathConstants.NODE);
            if (newNode == null) {
                if (pathToken.charAt(0) == '@') {
                    Attr newAttribute = dataDoc.createAttribute(pathToken.substring(1));
                    ((Element)currentNode).setAttributeNode(newAttribute);
                    newNode = newAttribute;
                } else if ("text()".equals(pathToken)) {
                    Text textNode = dataDoc.createTextNode(null);
                    XMLUtils.addNodeToDocument(currentNode, textNode, refNode);
                    newNode = textNode;
                } else {
                    if (XMLUtils.checkIfStringHasIndexOperator(pathToken)) {
                        pathToken = StringUtils.substringBefore((String)pathToken, (String)"[");
                    }
                    elNode = dataDoc.createElement(pathToken);
                    XMLUtils.addNodeToDocument(currentNode, elNode, refNode);
                    newNode = elNode;
                }
            } else if (isLastToken && pathToken.charAt(0) != '@' && !"text()".equals(pathToken)) {
                elNode = dataDoc.createElement(pathToken);
                XMLUtils.addNodeToDocument(currentNode, elNode, refNode);
                newNode = elNode;
            }
            currentNode = newNode;
        }
        return currentNode;
    }

    public static void removeFromDocument(XPath xPath, org.w3c.dom.Node currentNode, String path) {
        try {
            org.w3c.dom.Node parentNode;
            org.w3c.dom.Node toDelete = (org.w3c.dom.Node)xPath.evaluate(path, currentNode, XPathConstants.NODE);
            if (toDelete != null && (parentNode = toDelete.getParentNode()) != null) {
                parentNode.removeChild(toDelete);
            }
        }
        catch (XPathExpressionException ex) {
            logger.error("Invalid Xpath Syntax: " + path, (Throwable)ex);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
    }

    public static void createAttachmentTag(Document document, org.w3c.dom.Node fileComponentNode, JSONObject jsonObject) {
        try {
            JSONObject commentsJson;
            Element fileAttachments = document.createElement("fileAttachment");
            fileComponentNode.appendChild(fileAttachments);
            fileAttachments.setTextContent(jsonObject.getString("files"));
            JSONObject items = jsonObject.getJSONObject("items");
            if (items.has("comment") && (commentsJson = items.getJSONObject("comment")).has("_value")) {
                Element comments = document.createElement("comment");
                comments.setTextContent(commentsJson.getString("_value"));
                fileComponentNode.appendChild(comments);
            }
        }
        catch (Exception e) {
            logger.error("Error in creating file attachment tag", (Throwable)e);
        }
    }

    public static org.w3c.dom.Node addToDocument(Document dataDoc, XPath xPath, org.w3c.dom.Node currentNode, String path, Object value) {
        try {
            org.w3c.dom.Node toUpdate = (org.w3c.dom.Node)xPath.evaluate(path, currentNode, XPathConstants.NODE);
            if (toUpdate == null) {
                toUpdate = XMLUtils.createNode(dataDoc, xPath, currentNode, path);
            }
            XMLUtils._updateValue(dataDoc, toUpdate, value);
            return toUpdate;
        }
        catch (XPathExpressionException ex) {
            logger.warn("Invalid Xpath Syntax: " + path, (Throwable)ex);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
        return null;
    }

    private static void _updateValue(Document dataDoc, org.w3c.dom.Node toUpdate, Object value) {
        switch (toUpdate.getNodeType()) {
            case 2: {
                if (!(value instanceof String)) break;
                ((Attr)toUpdate).setValue((String)value);
                break;
            }
            case 1: {
                if (value instanceof String) {
                    toUpdate.setTextContent((String)value);
                    break;
                }
                if (value instanceof org.w3c.dom.Node) {
                    value = dataDoc.importNode((org.w3c.dom.Node)value, true);
                    while (toUpdate.hasChildNodes()) {
                        toUpdate.removeChild(toUpdate.getFirstChild());
                    }
                    toUpdate.appendChild((org.w3c.dom.Node)value);
                    break;
                }
                logger.debug("Unsupported type of value");
                break;
            }
            case 3: {
                if (!(value instanceof String)) break;
                toUpdate.setNodeValue((String)value);
                break;
            }
        }
    }

    public static org.w3c.dom.Node addToDocument(Document dataDoc, XPath xPath, org.w3c.dom.Node currentNode, String path, Object value, org.w3c.dom.Node refNode) {
        try {
            org.w3c.dom.Node toUpdate = (org.w3c.dom.Node)xPath.evaluate(path, currentNode, XPathConstants.NODE);
            if (toUpdate == null) {
                toUpdate = XMLUtils.createNode(dataDoc, xPath, currentNode, path, refNode);
            }
            XMLUtils._updateValue(dataDoc, toUpdate, value);
            return toUpdate;
        }
        catch (XPathExpressionException ex) {
            logger.warn("Invalid Xpath Syntax: " + path, (Throwable)ex);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GuideException(e);
        }
        return null;
    }

    public static boolean isXsd(JSONObject obj) {
        String bindRef = obj.optString("bindRef");
        return StringUtils.isNotBlank((CharSequence)bindRef) && StringUtils.startsWith((CharSequence)bindRef, (CharSequence)"/");
    }

    public static boolean isWrappedXml(Document doc) {
        try {
            return "afData".equals(doc.getDocumentElement().getTagName());
        }
        catch (Exception e) {
            logger.debug("Error while trying to check document root tag : " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean isWrappedXmlStr(String docStr) {
        if (StringUtils.isNotBlank((CharSequence)docStr)) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                XMLUtils.disableExternalEntities(dbf);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(new InputSource(new StringReader(docStr)));
                return XMLUtils.isWrappedXml(doc);
            }
            catch (SAXException e) {
                logger.error("Error while parsing Guide Prefill Xml String : " + e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Error while parsing Guide Prefill Xml String : " + e.getMessage(), (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                logger.error("Error while parsing Guide Prefill Xml String : " + e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isValidXsdRoot(String root) {
        return StringUtils.isNotBlank((CharSequence)root) && root.matches("[a-zA-Z].*");
    }

    public static Document getEmptySubmitDoc() {
        Document doc = XMLUtils.strToDoc(xmlSkeleton);
        if (!(doc instanceof Document)) {
            logger.debug("Unable to Generate Empty Xml Doc");
            return null;
        }
        return doc;
    }

    public static String getChildBoundRootXpath(String fsRoot, String bindRefPrefix, String childRoot) {
        String xpath = "";
        if (StringUtils.isBlank((CharSequence)bindRefPrefix)) {
            if (XMLUtils.isValidXsdRoot(childRoot) && !StringUtils.equals((CharSequence)fsRoot, (CharSequence)childRoot)) {
                xpath = childRoot;
            }
        } else {
            xpath = XMLUtils.getRelativeXpath(bindRefPrefix, fsRoot);
        }
        return xpath;
    }

    public static List<org.w3c.dom.Node> getNamedChildNodes(org.w3c.dom.Node parent, String childNode) {
        ArrayList<org.w3c.dom.Node> nodes = new ArrayList<org.w3c.dom.Node>();
        if (parent == null || StringUtils.isEmpty((CharSequence)childNode)) {
            return nodes;
        }
        NodeList children = parent.getChildNodes();
        int count = children.getLength();
        for (int i = 0; i < count; ++i) {
            org.w3c.dom.Node node = children.item(i);
            if (!StringUtils.equals((CharSequence)childNode, (CharSequence)node.getNodeName())) continue;
            nodes.add(node);
        }
        NamedNodeMap attributeMap = parent.getAttributes();
        org.w3c.dom.Node attributeNode = attributeMap.getNamedItem(childNode);
        if (attributeNode != null) {
            nodes.add(attributeNode);
        }
        return nodes;
    }

    public static Object evaluateXPath(String xPathQuery, org.w3c.dom.Node contextNode, QName type) {
        try {
            if (StringUtils.isBlank((CharSequence)xPathQuery)) {
                return contextNode;
            }
            XPathFactory xpFactory = XPathFactory.newInstance();
            XPath xPath = xpFactory.newXPath();
            return xPath.evaluate(xPathQuery, contextNode, type);
        }
        catch (XPathExpressionException e) {
            logger.debug("Unable to evaluate XPath" + xPathQuery, (Throwable)e);
            return null;
        }
    }

    public static void copyChildren(org.w3c.dom.Node source, org.w3c.dom.Node target) {
        if (source == null || target == null) {
            return;
        }
        Document destination = target.getOwnerDocument();
        DocumentFragment container = destination.createDocumentFragment();
        NodeList children = source.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            container.appendChild(destination.importNode(children.item(i), true));
        }
        target.appendChild(container);
    }

    public static Document getChildXmlDoc(Element fsUnBoundDataRoot, Element fsBoundDataRoot, String childBoundRootXpath, boolean keepBoundPart) {
        Document childDoc = XMLUtils.getEmptySubmitDoc();
        XMLUtils.copyChildren(fsUnBoundDataRoot, XMLUtils.getUnboundDataXmlElement(childDoc));
        if (keepBoundPart) {
            Element childBoundRoot = (Element)XMLUtils.evaluateXPath(childBoundRootXpath, fsBoundDataRoot, XPathConstants.NODE);
            if (childBoundRoot == null) {
                childBoundRoot = fsBoundDataRoot;
            }
            XMLUtils.copyChildren(childBoundRoot, XMLUtils.getBoundDataXmlElement(childDoc));
        }
        return childDoc;
    }

    private static String getStringFromNode(org.w3c.dom.Node node) {
        return XMLUtils.getStringFromNode(node, false);
    }

    private static String getStringFromNode(org.w3c.dom.Node node, boolean ignoreWhitespace) {
        DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)node.getOwnerDocument().getImplementation());
        LSSerializer lsSerializer = domImplementation.createLSSerializer();
        lsSerializer.getDomConfig().setParameter("xml-declaration", false);
        NodeList childNodes = node.getChildNodes();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            org.w3c.dom.Node child = childNodes.item(i);
            if (ignoreWhitespace && XMLUtils.isWhitespaceNode(child)) continue;
            sb.append(lsSerializer.writeToString(child));
        }
        return sb.toString();
    }

    private static boolean isWhitespaceNode(org.w3c.dom.Node node) {
        if (node.getNodeType() == 3) {
            String val = node.getNodeValue();
            return val.trim().length() == 0;
        }
        return false;
    }

    public static String nodeToStr(org.w3c.dom.Node node, Boolean omitXmlDeclaration) {
        String xmlStr = "";
        try {
            if (node != null) {
                TransformerFactory transfac = TransformerFactory.newInstance();
                Transformer trans = transfac.newTransformer();
                trans.setOutputProperty("omit-xml-declaration", omitXmlDeclaration != false ? "yes" : "no");
                trans.setOutputProperty("method", "xml");
                trans.setOutputProperty("indent", "yes");
                trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(2));
                StringWriter sw = new StringWriter();
                StreamResult result = new StreamResult(sw);
                DOMSource source = new DOMSource(node);
                trans.transform(source, result);
                xmlStr = sw.toString();
            }
        }
        catch (Exception e) {
            logger.error("Exception while converting document to xml", (Throwable)e);
        }
        return xmlStr;
    }

    @Deprecated
    public static String docToStr(Document doc) {
        String xmlStr = "";
        try {
            return XMLUtils.nodeToStr(doc, false);
        }
        catch (Exception e) {
            logger.error("Exception while converting document to xml", (Throwable)e);
            return xmlStr;
        }
    }

    public static NodeList getNodeListFromXmlString(String xmlStr) {
        NodeList nodeList = null;
        try {
            String tempRootBeginTag = "<tempRoot>";
            String tempRootEndTag = "</tempRoot>";
            String rootAppendedString = tempRootBeginTag + xmlStr + tempRootEndTag;
            nodeList = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(rootAppendedString.getBytes(StandardCharsets.UTF_8))).getDocumentElement().getChildNodes();
        }
        catch (Exception e) {
            throw new GuideException("Error in getting node list from xml " + e.getMessage(), e);
        }
        return nodeList;
    }

    public static void appendNodeListToNode(org.w3c.dom.Node rootNode, NodeList nodeList) {
        Document doc = rootNode.getOwnerDocument();
        for (int j = 0; j < nodeList.getLength(); ++j) {
            rootNode.appendChild(doc.importNode(nodeList.item(j), true));
        }
    }

    public static Document strToDoc(String xmlStr) {
        Document doc = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            XMLUtils.disableExternalEntities(dbFactory);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            doc = dBuilder.parse(new InputSource(new StringReader(xmlStr)));
            doc.getDocumentElement().normalize();
        }
        catch (Exception e) {
            logger.debug("Unable to Generate Xml Doc from String : " + xmlStr, (Throwable)e);
        }
        return doc;
    }

    public static List<String> extractAttachmentNames(Document doc) {
        ArrayList<String> attachmentNames = new ArrayList<String>();
        NodeList attachments = (NodeList)XMLUtils.evaluateXPath("//fileAttachment", doc.getDocumentElement(), XPathConstants.NODESET);
        if (attachments != null) {
            int length = attachments.getLength();
            for (int i = 0; i < length; ++i) {
                String[] fileNames;
                Element attachment = (Element)attachments.item(i);
                String combinedNames = attachment.getTextContent();
                if (!StringUtils.isNotBlank((CharSequence)combinedNames) || (fileNames = combinedNames.split("\\r?\\n")).length <= 0) continue;
                attachmentNames.addAll(Arrays.asList(fileNames));
            }
        }
        return attachmentNames;
    }

    public static void disableExternalEntities(DocumentBuilderFactory factory) {
        DocumentBuilderUtil.disableExternalEntities((DocumentBuilderFactory)factory);
    }

    private static Document getDomFromXMLString(String xmlString, boolean isNameSpaceAware) {
        Document dataDoc = null;
        if (StringUtils.isNotEmpty((CharSequence)xmlString)) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(isNameSpaceAware);
            XMLUtils.disableExternalEntities(dbf);
            try {
                DocumentBuilder db = dbf.newDocumentBuilder();
                dataDoc = db.parse(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)));
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.debug("[AF]:[XMLUtils] failed to get XML Document from data");
            }
        }
        return dataDoc;
    }

    private static Element createXMLTag(Document dataDoc, String key, String value) {
        Element childTag = dataDoc.createElement(key);
        childTag.setTextContent(value);
        return childTag;
    }

    public static String replaceDefaultNSWithAFNS(String xmlString) {
        String defaultNSPattern = "xmlns=\\\"(.*)\\\"";
        return xmlString.replaceAll(defaultNSPattern, "xmlns:defaultAFNS=\\\"$1\\\"");
    }

    public static String replaceAFNSWithDefaultNS(String xmlString) {
        String defaultAFNSPattern = "xmlns:defaultAFNS=\\\"(.*)\\\"";
        return xmlString.replaceAll(defaultAFNSPattern, "xmlns=\\\"$1\\\"");
    }

    public static String syncExcludeFromDorData(String dataXML, String ServerSideExcludeFromDorData) {
        String newData = "";
        try {
            Document doc = XMLUtils.strToDoc(dataXML);
            if (XMLUtils.isWrappedXml(doc)) {
                Element afSubmissionInfoTag = XMLUtils.getSubmissionInfoDataXmlElement(doc, null);
                Element oldExcludeFromDoRTag = XMLUtils.getSubmissionInfoDataXmlElement(doc, "excludeFromDoR");
                Element newExcludeFromDorTag = doc.createElement("excludeFromDoR");
                newExcludeFromDorTag.setTextContent(ServerSideExcludeFromDorData);
                if (afSubmissionInfoTag == null) {
                    afSubmissionInfoTag = doc.createElement("afSubmissionInfo");
                    afSubmissionInfoTag.appendChild(newExcludeFromDorTag);
                    doc.getDocumentElement().appendChild(afSubmissionInfoTag);
                } else {
                    if (oldExcludeFromDoRTag != null) {
                        afSubmissionInfoTag.removeChild(oldExcludeFromDoRTag);
                    }
                    afSubmissionInfoTag.appendChild(newExcludeFromDorTag);
                }
                newData = XMLUtils.nodeToStr(doc, true);
            } else {
                newData = dataXML;
            }
        }
        catch (Exception ex) {
            logger.error("Error occurred while aligning excludeFromDor data in data.xml with the one computed in server.", (Throwable)ex);
        }
        return newData;
    }

    public static String addReCaptchaDataInXML(String formData, String updatePath, String score) {
        Document dataDoc = XMLUtils.getDomFromXMLString(formData, true);
        String response = formData;
        if (dataDoc != null) {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Element typeTag = XMLUtils.createXMLTag(dataDoc, "captchaType", "reCaptchaEnterprise");
            Element scoreTag = XMLUtils.createXMLTag(dataDoc, "captchaScore", score);
            Element reCaptchaNode = (Element)XMLUtils.addToDocument(dataDoc, xPath, dataDoc.getDocumentElement(), updatePath, "");
            reCaptchaNode.appendChild(typeTag);
            reCaptchaNode.appendChild(scoreTag);
            response = XMLUtils.nodeToStr(dataDoc, false);
        }
        return response;
    }
}

