/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemfd.dermis.authentication.exception;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class DermisLogger {
    public static final int LOG_FATAL = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_WARN = 2;
    public static final int LOG_INFO = 3;
    public static final int LOG_DEBUG = 4;
    public static final int LOG_TRACE = 5;
    private static final Logger logger = LoggerFactory.getLogger(DermisLogger.class);
    public static final String BUNDLE_NAME = "exceptions";
    public static final String PERF_START = " !PERFORMANCE! < {} >";
    public static final String PERF_END = " !PERFORMANCE! < {}  time: '{}ms'>";
    private static final Map<String, ResourceBundle> resourceBundles = new HashMap<String, ResourceBundle>();
    private static final LinkedHashMap<String, StopWatch> performStopWatch;

    private DermisLogger() {
    }

    public static void addResourceBundle(String key, ResourceBundle resourceBundle) {
        if (resourceBundle != null) {
            resourceBundles.put(key, resourceBundle);
        }
    }

    public static String getString(String key) {
        String unresolvedMsg = "";
        try {
            if (StringUtils.isNotBlank((String)key) && key.length() > 7) {
                String resourceKey = key.substring(0, 7);
                ResourceBundle resourceBundle = resourceBundles.get(resourceKey);
                unresolvedMsg = resourceBundle != null ? resourceBundle.getString(key) : key;
            }
        }
        catch (MissingResourceException e) {
            logger.debug("Error in finding resource.", (Throwable)e);
            unresolvedMsg = key;
        }
        return unresolvedMsg;
    }

    public static void logMessage(Class class1, int severity, String resourceID, String[] args) {
        Logger logger = LoggerFactory.getLogger((Class)class1);
        DermisLogger.logMessage(logger, DermisLogger.getString(resourceID, args), severity, null);
    }

    public static void logMessage(Class class1, int severity, String resourceID, String[] args, Throwable cause) {
        Logger logger = LoggerFactory.getLogger((Class)class1);
        String logMessage = DermisLogger.getString(resourceID, args);
        DermisLogger.logMessage(logger, logMessage, severity, cause);
    }

    private static void logMessage(Logger logger, String logString, int severity, Throwable cause) {
        switch (severity) {
            case 0: 
            case 1: {
                if (cause == null) {
                    logger.error(logString);
                    break;
                }
                logger.error(logString, cause);
                break;
            }
            case 2: {
                logger.warn(logString);
                break;
            }
            case 3: {
                logger.info(logString);
                break;
            }
            case 5: {
                if (!logger.isTraceEnabled()) break;
                logger.trace(logString);
                break;
            }
            default: {
                logger.debug(logString);
            }
        }
    }

    public static void logMessage(Class class1, int severity, String resourceID) {
        Logger logger = LoggerFactory.getLogger((Class)class1);
        DermisLogger.logMessage(logger, DermisLogger.getString(resourceID), severity, null);
    }

    public static void logAuditMessage(Class class1, String message, String[] arguments) {
        Logger logger = LoggerFactory.getLogger((Class)class1);
        DermisLogger.logMessage(logger, DermisLogger.replaceString(message, arguments), 4, null);
    }

    public static long logPerformance(Class class1, String message, String[] arguments, boolean diff, long timeStamp) {
        Logger logger = LoggerFactory.getLogger((Class)class1);
        String formattedMessage = DermisLogger.replaceString(message, arguments);
        if (!diff) {
            DermisLogger.logMessage(logger, DermisLogger.replaceString(PERF_START, new String[]{formattedMessage}), 5, null);
            return System.currentTimeMillis();
        }
        long difference = System.currentTimeMillis() - timeStamp;
        DermisLogger.logMessage(logger, DermisLogger.replaceString(PERF_END, new String[]{formattedMessage, difference + ""}), 5, null);
        return 0L;
    }

    public static void startPerformTimer(String message) {
        StopWatch stopWatch = new StopWatch();
        performStopWatch.put(message, stopWatch);
        stopWatch.start();
    }

    public static void endPerformTimer(String message) {
        StopWatch stopWatch;
        if (performStopWatch.containsKey(message) && (stopWatch = (StopWatch)performStopWatch.remove(message)) != null) {
            stopWatch.stop();
            DermisLogger.logMessage(logger, message + ": " + stopWatch.getTime(), 5, null);
        }
    }

    public static String getString(String resourceID, String[] args) {
        String str = DermisLogger.getString(resourceID);
        String message = "";
        message = str.length() > 0 ? DermisLogger.replaceString(str, args) : DermisLogger.replaceString(resourceID, args);
        return message;
    }

    public static String replaceString(String message, String[] args) {
        String formattedMessage = message;
        if (args != null) {
            FormattingTuple s = MessageFormatter.arrayFormat((String)message, (Object[])args);
            formattedMessage = s.getMessage();
        }
        return formattedMessage;
    }

    public static void logErrorAndDebug(Class clazz, String errorMsg, Exception e) {
        Logger logger = LoggerFactory.getLogger((Class)clazz);
        logger.error(errorMsg);
        logger.debug(errorMsg + " : ", (Throwable)e);
    }

    public static void logErrorAndDebug(Class clazz, String errorMsg, String debugMsg) {
        Logger logger = LoggerFactory.getLogger((Class)clazz);
        logger.error(errorMsg);
        logger.debug(debugMsg);
    }

    static {
        resourceBundles.put("AEM-AUT", ResourceBundle.getBundle(BUNDLE_NAME));
        int maxEntries = 100;
        performStopWatch = new LinkedHashMap<String, StopWatch>(100){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 100;
            }
        };
    }
}

