/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.encryption.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionServiceException
extends Exception {
    private static final long serialVersionUID = 4030787128846949310L;
    private int errorCode = 0;
    public static final int E_ERR = 1;
    public static final int E_OPERATION_FAILED = 259;
    public static final int E_TODO = 513;
    public static final int E_COMPAT = 769;
    public static final int E_ENC_OPT = 770;
    public static final int E_ENCRYPTED = 771;
    public static final int E_NOT_ENCRYPTED = 772;
    public static final int E_WRONG_PERMISSIONS = 772;
    public static final int E_BAD_PDF_ENCRYPTION = 773;
    public static final int E_ENCRYPTION_FAILED = 774;
    public static final int E_BAD_PERMNISSION = 775;
    public static final int E_SIGNATURE = 776;
    public static final int E_CERTIFICATE_NOT_PRESENT = 777;
    public static final int E_NOT_FIPS_COMPLIANT = 778;
    public static final int E_INCORRECT_CERTIFICATE = 779;
    public static final int E_INCORRECT_CREDENTIAL = 780;
    public static final int E_RE = 781;
    public static final int E_INSUFF_PRIV = 782;
    public static final int E_INVALID_ARG = 783;
    private String initCauseStackTrace = null;
    protected static Logger logger = LoggerFactory.getLogger((String)"com.adobe.fd.encryption.client.EncryptionServiceException");
    protected String errMsg = "";
    protected StringBuffer stackTrace = new StringBuffer("");
    private static Properties props = new Properties();

    public EncryptionServiceException(int errorCode) {
        this("", errorCode);
    }

    public EncryptionServiceException(String message, int errorCode) {
        this(message, errorCode, null);
    }

    public EncryptionServiceException(String message, int errorCode, Throwable cause) {
        this(message, null, errorCode, cause);
    }

    public EncryptionServiceException(String message, Object[] params, int errorCode) {
        this(message, params, errorCode, null);
    }

    public EncryptionServiceException(String message, Object[] params, int errorCode, Throwable cause) {
        super(EncryptionServiceException.getErrMessage(message, params, cause));
        this.errorCode = errorCode;
        this.errMsg = super.getMessage();
        this.stackTrace.append(this.getStackTraceAsString(this));
        StringBuffer innerReason = new StringBuffer();
        while (cause != null) {
            innerReason.append(this.getStackTraceAsString(cause));
            if (cause == cause.getCause()) break;
            cause = cause.getCause();
        }
        this.stackTrace.append(innerReason);
        this.setInitCauseStackTrace(innerReason.toString());
        this.logException();
    }

    public EncryptionServiceException(String message) {
        this(message, 0);
    }

    public EncryptionServiceException(String message, Throwable cause) {
        this(message, 0, cause);
    }

    public EncryptionServiceException(String message, Object[] params) {
        this(message, params, 0, null);
    }

    public EncryptionServiceException(String message, Object[] params, Throwable cause) {
        this(message, params, 0, cause);
    }

    private static String getErrMessage(String errorMsgId, Object[] params, Throwable cause) {
        String message;
        Properties currentProps = props;
        if (errorMsgId == null || errorMsgId.trim().length() == 0) {
            errorMsgId = "AEM-ENC-100-014";
        }
        if (currentProps == null) {
            message = errorMsgId;
        } else {
            String rawMsg = currentProps.getProperty(errorMsgId);
            String formatedMsg = "";
            if (rawMsg != null) {
                formatedMsg = MessageFormat.format(rawMsg, params);
                message = errorMsgId + " " + formatedMsg;
            } else {
                message = errorMsgId;
            }
        }
        StringBuilder messageBuilder = new StringBuilder(message);
        while (cause != null) {
            String causeMsg = cause.getMessage();
            messageBuilder.append("\n Caused By: " + causeMsg);
            if (cause == cause.getCause()) break;
            cause = cause.getCause();
        }
        return messageBuilder.toString();
    }

    public static String makeErrorMessage(String message, int errorCode) {
        String hexErrorCode = Integer.toHexString(errorCode);
        String errorString = "(error code bin: " + errorCode + ", hex: 0x" + hexErrorCode + ")";
        if (message != null && !message.equals("") && !message.equals("null")) {
            return message + " -- " + errorString;
        }
        return errorString;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getInitCauseStackTrace() {
        return this.initCauseStackTrace;
    }

    public void setInitCauseStackTrace(String initCauseStackTrace) {
        this.initCauseStackTrace = initCauseStackTrace;
    }

    @Override
    public void printStackTrace() {
        logger.warn(this.getMessage(), (Throwable)this);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        s.print(this.getMessage() + "\n");
        s.print(this.stackTrace);
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        w.print(this.getMessage() + "\n");
        w.print(this.stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initProps(String fileName, Properties properties, Class currentClass) {
        InputStream is = currentClass.getResourceAsStream(fileName);
        try {
            if (is != null) {
                properties.load(is);
            } else {
                logger.warn("File containing Message Strings not initialised.");
            }
        }
        catch (IOException e) {
            logger.warn("File containing Message Strings not initialised.", (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("File containing Message Strings not initialised.", (Throwable)e);
            }
        }
    }

    private String getStackTraceAsString(Throwable e) {
        StringBuffer sbTemp;
        block3: {
            block5: {
                block4: {
                    sbTemp = new StringBuffer();
                    if (e == null) break block3;
                    if (e != this) break block4;
                    StackTraceElement[] st = e.getStackTrace();
                    if (st == null) break block3;
                    for (int i = 0; i < st.length; ++i) {
                        sbTemp.append(" " + st[i].toString() + "\n");
                    }
                    break block3;
                }
                if (!(e instanceof EncryptionServiceException)) break block5;
                String msg = ((EncryptionServiceException)e).stackTrace.toString();
                if ("".equals(msg = msg.replaceAll("\\n", "\\\n "))) break block3;
                sbTemp.append(" Caused By: " + e.getClass().getName() + " \n");
                sbTemp.append(msg);
                break block3;
            }
            StackTraceElement[] st = e.getStackTrace();
            if (st != null) {
                sbTemp.append(" Caused By: " + e.getClass().getName() + " \n");
                for (int i = 0; i < st.length; ++i) {
                    sbTemp.append(" " + st[i].toString() + "\n");
                }
            }
        }
        return sbTemp.toString();
    }

    private void logException() {
        if (logger.isWarnEnabled()) {
            logger.warn(this.getMessage());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("\n" + this.getInitCauseStackTrace());
        }
    }

    static {
        ResourceBundle rb = ResourceBundle.getBundle("com.adobe.fd.encryption.client.ENCExceptionMsgs");
        Enumeration<String> en = rb.getKeys();
        while (en.hasMoreElements()) {
            String k = en.nextElement();
            props.put(k, rb.getString(k));
        }
    }
}

