/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.forms.foundation.wsdl;

import com.adobe.forms.foundation.fdinternal.utils.DocumentBuilderUtil;
import com.adobe.forms.foundation.wsdl.AuthenticatedResourceLocator;
import com.adobe.forms.foundation.wsdl.CustomEntityResolver;
import com.adobe.forms.foundation.wsdl.CustomWSDLLocator;
import com.adobe.forms.foundation.wsdl.SSLUtils;
import com.adobe.forms.foundation.wsdl.SubstitutionGroupBean;
import com.adobe.forms.foundation.wsdl.WSDLInvokerInternalObject;
import com.adobe.forms.foundation.wsdl.WSDLInvokerParams;
import com.adobe.forms.foundation.wsdl.WSDLResponse;
import com.adobe.forms.foundation.wsdl.WSDLUtils;
import com.adobe.forms.foundation.wsdl.X509TokenSecurityProfileHandler;
import com.adobe.granite.keystore.KeyStoreService;
import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLInvoker {
    protected final Logger log = LoggerFactory.getLogger(WSDLInvoker.class);
    public static final String NAMESPACE = "_namespace";
    public static final String SCHEMA = "_schema";
    public static final String VALUE = "_value";
    public static final String TYPE = "_type";
    public static final String ELEMENT_NAME = "_elementName";
    public static final String ELEMENT_NAMESPACE = "_elementNamespace";
    public static final String FDM_ADDITIONAL_DATA_KEY = "_fdm_additionalData";
    public static final String ATTRIBUTE_DATA_KEY = "_attributes";
    private SOAPConnectionFactory soapConnectionFactory = null;
    private KeyStoreService keyStoreService = null;
    private ResourceResolverFactory resourceResolverFactory = null;
    final String wsdlStdSchemaNamespace = "http://www.w3.org/2001/XMLSchema";
    final String wsdlName = "name";
    final String wsdlNamespace = "namespace";
    final String wsdlOperationPort = "port";
    final String wsdlOperationInput = "input";
    final String wsdlOperationOutput = "output";
    final String wsdlOperationParams = "params";
    final String wsdlOperationActionUri = "soapActionURI";
    final String wsdlOperationServiceUri = "serviceEndPoint";
    final String wsdlParamType = "type";
    final String wsdlParamPropIsNillable = "isNillable";
    final String wsdlParamPropIsRepeated = "isRepeated";
    final String wsdlParamPropMinOccurs = "minOccurs";
    final String wsdlParamPropMaxOccurs = "maxOccurs";
    final String wsdlSoapHeaderSoapAction = "SOAPAction";
    private String wsdlCurrentOperation = "";
    private boolean arrayErrorLogged = false;

    public WSDLInvoker(SOAPConnectionFactory soapConnectionFactory) {
        this.soapConnectionFactory = soapConnectionFactory;
    }

    public WSDLInvoker(SOAPConnectionFactory soapConnectionFactory, KeyStoreService keyStoreService, ResourceResolverFactory resourceResolverFactory) {
        this.soapConnectionFactory = soapConnectionFactory;
        this.keyStoreService = keyStoreService;
        this.resourceResolverFactory = resourceResolverFactory;
    }

    private String getCurrentOperation() {
        return this.wsdlCurrentOperation;
    }

    private void setCurrentOperation(String operationName) {
        this.wsdlCurrentOperation = operationName;
        this.arrayErrorLogged = false;
    }

    private void fetchWSDL(WSDLInvokerInternalObject wsdlInvokerInternalObject, String endPoint) throws Exception {
        if (endPoint == null) {
            throw new Exception("fetchWSDL: Invalid Arguments. Endpoint cannot be null.");
        }
        try {
            Definition definition;
            if (this.isAuthenticationRequiredForWsdl(wsdlInvokerInternalObject)) {
                AuthenticatedResourceLocator resourceLocator = new AuthenticatedResourceLocator(wsdlInvokerInternalObject.getParams().getHttpHeaders());
                CustomWSDLLocator locator = new CustomWSDLLocator(endPoint, resourceLocator, this.keyStoreService, this.resourceResolverFactory, wsdlInvokerInternalObject.getParams());
                definition = this.getWSDLReader().readWSDL((WSDLLocator)locator);
            } else {
                definition = this.readWSDL(endPoint, wsdlInvokerInternalObject);
            }
            wsdlInvokerInternalObject.setDefinition(definition);
        }
        catch (WSDLException e) {
            throw new Exception("fetchWSDL" + e.getMessage());
        }
    }

    private WSDLReader getWSDLReader() throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        return wsdlReader;
    }

    private Document getDocument(InputSource inputSource, String uri, boolean disableExternalEntities) throws WSDLException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        if (disableExternalEntities) {
            DocumentBuilderUtil.disableExternalEntities((DocumentBuilderFactory)documentBuilderFactory);
        }
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new WSDLException("PARSER_ERROR", "Problem parsing '" + uri + "'.", (Throwable)exception);
        }
    }

    private Definition readWSDL(String endPoint, WSDLInvokerInternalObject wsdlInvokerInternalObject) throws WSDLException {
        try {
            WSDLReader wsdlReader = this.getWSDLReader();
            URL url = com.ibm.wsdl.util.StringUtils.getURL(null, (String)endPoint);
            boolean isHttps = url.toString().toLowerCase().startsWith("https");
            if (isHttps && this.keyStoreService != null && this.resourceResolverFactory != null && this.isMutualSSLAuthentication(wsdlInvokerInternalObject)) {
                String mutualSSLKeyAlias = this.getMutualSSLKeyAlias(wsdlInvokerInternalObject);
                SSLContext sslContext = SSLUtils.getSSLContext(this.resourceResolverFactory, "readCloudService", "sslFDM", this.keyStoreService, this.keyStoreService, mutualSSLKeyAlias);
                HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
            }
            InputStream contentAsInputStream = com.ibm.wsdl.util.StringUtils.getContentAsInputStream((URL)url);
            InputSource inputSource = new InputSource(contentAsInputStream);
            inputSource.setSystemId(url.toString());
            boolean isDisableExternalEntities = wsdlInvokerInternalObject.getParams().isDisableExternalEntities();
            Document document = this.getDocument(inputSource, url.toString(), isDisableExternalEntities);
            contentAsInputStream.close();
            return wsdlReader.readWSDL(url.toString(), document);
        }
        catch (WSDLException wsdlException) {
            throw wsdlException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new WSDLException("OTHER_ERROR", "Unable to resolve imported document at '" + endPoint + "'.", (Throwable)exception);
        }
    }

    private boolean isAuthenticationRequiredForWsdl(WSDLInvokerInternalObject wsdlInvokerInternalObject) {
        return wsdlInvokerInternalObject.getParams() != null && wsdlInvokerInternalObject.getParams().getHttpHeaders() != null && wsdlInvokerInternalObject.getParams().getHttpHeaders().size() > 0;
    }

    private void setEndPoint(WSDLInvokerInternalObject wsdlInvokerParam, String endPoint) throws Exception {
        wsdlInvokerParam.setEndPoint(endPoint);
        StringWriter strWriter = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)strWriter);
        wsdlInvokerParam.setStrWriter(strWriter);
        wsdlInvokerParam.setJsonWriter(jsonWriter);
    }

    private InputStream prepareSchema(WSDLInvokerInternalObject wsdlInvokerInternalObject, Element el) throws Exception {
        Map namespaces = wsdlInvokerInternalObject.getDefinition().getNamespaces();
        for (Map.Entry ns : namespaces.entrySet()) {
            if (((String)ns.getKey()).equals("")) continue;
            el.setAttribute("xmlns:" + (String)ns.getKey(), (String)ns.getValue());
        }
        String endpoint = wsdlInvokerInternalObject.getEndPoint();
        if (endpoint == null) {
            throw new Exception("prepareSchema: Invalid Arguments. Endpoint cannot be null.");
        }
        String contextUrl = endpoint.substring(0, endpoint.lastIndexOf("/") + 1);
        NodeList imports = el.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
        for (int i = 0; i < imports.getLength(); ++i) {
            Element currentImport = (Element)imports.item(i);
            String location = currentImport.getAttribute("schemaLocation");
            boolean isAbsolute = location.startsWith("http");
            if (isAbsolute) continue;
            currentImport.setAttribute("schemaLocation", contextUrl + location);
        }
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(el);
        StreamResult result = new StreamResult(os);
        transformer.transform(source, result);
        String temp = ((Object)os).toString();
        return new ByteArrayInputStream(temp.getBytes());
    }

    private void expandBuiltInType(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSElementDecl element, boolean isNillable, boolean isRepeated, int minOccurs, int maxOccurs) throws Exception {
        try {
            XSType type = element.getType();
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.object();
            jsonWriter.key("name").value((Object)element.getName());
            jsonWriter.key("type").value((Object)element.getType().getName());
            jsonWriter.key("namespace").value((Object)element.getTargetNamespace());
            jsonWriter.key("isNillable").value(isNillable);
            jsonWriter.key("isRepeated").value(isRepeated);
            jsonWriter.key("minOccurs").value((long)minOccurs);
            jsonWriter.key("maxOccurs").value((long)maxOccurs);
            if (WSDLUtils.enableDebugging) {
                // empty if block
            }
            jsonWriter.endObject();
        }
        catch (JSONException e) {
            throw new Exception("expandBuiltInType", e);
        }
    }

    private void expandSimpleType(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSElementDecl element, XSSimpleType simpleType, boolean isNillable, boolean isRepeated, int minOccurs, int maxOccurs) throws Exception {
        XSRestrictionSimpleType restrictions = simpleType.asRestriction();
        XSListSimpleType lists = simpleType.asList();
        XSComplexType complex = simpleType.asComplexType();
        XSUnionSimpleType union = simpleType.asUnion();
        if (lists != null || complex != null || union != null) {
            throw new Exception("Unsupported Simple Type");
        }
        if (restrictions != null) {
            XSType baseType = restrictions.getBaseType();
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.object();
            jsonWriter.key("name").value((Object)element.getName());
            jsonWriter.key("type").value((Object)baseType.getName());
            jsonWriter.key("namespace").value((Object)element.getTargetNamespace());
            jsonWriter.key("isNillable").value(isNillable);
            jsonWriter.key("isRepeated").value(isRepeated);
            jsonWriter.key("minOccurs").value((long)minOccurs);
            jsonWriter.key("maxOccurs").value((long)maxOccurs);
            List<Object> enumerationValue = this.getEnumerationFacetValue(restrictions);
            if (enumerationValue != null) {
                jsonWriter.key("enumeration").value(enumerationValue);
            }
            for (XSFacet facet : restrictions.getDeclaredFacets()) {
                if (facet.getName().equalsIgnoreCase("enumeration")) continue;
                String value = facet.getValue().toString();
                jsonWriter.key(facet.getName()).value((Object)value);
            }
            jsonWriter.endObject();
        }
    }

    private void addElementAttribute(JSONWriter jsonWriter, Map<String, Object> attrMap) throws JSONException {
        jsonWriter.object();
        jsonWriter.key("__attr");
        jsonWriter.object();
        for (Map.Entry<String, Object> entry : attrMap.entrySet()) {
            jsonWriter.key(entry.getKey()).value(entry.getValue());
        }
        jsonWriter.endObject();
        jsonWriter.endObject();
    }

    private void expandCompositeTypeElement(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSElementDecl element, Stack<String> elementNameChain, boolean isNillable, boolean isRepeated, int minOccurs, int maxOccurs) throws Exception {
        block7: {
            XSType type = element.getType();
            try {
                if (type instanceof XSSimpleType) {
                    this.expandSimpleType(wsdlInvokerInternalObject, element, (XSSimpleType)type, isNillable, isRepeated, minOccurs, maxOccurs);
                    break block7;
                }
                if (type instanceof XSComplexType) {
                    XSContentType content = ((XSComplexType)type).getContentType();
                    XSSimpleType simpleType = content.asSimpleType();
                    if (simpleType == null) {
                        XSTerm term;
                        XSParticle xsParticle = content.asParticle();
                        if (xsParticle != null && (term = xsParticle.getTerm()).isModelGroup()) {
                            XSModelGroup modelGroup = term.asModelGroup();
                            this.groupProcessing(wsdlInvokerInternalObject, modelGroup, elementNameChain);
                        }
                    } else {
                        this.expandSimpleType(wsdlInvokerInternalObject, element, simpleType, isNillable, isRepeated, minOccurs, maxOccurs);
                    }
                    break block7;
                }
                throw new Exception("Unable to handle content type for " + type.getTargetNamespace() + ":" + type.getName());
            }
            catch (JSONException e) {
                throw new Exception("expandCompositeTypeElement", e);
            }
        }
    }

    private void groupProcessing(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSModelGroup modelGroup, Stack<String> elementNameChain) throws Exception {
        XSModelGroup.Compositor compositor = modelGroup.getCompositor();
        if (compositor.equals((Object)XSModelGroup.ALL) || compositor.equals((Object)XSModelGroup.SEQUENCE) || compositor.equals((Object)XSModelGroup.CHOICE)) {
            XSParticle[] particles;
            for (XSParticle particle : particles = modelGroup.getChildren()) {
                XSTerm pterm = particle.getTerm();
                if (pterm.isModelGroup()) {
                    this.groupProcessing(wsdlInvokerInternalObject, pterm.asModelGroup(), elementNameChain);
                    continue;
                }
                boolean isChoiceModelGroup = compositor.equals((Object)XSModelGroup.CHOICE);
                this.navigateSubTypes(wsdlInvokerInternalObject, particle, elementNameChain, isChoiceModelGroup);
            }
        } else {
            this.log.info("Ignoring other model group if exist or still unknown : " + compositor.name());
        }
    }

    private void navigateSubTypes(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSParticle particle, Stack<String> elementNameChain, boolean isChoiceModelGroup) throws Exception {
        XSTerm pterm = particle.getTerm();
        if (pterm.isElementDecl()) {
            int maxOccurs;
            XSElementDecl innerElement = pterm.asElementDecl();
            XSType xsType = innerElement.getType();
            boolean isNillable = innerElement.isNillable();
            boolean isRepeated = particle.isRepeated();
            int minOccurs = 0;
            if (!isChoiceModelGroup) {
                minOccurs = particle.getMinOccurs() != null ? particle.getMinOccurs().intValue() : 1;
            }
            int n = maxOccurs = particle.getMaxOccurs() != null ? particle.getMaxOccurs().intValue() : 1;
            if (xsType instanceof XSSimpleType) {
                if (xsType.getTargetNamespace().compareToIgnoreCase("http://www.w3.org/2001/XMLSchema") == 0) {
                    this.expandBuiltInType(wsdlInvokerInternalObject, innerElement, isNillable, isRepeated, minOccurs, maxOccurs);
                } else {
                    this.expandCompositeTypeElement(wsdlInvokerInternalObject, innerElement, elementNameChain, isNillable, isRepeated, minOccurs, maxOccurs);
                }
            } else if (xsType instanceof XSComplexType) {
                XSContentType content = ((XSComplexType)xsType).getContentType();
                XSSimpleType simpleType = content.asSimpleType();
                if (simpleType == null) {
                    int index = elementNameChain.search(innerElement.getName());
                    if (index == -1) {
                        JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
                        jsonWriter.object();
                        jsonWriter.key(innerElement.getName());
                        jsonWriter.object();
                        jsonWriter.key("namespace").value((Object)innerElement.getTargetNamespace());
                        jsonWriter.key(VALUE);
                        jsonWriter.array();
                        if (isRepeated) {
                            HashMap<String, Object> attrMap = new HashMap<String, Object>();
                            attrMap.put("minOccurs", minOccurs);
                            attrMap.put("maxOccurs", maxOccurs);
                            attrMap.put("isNillable", isNillable);
                            this.addElementAttribute(jsonWriter, attrMap);
                        }
                        elementNameChain.push(innerElement.getName());
                        this.expandCompositeTypeElement(wsdlInvokerInternalObject, innerElement, elementNameChain, false, false, 1, 1);
                        elementNameChain.pop();
                        jsonWriter.endArray();
                        jsonWriter.endObject();
                        jsonWriter.endObject();
                    }
                } else {
                    this.expandSimpleType(wsdlInvokerInternalObject, innerElement, simpleType, isNillable, isRepeated, minOccurs, maxOccurs);
                }
            }
        }
    }

    private void expandElement(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSElementDecl element) throws Exception {
        try {
            boolean i = false;
            if (!(element.getType() instanceof XSComplexType) && !(element.getType() instanceof XSSimpleType)) {
                throw new JSONException("expandElement: Unsupported type " + element.getTargetNamespace() + ":" + element.getName());
            }
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.key(element.getName());
            jsonWriter.object();
            jsonWriter.key("namespace").value((Object)element.getTargetNamespace());
            jsonWriter.key("params");
            jsonWriter.array();
            Stack<String> elementNames = new Stack<String>();
            elementNames.push(element.getName());
            this.expandCompositeTypeElement(wsdlInvokerInternalObject, element, elementNames, false, false, 1, 1);
            jsonWriter.endArray();
            jsonWriter.endObject();
        }
        catch (JSONException e) {
            throw new Exception("expandElement", e);
        }
    }

    private void expandPart(WSDLInvokerInternalObject wsdlInvokerInternalObject, Part part) throws Exception {
        try {
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.object();
            QName elementName = part.getElementName();
            QName typeName = part.getTypeName();
            if (typeName != null) {
                jsonWriter.key(part.getName());
                jsonWriter.value((Object)typeName.toString());
            }
            if (elementName != null) {
                XSElementDecl element = wsdlInvokerInternalObject.getmSchemaSet().getElementDecl(elementName.getNamespaceURI(), elementName.getLocalPart());
                if (element != null) {
                    this.expandElement(wsdlInvokerInternalObject, element);
                } else {
                    throw new Exception("Unable to find element - " + elementName);
                }
            }
            jsonWriter.endObject();
        }
        catch (JSONException e) {
            throw new Exception("expandPart", e);
        }
    }

    private void expandMessage(WSDLInvokerInternalObject wsdlInvokerInternalObject, Message message) throws Exception {
        try {
            Map msgParts = message.getParts();
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.array();
            for (Part part : msgParts.values()) {
                this.expandPart(wsdlInvokerInternalObject, part);
            }
            jsonWriter.endArray();
        }
        catch (TransformerException e) {
            throw new Exception("expandMessage: TransformerException", e);
        }
        catch (SAXException e) {
            throw new Exception("expandMessage: SAXException", e);
        }
        catch (JSONException e) {
            throw new Exception("expandMessage: JSONException", e);
        }
    }

    private void expandOperation(WSDLInvokerInternalObject wsdlInvokerInternalObject, Operation op, Binding binding, String soapAction) throws Exception {
        try {
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            jsonWriter.object();
            jsonWriter.key("name").value((Object)op.getName());
            this.setCurrentOperation(op.getName());
            jsonWriter.key("soapActionURI").value((Object)soapAction);
            String port = WSDLUtils.getPortFromBinding(wsdlInvokerInternalObject.getDefinition(), binding.toString());
            jsonWriter.key("port").value((Object)port);
            String serviceEndPoint = WSDLUtils.getServiceEndPointFromPort(wsdlInvokerInternalObject.getDefinition(), port);
            jsonWriter.key("serviceEndPoint").value((Object)serviceEndPoint);
            Input input = op.getInput();
            jsonWriter.key("input");
            this.expandMessage(wsdlInvokerInternalObject, input.getMessage());
            Output output = op.getOutput();
            jsonWriter.key("output");
            this.expandMessage(wsdlInvokerInternalObject, output.getMessage());
            jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new Exception("expandOperation: IOException", e);
        }
        catch (JSONException e) {
            throw new Exception("expandOperation: JSONException", e);
        }
    }

    private void parseSchemas(WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        if (wsdlInvokerInternalObject.getSchemaObject() != null || wsdlInvokerInternalObject.getmSchemaSet() != null) {
            return;
        }
        if (wsdlInvokerInternalObject.getDefinition() == null) {
            this.fetchWSDL(wsdlInvokerInternalObject, wsdlInvokerInternalObject.getEndPoint());
        }
        XSOMParser parser = new XSOMParser();
        if (this.isAuthenticationRequiredForWsdl(wsdlInvokerInternalObject)) {
            AuthenticatedResourceLocator resourceLocator = new AuthenticatedResourceLocator(wsdlInvokerInternalObject.getParams().getHttpHeaders());
            parser.setEntityResolver((EntityResolver)new CustomEntityResolver(resourceLocator));
        }
        parser.setErrorHandler((ErrorHandler)new DOMErrorHandler());
        Definition wsdlDefinition = wsdlInvokerInternalObject.getDefinition();
        if (wsdlDefinition.getTypes() != null) {
            List list = wsdlDefinition.getTypes().getExtensibilityElements();
            for (int index = 0; index < list.size(); ++index) {
                SchemaImpl schema = (SchemaImpl)wsdlDefinition.getTypes().getExtensibilityElements().get(index);
                Element el = schema.getElement();
                InputStream is = this.prepareSchema(wsdlInvokerInternalObject, el);
                parser.parse(is);
            }
        }
        String targetNamespace = wsdlDefinition.getTargetNamespace();
        XSSchemaSet schemaSet = parser.getResult();
        wsdlInvokerInternalObject.setSchemaObject(schemaSet.getSchema(targetNamespace));
        wsdlInvokerInternalObject.setmSchemaSet(schemaSet);
    }

    public String expandAllOperations(String endPoint, WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        if (wsdlInvokerInternalObject == null) {
            wsdlInvokerInternalObject = new WSDLInvokerInternalObject();
        }
        if (wsdlInvokerInternalObject.getParams() == null) {
            wsdlInvokerInternalObject.setParams(new WSDLInvokerParams());
        }
        String jsonOutput = null;
        this.setEndPoint(wsdlInvokerInternalObject, endPoint);
        this.parseSchemas(wsdlInvokerInternalObject);
        JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
        jsonWriter.array();
        Map allBindings = wsdlInvokerInternalObject.getDefinition().getAllBindings();
        for (Binding binding : allBindings.values()) {
            List list = binding.getExtensibilityElements();
            int length = list.size();
            for (int index = 0; index < length; ++index) {
                if (!(list.get(index) instanceof SOAPBindingImpl)) continue;
                int soapOperationCount = binding.getBindingOperations().size();
                for (int soapOpIndex = 0; soapOpIndex < soapOperationCount; ++soapOpIndex) {
                    BindingOperation bindingOp = (BindingOperation)binding.getBindingOperations().get(soapOpIndex);
                    Operation op = bindingOp.getOperation();
                    String soapAction = WSDLUtils.getSoapActionURI(bindingOp);
                    this.expandOperation(wsdlInvokerInternalObject, op, binding, soapAction);
                }
            }
        }
        jsonWriter.endArray();
        jsonOutput = wsdlInvokerInternalObject.getStrWriter().getBuffer().toString();
        return jsonOutput;
    }

    public String expandAllOperationsAndEntities(String endPoint, WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        if (wsdlInvokerInternalObject == null) {
            wsdlInvokerInternalObject = new WSDLInvokerInternalObject();
        }
        if (wsdlInvokerInternalObject.getParams() == null) {
            wsdlInvokerInternalObject.setParams(new WSDLInvokerParams());
        }
        String jsonOutput = null;
        this.setEndPoint(wsdlInvokerInternalObject, endPoint);
        this.parseSchemas(wsdlInvokerInternalObject);
        JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
        jsonWriter.object();
        jsonWriter.key("operations");
        jsonWriter.array();
        Map allBindings = wsdlInvokerInternalObject.getDefinition().getAllBindings();
        for (Binding binding : allBindings.values()) {
            List list = binding.getExtensibilityElements();
            int length = list.size();
            for (int index = 0; index < length; ++index) {
                if (!(list.get(index) instanceof SOAPBindingImpl)) continue;
                int soapOperationCount = binding.getBindingOperations().size();
                for (int soapOpIndex = 0; soapOpIndex < soapOperationCount; ++soapOpIndex) {
                    BindingOperation bindingOp = (BindingOperation)binding.getBindingOperations().get(soapOpIndex);
                    Operation op = bindingOp.getOperation();
                    String soapAction = WSDLUtils.getSoapActionURI(bindingOp);
                    this.expandOperation(wsdlInvokerInternalObject, op, binding, soapAction);
                }
            }
        }
        jsonWriter.endArray();
        jsonWriter.key("entities");
        this.getComplexTypes(wsdlInvokerInternalObject);
        jsonWriter.endObject();
        jsonOutput = wsdlInvokerInternalObject.getStrWriter().getBuffer().toString();
        return jsonOutput;
    }

    private void getComplexTypes(WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
        XSSchemaSet schemaSet = wsdlInvokerInternalObject.getmSchemaSet();
        jsonWriter.array();
        for (XSSchema xsSchema : schemaSet.getSchemas()) {
            Map types = xsSchema.getTypes();
            Set type = types.keySet();
            for (String key : type) {
                XSComplexType complexType;
                XSContentType contentType;
                XSSimpleType simpleType;
                XSType xstype = (XSType)types.get(key);
                if (!(xstype instanceof XSComplexType) || (simpleType = (contentType = (complexType = (XSComplexType)xstype).getContentType()).asSimpleType()) != null) continue;
                jsonWriter.object();
                jsonWriter.key("name").value((Object)xstype.getName());
                jsonWriter.key("namespace").value((Object)xstype.getTargetNamespace());
                jsonWriter.key("params");
                jsonWriter.array();
                Stack<String> elementNames = new Stack<String>();
                elementNames.push(xstype.getName());
                this.expandCompositeTypeElement(wsdlInvokerInternalObject, complexType, elementNames, false, false, 1, 1);
                jsonWriter.endArray();
                jsonWriter.endObject();
            }
        }
        jsonWriter.endArray();
    }

    private void createSOAPParam(SOAPElement inElement, Object object, Object parentAdditionalData, Boolean isParentJsonObject, String parentNamespace) throws Exception {
        try {
            Iterator keys = null;
            boolean isJsonObject = false;
            JSONObject jsonObject = null;
            LinkedHashMap linkedMap = null;
            if (this.isPrimitiveTypeValue(object)) {
                this.handlePrimitiveTypeValues(object, inElement, inElement);
            } else if (object instanceof JSONObject) {
                jsonObject = (JSONObject)object;
                keys = jsonObject.keys();
                isJsonObject = true;
            } else if (object instanceof LinkedHashMap) {
                linkedMap = (LinkedHashMap)object;
                keys = linkedMap.keySet().iterator();
            } else {
                throw new IllegalArgumentException("Error creating SOAP Params: Only JSON and LinkedHashMap allowed");
            }
            while (keys != null && keys.hasNext()) {
                int i;
                Object array;
                String paramName = (String)keys.next();
                Object value = this.getValue(isJsonObject, jsonObject, linkedMap, paramName, VALUE);
                Object fdmAdditionalData = this.getValue(isJsonObject, jsonObject, linkedMap, paramName, FDM_ADDITIONAL_DATA_KEY);
                String namespace = (String)this.getValue(isJsonObject, jsonObject, linkedMap, paramName, NAMESPACE);
                if (StringUtils.isNotEmpty((CharSequence)namespace) || this.isNameSpaceKeyPresent(isJsonObject, jsonObject, paramName).booleanValue()) {
                    parentNamespace = namespace;
                }
                SOAPElement innerElement = null;
                if (this.isPrimitiveTypeValue(value)) {
                    innerElement = inElement.addChildElement(paramName, "", parentNamespace);
                    this.handleChildAttributes(innerElement, parentAdditionalData, isParentJsonObject);
                    this.handlePrimitiveTypeValues(value, inElement, innerElement);
                    continue;
                }
                if (value instanceof JSONObject || value instanceof LinkedHashMap) {
                    namespace = this.getOverrideElementNamespace((Map)fdmAdditionalData, namespace);
                    paramName = this.getOverrideElementName((Map)fdmAdditionalData, paramName);
                    innerElement = inElement.addChildElement(paramName, "", namespace);
                    this.handleTypeAttribute(fdmAdditionalData, innerElement, isJsonObject);
                    this.handleElementAttribute(fdmAdditionalData, innerElement, isJsonObject);
                    this.createSOAPParam(innerElement, value, fdmAdditionalData, isJsonObject, namespace);
                    continue;
                }
                if (value instanceof JSONArray) {
                    array = (JSONArray)value;
                    for (i = 0; i < array.length(); ++i) {
                        innerElement = inElement.addChildElement(paramName, "", namespace);
                        this.handleElementAttribute(fdmAdditionalData, innerElement, isJsonObject);
                        this.createSOAPParam(innerElement, array.get(i), fdmAdditionalData, isJsonObject, namespace);
                    }
                    continue;
                }
                if (value instanceof List) {
                    array = (List)value;
                    for (i = 0; i < array.size(); ++i) {
                        Object listItem = array.get(i);
                        if (listItem instanceof Map) {
                            Map additionalData = (Map)((Map)listItem).get(FDM_ADDITIONAL_DATA_KEY);
                            namespace = this.getOverrideElementNamespace(additionalData, namespace);
                            paramName = this.getOverrideElementName(additionalData, paramName);
                            innerElement = inElement.addChildElement(paramName, "", namespace);
                            this.handleTypeAttribute(((Map)listItem).get(FDM_ADDITIONAL_DATA_KEY), innerElement, isJsonObject);
                            this.handleElementAttribute(additionalData, innerElement, isJsonObject);
                            ((Map)listItem).remove(FDM_ADDITIONAL_DATA_KEY);
                            fdmAdditionalData = additionalData;
                            isJsonObject = false;
                        } else {
                            innerElement = inElement.addChildElement(paramName, "", namespace);
                            this.handleChildAttributes(innerElement, parentAdditionalData, isParentJsonObject);
                        }
                        this.createSOAPParam(innerElement, array.get(i), fdmAdditionalData, isJsonObject, namespace);
                    }
                    continue;
                }
                throw new Exception("createSOAPParam: Invalid Params");
            }
        }
        catch (JSONException e) {
            throw new Exception("createSOAPParam: JSONException", e);
        }
    }

    private void handleChildAttributes(SOAPElement innerElement, Object fdmAdditionalData, Boolean isJsonObject) throws SOAPException, JSONException {
        Iterator keys = null;
        if (fdmAdditionalData != null && isJsonObject != null) {
            if (isJsonObject.booleanValue()) {
                if (((JSONObject)fdmAdditionalData).has(ATTRIBUTE_DATA_KEY) && ((JSONObject)((JSONObject)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).has(innerElement.getLocalName())) {
                    keys = ((JSONObject)((JSONObject)((JSONObject)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).get(innerElement.getLocalName())).keys();
                }
            } else if (((Map)fdmAdditionalData).containsKey(ATTRIBUTE_DATA_KEY) && ((Map)((Map)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).containsKey(innerElement.getLocalName())) {
                keys = ((Map)((Map)((Map)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).get(innerElement.getLocalName())).keySet().iterator();
            }
            while (keys != null && keys.hasNext()) {
                String attributeName = (String)keys.next();
                if (attributeName.equals("xmlns")) continue;
                Object attributeValue = null;
                attributeValue = isJsonObject != false ? ((JSONObject)((JSONObject)((JSONObject)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).get(innerElement.getLocalName())).get(attributeName) : ((Map)((Map)((Map)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).get(innerElement.getLocalName())).get(attributeName);
                if (!(attributeValue instanceof String)) continue;
                innerElement.addAttribute(QName.valueOf(attributeName), (String)attributeValue);
            }
        }
    }

    private void handleElementAttribute(Object fdmAdditionalData, SOAPElement innerElement, boolean isJsonObject) throws SOAPException, JSONException {
        Iterator keys = null;
        if (isJsonObject) {
            if (fdmAdditionalData != null && ((JSONObject)fdmAdditionalData).has(ATTRIBUTE_DATA_KEY)) {
                keys = ((JSONObject)((JSONObject)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).keys();
            }
        } else if (fdmAdditionalData != null && ((Map)fdmAdditionalData).containsKey(ATTRIBUTE_DATA_KEY)) {
            keys = ((Map)((Map)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).keySet().iterator();
        }
        while (keys != null && keys.hasNext()) {
            String attributeName = (String)keys.next();
            if (attributeName.equals("xmlns")) continue;
            Object attributeValue = null;
            attributeValue = isJsonObject ? ((JSONObject)((JSONObject)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).get(attributeName) : ((Map)((Map)fdmAdditionalData).get(ATTRIBUTE_DATA_KEY)).get(attributeName);
            if (!(attributeValue instanceof String)) continue;
            innerElement.addAttribute(QName.valueOf(attributeName), (String)attributeValue);
        }
    }

    private void handleTypeAttribute(Object fdmAdditionalData, SOAPElement innerElement, boolean isJsonObject) throws JSONException, SOAPException {
        if (fdmAdditionalData != null) {
            String typeNamespace;
            String elementName = isJsonObject ? ((JSONObject)fdmAdditionalData).getString(ELEMENT_NAME) : (String)((HashMap)fdmAdditionalData).get(ELEMENT_NAME);
            String type = isJsonObject ? ((JSONObject)fdmAdditionalData).getString(TYPE) : (String)((HashMap)fdmAdditionalData).get(TYPE);
            String string = typeNamespace = isJsonObject ? ((JSONObject)fdmAdditionalData).getString(SCHEMA) : (String)((HashMap)fdmAdditionalData).get(SCHEMA);
            if (typeNamespace != null && type != null && elementName == null) {
                QName xmlns = innerElement.createQName("typeNamespace", "xmlns");
                innerElement.addAttribute(xmlns, typeNamespace);
                innerElement.addAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "type"), "typeNamespace:" + type);
            }
        }
    }

    private String getOverrideElementName(Map fdmAdditionalData, String defaultParamName) {
        if (fdmAdditionalData != null && fdmAdditionalData.containsKey(ELEMENT_NAME)) {
            String newParamName = (String)fdmAdditionalData.get(ELEMENT_NAME);
            return newParamName;
        }
        return defaultParamName;
    }

    private String getOverrideElementNamespace(Map fdmAdditionalData, String defaultParamNamespace) {
        if (fdmAdditionalData != null && fdmAdditionalData.containsKey(ELEMENT_NAMESPACE)) {
            String newParamNamespace = (String)fdmAdditionalData.get(ELEMENT_NAMESPACE);
            return newParamNamespace;
        }
        return defaultParamNamespace;
    }

    private boolean isPrimitiveTypeValue(Object object) {
        return JSONObject.NULL.equals(object) || object instanceof String || object instanceof Number || object instanceof Boolean;
    }

    private boolean handlePrimitiveTypeValues(Object value, SOAPElement inElement, SOAPElement innerElement) throws SOAPException {
        if (JSONObject.NULL.equals(value)) {
            innerElement.addAttribute(new QName("http://www.w3.org/2001/XMLSchema-instance", "nil"), "true");
            return true;
        }
        if (value instanceof String) {
            String val = (String)value;
            innerElement.addTextNode(val);
            return true;
        }
        if (value instanceof Number) {
            Number val = (Number)value;
            innerElement.addTextNode(value.toString());
            return true;
        }
        if (value instanceof Boolean) {
            Boolean val = (Boolean)value;
            innerElement.addTextNode(Boolean.toString(val));
            return true;
        }
        return false;
    }

    private Object getValue(boolean isJsonObject, JSONObject jsonObject, Map map, String paramName, String dataKey) throws JSONException {
        if (isJsonObject) {
            if (jsonObject.get(paramName) instanceof JSONObject) {
                if (jsonObject.getJSONObject(paramName).has(dataKey)) {
                    return jsonObject.getJSONObject(paramName).get(dataKey);
                }
                return null;
            }
            return dataKey.equals(VALUE) ? jsonObject.get(paramName) : null;
        }
        return ((Map)map.get(paramName)).get(dataKey);
    }

    private Boolean isNameSpaceKeyPresent(boolean isJsonObject, JSONObject jsonObject, String paramName) throws JSONException {
        return isJsonObject && jsonObject.get(paramName) instanceof JSONObject && jsonObject.getJSONObject(paramName).has(NAMESPACE);
    }

    private void createSOAPMessage(WSDLInvokerInternalObject wsdlInvokerInternalObject, String operationName, String opSoapActionURI, String rootNamespace, Object inputObject) throws Exception {
        SOAPMessage soapMessage;
        try {
            MessageFactory messageFactory = MessageFactory.newInstance();
            soapMessage = messageFactory.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody soapBody = envelope.getBody();
            WSDLInvokerParams params = wsdlInvokerInternalObject.getParams();
            String inputRootParam = params.getOpInputRoot();
            String inputRoot = inputRootParam != null && !inputRootParam.isEmpty() ? inputRootParam : operationName;
            String bodyContentPrefix = "";
            boolean x509TokenSecurityProfileEnabled = X509TokenSecurityProfileHandler.isX509TokenSecurityProfileEnabled(wsdlInvokerInternalObject.getParams());
            if (x509TokenSecurityProfileEnabled && !StringUtils.isBlank((CharSequence)rootNamespace)) {
                bodyContentPrefix = WSDLUtils.generateUniqueNSPrefix();
            }
            SOAPElement soapBodyElem = soapBody.addChildElement(inputRoot, bodyContentPrefix, rootNamespace);
            this.addAttributesToRootNode(soapBodyElem, inputObject);
            this.createSOAPParam(soapBodyElem, inputObject, null, null, rootNamespace);
            MimeHeaders headers = soapMessage.getMimeHeaders();
            headers.addHeader("SOAPAction", opSoapActionURI);
            if (params != null) {
                List<SOAPElement> soapHeaders;
                Map<String, String> httpHeaders = params.getHttpHeaders();
                if (httpHeaders != null) {
                    this.createHTTPAuthenticationHeaders(headers, httpHeaders);
                }
                if ((soapHeaders = params.getSoapHeaders()) != null) {
                    this.createSOAPAuthenticationHeaders(soapMessage, envelope, soapHeaders);
                }
            }
            if (x509TokenSecurityProfileEnabled) {
                X509TokenSecurityProfileHandler.handleX509TokenProfileSecurity(wsdlInvokerInternalObject.getParams(), soapMessage);
            }
            soapMessage.saveChanges();
        }
        catch (SOAPException e) {
            throw new Exception("createSOAPMessage: SOAPException " + e.getMessage(), e);
        }
        catch (JSONException e) {
            throw new Exception("createSOAPMessage: JSONException", e);
        }
        if (this.log.isDebugEnabled()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                soapMessage.writeTo((OutputStream)out);
                String strSOAPMessage = new String(out.toByteArray());
                this.log.debug("SOAPMessage: " + strSOAPMessage);
            }
            catch (IOException e) {
                throw new Exception("createSOAPMessage: IOException", e);
            }
            catch (SOAPException e) {
                throw new Exception("createSOAPMessage: SOAPException", e);
            }
        }
        wsdlInvokerInternalObject.setMessage(soapMessage);
    }

    private void createHTTPAuthenticationHeaders(MimeHeaders headers, Map<String, String> authHeaders) {
        for (Map.Entry<String, String> entry : authHeaders.entrySet()) {
            headers.addHeader(entry.getKey(), entry.getValue());
        }
    }

    private void createSOAPAuthenticationHeaders(SOAPMessage soapMessage, SOAPEnvelope envelope, List<SOAPElement> headerElements) throws Exception {
        SOAPHeader header = soapMessage.getSOAPHeader();
        if (header == null) {
            header = envelope.addHeader();
        }
        for (SOAPElement element : headerElements) {
            header.addChildElement(element);
        }
    }

    private boolean hasRepeatedSibling(String elementName, Element sibling) {
        return sibling != null && elementName.equals(sibling.getNodeName());
    }

    private Node getNodeSibling(Node node, boolean isNext) {
        return isNext ? node.getNextSibling() : node.getPreviousSibling();
    }

    private Element getElementSibling(Node node, boolean isNext) {
        Element element = null;
        Node sibling = this.getNodeSibling(node, isNext);
        while (sibling != null && !(sibling instanceof Element)) {
            sibling = this.getNodeSibling(sibling, isNext);
        }
        if (sibling != null && sibling instanceof Element) {
            element = (Element)sibling;
        }
        return element;
    }

    private void convertElementToJSON(WSDLInvokerInternalObject wsdlInvokerInternalObject, Element element, HashMap<String, String> prefixToNamespace) throws Exception {
        Map<String, String> attributeMap;
        Element prevSibling = this.getElementSibling(element, false);
        Element nextSibling = this.getElementSibling(element, true);
        if (element.hasChildNodes()) {
            Node child;
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            String keyName = element.getNodeName();
            String trimmedKeyName = keyName.contains(":") ? keyName.substring(keyName.indexOf(":") + 1) : keyName;
            if (!this.hasRepeatedSibling(keyName, prevSibling)) {
                jsonWriter.key(trimmedKeyName);
            }
            if (!((child = element.getFirstChild()) instanceof Element)) {
                child = this.getElementSibling(child, true);
            }
            if (!this.hasRepeatedSibling(keyName, prevSibling) && this.hasRepeatedSibling(keyName, nextSibling)) {
                jsonWriter.array();
            }
            if (child != null) {
                Map<String, String> attributeMap2;
                boolean fdmAdditionalDataBeacon = false;
                boolean attributeDataBeacon = false;
                jsonWriter.object();
                this.processElementPrefixNamespace(element, prefixToNamespace);
                Attr typeAttribute = element.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                if (typeAttribute != null) {
                    fdmAdditionalDataBeacon = true;
                    jsonWriter.key(FDM_ADDITIONAL_DATA_KEY);
                    jsonWriter.object();
                    String typeAttributeValue = typeAttribute.getValue();
                    jsonWriter.key(TYPE).value((Object)typeAttributeValue.substring(typeAttributeValue.indexOf(":") + 1));
                    String nameSpaceAlias = typeAttributeValue.substring(0, typeAttributeValue.indexOf(":"));
                    jsonWriter.key(SCHEMA).value((Object)prefixToNamespace.get(nameSpaceAlias));
                }
                if ((attributeMap2 = this.getElementAttributes(element)).size() > 0) {
                    if (typeAttribute == null) {
                        fdmAdditionalDataBeacon = true;
                        jsonWriter.key(FDM_ADDITIONAL_DATA_KEY);
                        jsonWriter.object();
                    }
                    jsonWriter.key(ATTRIBUTE_DATA_KEY);
                    jsonWriter.object();
                    attributeDataBeacon = true;
                    for (Map.Entry<String, String> attribute : attributeMap2.entrySet()) {
                        jsonWriter.key(attribute.getKey()).value((Object)attribute.getValue());
                    }
                }
                boolean childAttributesIndicator = this.addAttributesForPrimitiveChildElements(element, fdmAdditionalDataBeacon, attributeDataBeacon, jsonWriter);
                if (attributeDataBeacon || childAttributesIndicator) {
                    jsonWriter.endObject();
                }
                if (fdmAdditionalDataBeacon || attributeDataBeacon || childAttributesIndicator) {
                    jsonWriter.endObject();
                }
                this.convertElementToJSON(wsdlInvokerInternalObject, (Element)child, prefixToNamespace);
                jsonWriter.endObject();
            } else {
                jsonWriter.value((Object)element.getTextContent());
            }
            if (this.hasRepeatedSibling(keyName, prevSibling) && !this.hasRepeatedSibling(keyName, nextSibling)) {
                jsonWriter.endArray();
            }
        } else if (!element.hasChildNodes() && element.hasAttributes() && (attributeMap = this.getElementAttributes(element)).size() > 0) {
            JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
            String keyName = element.getNodeName();
            String trimmedKeyName = keyName.contains(":") ? keyName.substring(keyName.indexOf(":") + 1) : keyName;
            jsonWriter.key(trimmedKeyName);
            jsonWriter.object();
            jsonWriter.key(FDM_ADDITIONAL_DATA_KEY);
            jsonWriter.object();
            jsonWriter.key(ATTRIBUTE_DATA_KEY);
            jsonWriter.object();
            for (Map.Entry<String, String> attribute : attributeMap.entrySet()) {
                jsonWriter.key(attribute.getKey()).value((Object)attribute.getValue());
            }
            jsonWriter.endObject();
            jsonWriter.endObject();
            jsonWriter.endObject();
        }
        if (nextSibling != null) {
            this.convertElementToJSON(wsdlInvokerInternalObject, nextSibling, prefixToNamespace);
        }
    }

    private boolean addAttributesForPrimitiveChildElements(Element element, boolean fdmAdditionalDataBeacon, boolean attributeDataBeacon, JSONWriter jsonWriter) throws JSONException {
        boolean indicator = false;
        try {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Map<String, String> innerAttributeMap;
                Node nodeItem = children.item(i);
                if (!this.isTextNode(nodeItem) || (innerAttributeMap = this.getElementAttributes((Element)nodeItem)).size() <= 0) continue;
                indicator = true;
                if (!fdmAdditionalDataBeacon) {
                    jsonWriter.key(FDM_ADDITIONAL_DATA_KEY);
                    jsonWriter.object();
                }
                if (!attributeDataBeacon) {
                    jsonWriter.key(ATTRIBUTE_DATA_KEY);
                    jsonWriter.object();
                }
                jsonWriter.key(nodeItem.getLocalName());
                jsonWriter.object();
                for (Map.Entry<String, String> innerAttribute : innerAttributeMap.entrySet()) {
                    jsonWriter.key(innerAttribute.getKey()).value((Object)innerAttribute.getValue());
                }
                jsonWriter.endObject();
            }
        }
        catch (Exception e) {
            this.log.error("Error occurred while adding attributes for child nodes in parent : " + e.getStackTrace());
        }
        return indicator;
    }

    private boolean isTextNode(Node nodeItem) {
        boolean textNodeFlag = false;
        if (nodeItem instanceof Element && nodeItem.hasChildNodes()) {
            Node current = nodeItem.getFirstChild();
            if (!(current instanceof Element)) {
                current = this.getElementSibling(current, true);
            }
            if (current == null) {
                textNodeFlag = true;
            }
        }
        return textNodeFlag;
    }

    private void processElementPrefixNamespace(Element element, HashMap<String, String> prefixToNamespace) {
        NamedNodeMap attribNodeMap = element.getAttributes();
        for (int i = 0; i < attribNodeMap.getLength(); ++i) {
            Node node = attribNodeMap.item(i);
            prefixToNamespace.put(node.getLocalName(), node.getNodeValue());
        }
    }

    private String convertSOAPMessageToJSON(WSDLInvokerInternalObject wsdlInvokerInternalObject, SOAPMessage message) throws Exception {
        boolean isError = false;
        SOAPPart part = message.getSOAPPart();
        SOAPEnvelope envelope = part.getEnvelope();
        HashMap<String, String> prefixToNamespace = new HashMap<String, String>();
        this.processElementPrefixNamespace((Element)envelope, prefixToNamespace);
        SOAPBody body = envelope.getBody();
        Iterator allElements = body.getChildElements();
        JSONWriter jsonWriter = wsdlInvokerInternalObject.getJsonWriter();
        jsonWriter.object();
        while (allElements.hasNext()) {
            Object item = allElements.next();
            if (!(item instanceof Element)) continue;
            if (item instanceof SOAPFault) {
                isError = true;
            }
            this.convertElementToJSON(wsdlInvokerInternalObject, (Element)item, prefixToNamespace);
        }
        jsonWriter.endObject();
        String jsonStream = wsdlInvokerInternalObject.getStrWriter().getBuffer().toString();
        if (isError) {
            throw new Exception(jsonStream);
        }
        return jsonStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WSDLResponse executeOperationInternal(WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        boolean isHttps;
        SOAPMessage soapMessage = wsdlInvokerInternalObject.getMessage();
        String wsdlEndPoint = wsdlInvokerInternalObject.getEndPoint();
        String serviceEndPoint = wsdlInvokerInternalObject.getParams().getServiceEndPoint();
        if (soapMessage == null || wsdlEndPoint == null || wsdlEndPoint.isEmpty()) {
            throw new Exception("executeOperationInternal: Need a valid soap message and web service endpoint");
        }
        if (this.soapConnectionFactory == null) {
            this.soapConnectionFactory = SOAPConnectionFactory.newInstance();
        }
        if ((isHttps = serviceEndPoint.toLowerCase().startsWith("https")) && this.keyStoreService != null && this.resourceResolverFactory != null && this.isMutualSSLAuthentication(wsdlInvokerInternalObject)) {
            String mutualSSLKeyAlias = this.getMutualSSLKeyAlias(wsdlInvokerInternalObject);
            SSLContext sslContext = SSLUtils.getSSLContext(this.resourceResolverFactory, "readCloudService", "sslFDM", this.keyStoreService, this.keyStoreService, mutualSSLKeyAlias);
            HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        }
        String jsonOutput = null;
        SOAPMessage soapResponse = null;
        try (SOAPConnection soapConnection = null;){
            soapConnection = this.soapConnectionFactory.createConnection();
            soapResponse = soapConnection.call(soapMessage, (Object)serviceEndPoint);
            jsonOutput = this.convertSOAPMessageToJSON(wsdlInvokerInternalObject, soapResponse);
            if (this.log.isTraceEnabled()) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                Source sourceContent = soapResponse.getSOAPPart().getContent();
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                transformer.transform(sourceContent, result);
                String strMessage = writer.getBuffer().toString();
                this.log.trace("soapResponse: " + strMessage);
            }
        }
        WSDLResponse wsdlResponse = new WSDLResponse(soapResponse, jsonOutput);
        return wsdlResponse;
    }

    private boolean getPortIfRequired(WSDLInvokerInternalObject wsdlInvokerInternalObject, String operation) throws Exception {
        String port = wsdlInvokerInternalObject.getParams().getPort();
        if (port == null || port.isEmpty()) {
            port = WSDLUtils.getPortIfUnique(wsdlInvokerInternalObject.getDefinition(), operation);
        }
        boolean result = false;
        if (port != null && !port.isEmpty()) {
            result = true;
        }
        wsdlInvokerInternalObject.getParams().setPort(port);
        return result;
    }

    public String executeOperation(WSDLInvokerInternalObject wsdlInvokerInternalObject, String serverEndPoint, String operation, String jsonInput) throws Exception {
        if (wsdlInvokerInternalObject == null) {
            wsdlInvokerInternalObject = new WSDLInvokerInternalObject();
        }
        this.prepareExecutionContext(wsdlInvokerInternalObject, serverEndPoint, operation);
        this.createSOAPMessage(wsdlInvokerInternalObject, operation, wsdlInvokerInternalObject.getParams().getOpSoapUri(), wsdlInvokerInternalObject.getParams().getNamespace(), new JSONObject(jsonInput));
        WSDLResponse wsdlResponse = this.executeOperationInternal(wsdlInvokerInternalObject);
        return wsdlResponse.getConvertedJsonMessage();
    }

    public String executeOperation(WSDLInvokerInternalObject wsdlInvokerInternalObject, String serverEndPoint, String operation, LinkedHashMap<String, Object> argumentInput) throws Exception {
        wsdlInvokerInternalObject = this.prepareWsdlInvokerInternalObject(wsdlInvokerInternalObject, serverEndPoint, operation, argumentInput);
        WSDLResponse wsdlResponse = this.executeOperationInternal(wsdlInvokerInternalObject);
        return wsdlResponse.getConvertedJsonMessage();
    }

    public WSDLResponse executeOperationForSoapResponse(WSDLInvokerInternalObject wsdlInvokerInternalObject, String serverEndPoint, String operation, LinkedHashMap<String, Object> argumentInput) throws Exception {
        wsdlInvokerInternalObject = this.prepareWsdlInvokerInternalObject(wsdlInvokerInternalObject, serverEndPoint, operation, argumentInput);
        WSDLResponse wsdlResponse = this.executeOperationInternal(wsdlInvokerInternalObject);
        return wsdlResponse;
    }

    private WSDLInvokerInternalObject prepareWsdlInvokerInternalObject(WSDLInvokerInternalObject wsdlInvokerInternalObject, String serverEndPoint, String operation, LinkedHashMap<String, Object> argumentInput) throws Exception {
        if (wsdlInvokerInternalObject == null) {
            wsdlInvokerInternalObject = new WSDLInvokerInternalObject();
        }
        this.prepareExecutionContext(wsdlInvokerInternalObject, serverEndPoint, operation);
        this.createSOAPMessage(wsdlInvokerInternalObject, operation, wsdlInvokerInternalObject.getParams().getOpSoapUri(), wsdlInvokerInternalObject.getParams().getNamespace(), argumentInput);
        return wsdlInvokerInternalObject;
    }

    private void prepareExecutionContext(WSDLInvokerInternalObject wsdlInvokerInternalObject, String serverEndPoint, String operation) throws Exception {
        if (wsdlInvokerInternalObject.getParams() == null) {
            wsdlInvokerInternalObject.setParams(new WSDLInvokerParams());
        }
        Object jsonOutput = null;
        try {
            String namespace;
            String serviceEndPoint;
            this.setEndPoint(wsdlInvokerInternalObject, serverEndPoint);
            String soapActionUri = wsdlInvokerInternalObject.getParams().getOpSoapUri();
            if (soapActionUri == null || soapActionUri.isEmpty()) {
                this.parseSchemas(wsdlInvokerInternalObject);
                if (!this.getPortIfRequired(wsdlInvokerInternalObject, operation)) {
                    throw new Exception("Invalid arguments: Either of soapActionUri or port is required");
                }
                WSDLUtils.getSoapActionURI(wsdlInvokerInternalObject.getDefinition(), wsdlInvokerInternalObject.getParams(), operation);
            }
            if ((serviceEndPoint = wsdlInvokerInternalObject.getParams().getServiceEndPoint()) == null || serviceEndPoint.isEmpty()) {
                this.parseSchemas(wsdlInvokerInternalObject);
                if (!this.getPortIfRequired(wsdlInvokerInternalObject, operation)) {
                    throw new Exception("Invalid arguments: Either of serviceEndPoint or port is required");
                }
                serviceEndPoint = WSDLUtils.getServiceEndPointFromPort(wsdlInvokerInternalObject.getDefinition(), wsdlInvokerInternalObject.getParams().getPort());
                wsdlInvokerInternalObject.getParams().setServiceEndPoint(serviceEndPoint);
            }
            if ((namespace = wsdlInvokerInternalObject.getParams().getNamespace()) == null || namespace.isEmpty()) {
                this.parseSchemas(wsdlInvokerInternalObject);
                if (!this.getPortIfRequired(wsdlInvokerInternalObject, operation)) {
                    throw new Exception("Invalid arguments: Either of soapActionUri or port is required");
                }
                namespace = WSDLUtils.getOperationNamespace(wsdlInvokerInternalObject.getDefinition(), wsdlInvokerInternalObject.getmSchemaSet(), wsdlInvokerInternalObject.getParams().getPort(), operation);
                wsdlInvokerInternalObject.getParams().setNamespace(namespace);
            }
        }
        catch (SOAPException e) {
            throw new Exception("executeOperation: SOAPException " + e.getMessage(), e);
        }
        catch (TransformerConfigurationException e) {
            throw new Exception("executeOperation: TransformerConfigurationException " + e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new Exception("executeOperation: TransformerException " + e.getMessage(), e);
        }
    }

    private void expandCompositeTypeElement(WSDLInvokerInternalObject wsdlInvokerInternalObject, XSComplexType complexType, Stack<String> elementNameChain, boolean isNillable, boolean isRepeated, int minOccurs, int maxOccurs) throws Exception {
        XSContentType content = complexType.getContentType();
        XSParticle xsParticle = content.asParticle();
        if (xsParticle != null) {
            XSTerm term = xsParticle.getTerm();
            if (term.isModelGroup()) {
                XSModelGroup modelGroup = term.asModelGroup();
                this.groupProcessing(wsdlInvokerInternalObject, modelGroup, elementNameChain);
            }
        } else if (content.asEmpty() == null) {
            throw new Exception("Unable to handle content type for " + complexType.getTargetNamespace() + ":" + complexType.getName());
        }
    }

    private List<Object> getEnumerationFacetValue(XSRestrictionSimpleType restrictions) {
        List allFacets = restrictions.getFacets("enumeration");
        ArrayList<String> allEnums = null;
        if (allFacets.size() > 0) {
            allEnums = new ArrayList<String>();
            for (int index = 0; index < allFacets.size(); ++index) {
                XSFacet facet = (XSFacet)allFacets.get(index);
                allEnums.add(facet.getValue().toString());
            }
        }
        return allEnums;
    }

    private Map<String, String> getElementAttributes(Element element) {
        NamedNodeMap attributes;
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        if (element != null && (attributes = element.getAttributes()) != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node node = attributes.item(i);
                if (node.getNodeName().equals("xmlns")) continue;
                attributeMap.put(node.getNodeName(), node.getNodeValue());
            }
        }
        return attributeMap;
    }

    private void addAttributesToRootNode(SOAPElement rootElement, Object inputObject) {
        try {
            Object fdmAdditionalData = null;
            boolean isJsonObject = false;
            JSONObject jsonObject = null;
            LinkedHashMap linkedMap = null;
            if (inputObject instanceof JSONObject) {
                jsonObject = (JSONObject)inputObject;
                isJsonObject = true;
            } else if (inputObject instanceof LinkedHashMap) {
                linkedMap = (LinkedHashMap)inputObject;
            }
            if (isJsonObject) {
                if (jsonObject.has(FDM_ADDITIONAL_DATA_KEY)) {
                    fdmAdditionalData = jsonObject.get(FDM_ADDITIONAL_DATA_KEY);
                    jsonObject.remove(FDM_ADDITIONAL_DATA_KEY);
                }
            } else {
                fdmAdditionalData = linkedMap.get(FDM_ADDITIONAL_DATA_KEY);
                linkedMap.remove(FDM_ADDITIONAL_DATA_KEY);
            }
            if (fdmAdditionalData != null) {
                this.handleElementAttribute(fdmAdditionalData, rootElement, isJsonObject);
            }
        }
        catch (Exception e) {
            this.log.error("Exception occurred while adding attributes to root node : " + e.getStackTrace());
        }
    }

    public Map<String, List<SubstitutionGroupBean>> getAllSubstitutionGroups(WSDLInvokerInternalObject wsdlInvokerInternalObject) throws Exception {
        if (wsdlInvokerInternalObject.getmSchemaSet() == null) {
            this.parseSchemas(wsdlInvokerInternalObject);
        }
        Map<String, List<SubstitutionGroupBean>> substitutionGroupMap = this.parseSchemasForSubstitutionGroup(wsdlInvokerInternalObject);
        return substitutionGroupMap;
    }

    private Map<String, List<SubstitutionGroupBean>> parseSchemasForSubstitutionGroup(WSDLInvokerInternalObject wsdlInvokerInternalObject) {
        HashMap<String, List<SubstitutionGroupBean>> substitutionMap = new HashMap<String, List<SubstitutionGroupBean>>();
        try {
            XSSchemaSet schemaSet = wsdlInvokerInternalObject.getmSchemaSet();
            for (XSSchema xsSchema : schemaSet.getSchemas()) {
                Map elemDecls = xsSchema.getElementDecls();
                for (Map.Entry entry : elemDecls.entrySet()) {
                    List<SubstitutionGroupBean> substitutionGroupBeans;
                    XSElementDecl element = (XSElementDecl)entry.getValue();
                    if (element.getSubstitutables() == null || element.getSubstitutables().size() <= 1) continue;
                    Iterator iterator = element.getSubstitutables().iterator();
                    ArrayList<SubstitutionGroupBean> substitutionGroup = new ArrayList<SubstitutionGroupBean>();
                    while (iterator.hasNext()) {
                        ElementDecl substitutedElement = (ElementDecl)iterator.next();
                        if (element.getName().equals(substitutedElement.getName())) continue;
                        SubstitutionGroupBean substitutedElementBean = new SubstitutionGroupBean();
                        substitutedElementBean.setElementName(substitutedElement.getName());
                        substitutedElementBean.setElementNamespace(substitutedElement.getTargetNamespace());
                        substitutedElementBean.setElementType(substitutedElement.getType().getName());
                        substitutedElementBean.setElementTypeNamespace(substitutedElement.getType().getTargetNamespace());
                        substitutionGroup.add(substitutedElementBean);
                    }
                    SubstitutionGroupBean headSubstituteElement = new SubstitutionGroupBean();
                    headSubstituteElement.setHeadElementName(element.getName());
                    headSubstituteElement.setHeadNamespace(element.getTargetNamespace());
                    headSubstituteElement.setFungibleElements(substitutionGroup);
                    if (substitutionMap.containsKey(element.getName())) {
                        substitutionGroupBeans = (List)substitutionMap.get(element.getName());
                        substitutionGroupBeans.add(headSubstituteElement);
                        substitutionMap.replace(element.getName(), substitutionGroupBeans);
                        continue;
                    }
                    substitutionGroupBeans = new ArrayList<SubstitutionGroupBean>();
                    substitutionGroupBeans.add(headSubstituteElement);
                    substitutionMap.put(element.getName(), substitutionGroupBeans);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Exception occurred while building substitution group map : " + e.getStackTrace());
        }
        return substitutionMap;
    }

    private String getMutualSSLKeyAlias(WSDLInvokerInternalObject wsdlInvokerInternalObject) {
        return wsdlInvokerInternalObject.getParams() != null ? wsdlInvokerInternalObject.getParams().getMutualSSLKeyAlias() : null;
    }

    private boolean isMutualSSLAuthentication(WSDLInvokerInternalObject wsdlInvokerInternalObject) {
        return wsdlInvokerInternalObject.getParams() != null ? wsdlInvokerInternalObject.getParams().isMutualSSL() : false;
    }

    private class DOMErrorHandler
    implements ErrorHandler {
        private DOMErrorHandler() {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            boolean dummy = false;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            boolean dummy = false;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            boolean dummy = false;
        }
    }
}

