/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.obj;

import com.adobe.fd.content.fdinternal.util.ContentAssetUtil;
import com.adobe.icc.dbforms.obj.DataModule;
import com.adobe.livecycle.content.model.annotation.Field;
import com.adobe.livecycle.content.model.annotation.Node;
import java.util.Date;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

@Node(external=true)
@XmlType
public class DAMImage
extends DataModule {
    private static final long serialVersionUID = -6449953119957996448L;
    @Field(id=true, optional=false)
    protected String id;
    @Field(shortlived=true)
    private String name;
    @Field(jcrPropertyName="jcr:content/metadata/dam:Fileformat")
    private String fileFormat;
    @Field(jcrPropertyName="jcr:content/metadata/dam:MIMEtype")
    private String mimeType;
    @Field(jcrPropertyName="jcr:content/metadata/dam:size")
    private long size;
    @Field(jcrPropertyName="jcr:content/jcr:lastModified")
    private Date lastUpdateDate;
    @Field(jcrPropertyName="jcr:content/metadata/tiff:ImageWidth")
    private long width;
    @Field(jcrPropertyName="jcr:content/metadata/tiff:ImageLength")
    private long height;
    @Field(jcrPropertyName="jcr:content/renditions/original/jcr:content/jcr:data")
    private byte[] imageBlob;
    @Field(jcrPropertyName="jcr:content/metadata/dc:title")
    private String[] dcTitle;
    @Field(jcrPropertyName="jcr:content/metadata/cq:tags")
    private String[] tags;
    @Field(jcrPropertyName="jcr:content/cq:lastReplicated")
    private Date lastPublishDate;
    @Field(jcrPropertyName="jcr:content/cq:lastReplicationAction")
    private String lastReplicationAction;
    @Field(jcrPropertyName="jcr:content/metadata/dc:description")
    private String desc;
    @Field(jcrPropertyName="jcr:content/jcr:lastModifiedBy")
    private String lastChangeBy;
    @Field(jcrPropertyName="jcr:content/metadata/dc:format")
    private String dcFormat;

    public DAMImage() {
    }

    public DAMImage(String fileFormat, String mimeType, long size, Date lastModified) {
        this.fileFormat = fileFormat;
        this.mimeType = mimeType;
        this.size = size;
        this.lastUpdateDate = lastModified;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return ContentAssetUtil.getNameFromId((String)this.id);
    }

    @Override
    public void setName(String name) {
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getWidth() {
        return this.width;
    }

    public void setWidth(long width) {
        this.width = width;
    }

    public long getHeight() {
        return this.height;
    }

    public void setHeight(long height) {
        this.height = height;
    }

    @Override
    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    @Override
    public void setLastUpdateDate(Date lastModified) {
        this.lastUpdateDate = lastModified;
    }

    public void setImageBlob(byte[] imageBlob) {
        this.imageBlob = imageBlob;
    }

    @XmlTransient
    public byte[] getImageBlob() {
        return this.imageBlob != null ? (Base64.isBase64((byte[])this.imageBlob) ? this.imageBlob : Base64.encodeBase64((byte[])this.imageBlob)) : this.imageBlob;
    }

    @Override
    public int getState() {
        return ContentAssetUtil.getState((Date)this.lastPublishDate, (Date)this.lastUpdateDate, (String)this.lastReplicationAction);
    }

    @Override
    public void setState(int state) {
    }

    @Override
    public String[] getTags() {
        return this.tags;
    }

    @Override
    public void setTags(String[] tags) {
        this.tags = tags;
    }

    @Override
    public Date getLastPublishDate() {
        return this.lastPublishDate;
    }

    @Override
    public void setLastPublishDate(Date lastPublishDate) {
        this.lastPublishDate = lastPublishDate;
    }

    @Override
    public String getLastReplicationAction() {
        return this.lastReplicationAction;
    }

    @Override
    public void setLastReplicationAction(String lastReplicationAction) {
        this.lastReplicationAction = lastReplicationAction;
    }

    public void setDcTitle(String[] dcTitle) {
        this.dcTitle = dcTitle;
    }

    public String[] getDcTitle() {
        return this.dcTitle;
    }

    public void setDcFormat(String dcFormat) {
        this.dcFormat = dcFormat;
    }

    public String getDcFormat() {
        return this.dcFormat;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public void setDesc(String desc) {
        this.desc = desc;
    }

    @Override
    public String getLastChangeBy() {
        return this.lastChangeBy;
    }

    @Override
    public void setLastChangeBy(String lastChangeBy) {
        this.lastChangeBy = lastChangeBy;
    }

    @Override
    public String getTitle() {
        String imageTitle = null;
        if (this.dcTitle != null && this.dcTitle.length > 0) {
            imageTitle = StringUtils.join((Object[])this.dcTitle, (String)", ");
        }
        return imageTitle;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DAMImage other = (DAMImage)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

