/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pdfg.exception;

import com.adobe.pdfg.exception.PDFGBaseException;
import com.adobe.pdfg.logging.ErrorCodeConversion;
import com.adobe.pdfg.logging.PDFGLogger;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;

public class PDFGError
implements Serializable {
    private static final long serialVersionUID = 98763679809891L;
    private static final String GenericExceptionMessage = "An Exception Occured";
    private static PDFGLogger pdfgLogger = PDFGLogger.getPDFGLogger(PDFGError.class);
    protected static String m_componentUID = "PDG";
    private int errorCode;
    private Object[] params = null;
    private String causingExceptionMessage = null;
    private String errorMessage = null;
    private PDFGBaseException fallbackConverterException = null;
    private int CODE_PRIMARYCONVERTER_MSG = 80028;
    private int CODE_FALLBACKCONVERTER_MSG = 80029;
    private transient String message;
    private static final transient Object[] EMPTY_ARGS = new Object[0];
    private static Properties errorMsgs = new Properties();

    public PDFGError(int errorCode, Throwable cause) {
        String msg;
        this.errorCode = errorCode;
        this.causingExceptionMessage = cause != null ? ((msg = cause.getLocalizedMessage()) != null ? cause.getLocalizedMessage() : "") : "";
    }

    public PDFGError(int errorCode) {
        this.errorCode = errorCode;
    }

    public PDFGError(int errorCode, Object message) {
        this.errorCode = errorCode;
        this.params = new Object[]{message};
    }

    public PDFGError(int errorCode, Object arg1, Object arg2) {
        this.errorCode = errorCode;
        this.params = new Object[]{arg1, arg2};
    }

    public PDFGError(int errorCode, Object[] params) {
        this.params = params;
        this.errorCode = errorCode;
    }

    public void setFallbackConverterException(PDFGBaseException fallbackConverterException) {
        this.fallbackConverterException = fallbackConverterException;
    }

    public String getComponentUID() {
        return m_componentUID;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getLocalizedMessage(locale.toString());
    }

    public String getLocalizedMessage(String localeName) {
        if (this.fallbackConverterException == null) {
            return this.getLocalizedMessageInternal(localeName);
        }
        String mainMsg = this.getLocalizedMessageInternal(localeName);
        String fallbackMsg = this.fallbackConverterException.getLocalizedMessage();
        String primaryStr = ErrorCodeConversion.getErrorString(this.CODE_PRIMARYCONVERTER_MSG, localeName);
        String fallbackStr = ErrorCodeConversion.getErrorString(this.CODE_FALLBACKCONVERTER_MSG, localeName);
        return "\n\n" + primaryStr + "\n" + mainMsg + "\n\n" + fallbackStr + "\n" + fallbackMsg;
    }

    private String getLocalizedMessageInternal(String localeName) {
        String errorMsg = null;
        if (errorMsg == null) {
            errorMsg = ErrorCodeConversion.getErrorString(this.errorCode, localeName);
        }
        if (this.params != null && this.params.length > 0) {
            if (errorMsg == null && this.params[0] != null) {
                errorMsg = this.params[0].toString();
            }
            try {
                errorMsg = MessageFormat.format(errorMsg, this.params);
            }
            catch (Exception e) {
                pdfgLogger.trace(e.getMessage(), null, e);
            }
        }
        if (errorMsg == null) {
            errorMsg = ErrorCodeConversion.getErrorString(1000, localeName);
        }
        if (this.causingExceptionMessage != null) {
            errorMsg = errorMsg + "\n" + this.causingExceptionMessage;
        }
        String errorCodeStr = "000" + this.errorCode + "";
        String moduleCodeStr = "0000" + this.errorCode + "";
        errorCodeStr = errorCodeStr.substring(errorCodeStr.length() - 3);
        int moduleCodeStrLen = moduleCodeStr.length();
        if (moduleCodeStrLen >= 6) {
            moduleCodeStr = moduleCodeStr.substring(moduleCodeStrLen - 6, moduleCodeStrLen - 3);
        }
        return "ALC-PDG-" + moduleCodeStr + "-" + errorCodeStr + "-" + errorMsg;
    }

    public String getMessage() {
        return this.getLocalizedMessage();
    }

    public String toString() {
        return super.toString();
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    static {
        try {
            InputStream is = PDFGError.class.getResourceAsStream("PDGErrorMsgs.properties");
            errorMsgs.load(is);
            is.close();
        }
        catch (Exception e) {
            pdfgLogger.debug(e.getMessage(), null, e);
        }
    }
}

