/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.util;

import com.adobe.aem.dermis.api.bridge.DataContext;
import com.adobe.aem.dermis.api.util.Assert;
import com.adobe.aem.dermis.api.util.ConfigurationResourceWrapper;
import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.DataSource;
import com.adobe.aem.dermis.model.IDataModel;
import com.adobe.aem.dermis.model.IProperty;
import com.adobe.aem.dermis.model.ITypeAsset;
import com.adobe.aem.dermis.model.PropertyFormatType;
import com.adobe.aem.dermis.model.PropertyType;
import com.adobe.aem.dermis.model.value.IValue;
import com.adobe.aem.dermis.model.value.IValueMap;
import com.adobe.aem.dermis.model.value.TypeValue;
import com.adobe.aem.dermis.slingmodel.Attribute;
import com.adobe.aem.dermis.slingmodel.Entity;
import com.adobe.aem.dermis.slingmodel.FormDataModel;
import com.adobe.aem.dermis.slingmodel.SourceDefinitionModel;
import com.adobe.aem.dermis.util.DermisConstants;
import com.adobe.aem.dermis.util.ValueUtil;
import com.adobe.aemfd.dermis.authentication.model.Configuration;
import com.adobe.cq.cloudconfig.core.Constants;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.caconfig.ConfigurationResolver;
import org.apache.sling.caconfig.resource.ConfigurationResourceResolver;

public class DermisUtils {
    public static Class getJavaClassForTypeAndFormat(PropertyType propertyType, PropertyFormatType formatType) {
        Class type = null;
        if (formatType != null) {
            type = formatType.getClassType();
        } else if (propertyType != null) {
            type = propertyType.getClassType();
        }
        return type;
    }

    public static <T> Class<? extends T[]> getArrayClass(Class<T> clazz) {
        Class<?> result = null;
        if (clazz != null) {
            result = Array.newInstance(clazz, 0).getClass();
        }
        return result;
    }

    public static DataSource getDataSourceFromSource(String sourceId, List<SourceDefinitionModel> sources) throws DermisException {
        SourceDefinitionModel source = DermisUtils.getSourceDefinition(sourceId, sources);
        if (source == null || source.getDataSource() == null) {
            throw new DermisException("AEM-FDM-001-018", new String[]{sourceId});
        }
        return source.getDataSource();
    }

    public static Resource getFormDataModelAssetResource(ResourceResolverFactory resolverFactory, String formDataModelAssetPath) throws DermisException {
        Resource formDataModelResource = null;
        if (resolverFactory != null) {
            ResourceResolver resourceResolver = DermisUtils.getFnDServiceUserResourceResolver(resolverFactory, "readFDM");
            formDataModelResource = resourceResolver.getResource(formDataModelAssetPath);
        }
        return formDataModelResource;
    }

    public static String getConfigurationFromSource(String sourceId, List<SourceDefinitionModel> sources) throws DermisException {
        SourceDefinitionModel source = DermisUtils.getSourceDefinition(sourceId, sources);
        if (source == null || StringUtils.isBlank((CharSequence)source.getConfigurationPath())) {
            throw new DermisException("AEM-FDM-001-018", new String[]{sourceId});
        }
        return source.getConfigurationPath();
    }

    private static SourceDefinitionModel getSourceDefinition(String source, List<SourceDefinitionModel> sources) throws DermisException {
        SourceDefinitionModel result = null;
        Assert.assertNotNull((String)source, (String)"AEM-FDM-001-019");
        Assert.assertNotNull(sources, (String)"AEM-FDM-001-009");
        if (sources != null && sources != null) {
            for (SourceDefinitionModel sourceDefinitionModel : sources) {
                if (sourceDefinitionModel == null || !source.equals(sourceDefinitionModel.getId())) continue;
                result = sourceDefinitionModel;
            }
        }
        return result;
    }

    public static ResourceResolver getFnDServiceUserResourceResolver(ResourceResolverFactory resourceResolverFactory, String subServiceName) throws DermisException {
        ResourceResolver resourceResolver = null;
        if (resourceResolverFactory != null) {
            try {
                HashMap<String, String> authenticationInfo = new HashMap<String, String>();
                authenticationInfo.put("sling.service.subservice", subServiceName);
                resourceResolver = resourceResolverFactory.getServiceResourceResolver(authenticationInfo);
            }
            catch (LoginException e) {
                throw new DermisException("AEM-AUT-001-005", new String[0]);
            }
        }
        return resourceResolver;
    }

    public static Map createRequestDataContext(Map paramMap) {
        HashMap<String, HashMap<String, Map>> outputMap = null;
        if (paramMap != null) {
            HashMap<String, Map> attributeMap = new HashMap<String, Map>();
            attributeMap.put("attribute", paramMap);
            outputMap = new HashMap<String, HashMap<String, Map>>();
            outputMap.put("request", attributeMap);
        }
        return outputMap;
    }

    public static Map createBinaryAndRequestDataContext(Map requestParamMap, Map attachmentContext, Map dorContext) {
        Map<String, Map> outputMap = new HashMap();
        if (requestParamMap != null) {
            outputMap = DermisUtils.createRequestDataContext(requestParamMap);
        }
        if (attachmentContext != null) {
            outputMap.put("attachment", attachmentContext);
        } else if (dorContext != null) {
            outputMap.put("attachment", dorContext);
        }
        return outputMap;
    }

    public static Boolean isBinaryAsset(ITypeAsset asset) {
        boolean isBinaryAsset = false;
        if (asset != null) {
            if (PropertyType.STRING.equals((Object)asset.getType()) && (PropertyFormatType.BINARY.equals((Object)asset.getFormatType()) || PropertyFormatType.BYTE.equals((Object)asset.getFormatType()))) {
                isBinaryAsset = true;
            } else if (StringUtils.isNotBlank((CharSequence)asset.getMediaType()) && StringUtils.isNotBlank((CharSequence)asset.getMediaBinaryEncoding())) {
                isBinaryAsset = true;
            }
        }
        return isBinaryAsset;
    }

    public static Object getArgumentValue(IProperty argument, IValueMap input) throws DermisException {
        Object value = null;
        if (argument != null && input != null) {
            String name = argument.getName();
            IValue ivalue = ValueUtil.getValue(input, name);
            value = ValueUtil.getFormattedValue(ivalue);
            if (argument.getRequired().booleanValue() && (value == null || StringUtils.isBlank((CharSequence)value.toString()))) {
                throw new DermisException("AEM-FDM-001-012", new String[]{name}, 1);
            }
        }
        return value;
    }

    public static void expandProperty(FormDataModel formDataModel, Attribute property, List<String> encounteredEntities, boolean includeRefChildAttrs) throws DermisException {
        try {
            PropertyType type;
            if (property != null && (PropertyType.ARRAY == (type = property.getType()) || PropertyType.OBJECT == type)) {
                IDataModel associatedDataModel;
                Entity fdmEntity;
                List<? extends IProperty> childProperties = null;
                String dataModelNameRef = property.getReferenceName();
                if (StringUtils.isNotEmpty((CharSequence)dataModelNameRef)) {
                    includeRefChildAttrs = includeRefChildAttrs && !encounteredEntities.contains(dataModelNameRef);
                }
                encounteredEntities.add(dataModelNameRef);
                if (formDataModel != null && StringUtils.isNotBlank((CharSequence)dataModelNameRef) && (fdmEntity = formDataModel.getEntityById(dataModelNameRef)) != null) {
                    property.addAssociation(type, (IDataModel)SerializationUtils.clone((Serializable)fdmEntity));
                    property.setTypeRef(null);
                    property.setSubTypeRef(null);
                }
                if ((associatedDataModel = property.getAssociatedDataModel()) != null) {
                    childProperties = associatedDataModel.getProperties();
                }
                if (childProperties != null) {
                    for (int index = 0; index < childProperties.size(); ++index) {
                        Attribute childProperty = (Attribute)childProperties.get(index);
                        if (childProperty.getId() == null && (StringUtils.isEmpty((CharSequence)childProperty.getReferenceName()) || includeRefChildAttrs)) {
                            DermisUtils.expandProperty(formDataModel, childProperty, encounteredEntities, includeRefChildAttrs);
                            continue;
                        }
                        childProperties.remove(childProperty);
                        --index;
                    }
                }
                encounteredEntities.remove(encounteredEntities.size() - 1);
            }
        }
        catch (DermisException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DermisException(e);
        }
    }

    public static IDataModel getRefDatamodel(List<? extends IDataModel> dataModels, IProperty property) {
        PropertyType type;
        IDataModel refDataModel = null;
        if (property != null && (PropertyType.ARRAY == (type = property.getType()) || PropertyType.OBJECT == type)) {
            String dataModelNameRef = property.getReferenceName();
            if (dataModels != null && StringUtils.isNotBlank((CharSequence)dataModelNameRef)) {
                refDataModel = DermisUtils.getDatamodelByNameAndSchema(dataModels, dataModelNameRef, null);
            }
        }
        return refDataModel;
    }

    public static void setDataSetInDataContext(DataContext dataContext, Object value, String key) {
        if (dataContext != null) {
            Map<String, Object> entityMap;
            if (dataContext.containsKey("dataset")) {
                entityMap = (Map)dataContext.get("dataset");
            } else {
                entityMap = new HashMap();
                dataContext.put("dataset", (Object)entityMap);
            }
            entityMap.put(key, value);
        }
    }

    public static <T> List<T> joinLists(List<T> list1, List<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        if (list1 != null) {
            list.addAll(list1);
        }
        if (list2 != null) {
            list.addAll(list2);
        }
        return list;
    }

    public static IDataModel resolveType(List<? extends IDataModel> dataModels, Map data) {
        if (data instanceof Map && DermisUtils.hasTypeInfoInAdditonalData(data)) {
            Map fdm_additionalData = (Map)data.get("_fdm_additionalData");
            Object typeObject = fdm_additionalData.get("_type");
            Object schemaObject = fdm_additionalData.get("_schema");
            String type = null;
            String schema = null;
            if (typeObject instanceof String) {
                type = (String)typeObject;
            } else if (typeObject instanceof TypeValue) {
                type = (String)((TypeValue)typeObject).get();
            }
            if (schemaObject instanceof String) {
                schema = (String)schemaObject;
            } else if (schemaObject instanceof TypeValue) {
                schema = (String)((TypeValue)schemaObject).get();
            }
            return DermisUtils.getDatamodelByNameAndSchema(dataModels, type, schema);
        }
        return null;
    }

    public static IDataModel getDatamodelByNameAndSchema(List<? extends IDataModel> dataModels, String entityName, String schema) {
        IDataModel result = null;
        if (StringUtils.isNotEmpty((CharSequence)entityName) && dataModels != null) {
            for (IDataModel iDataModel : dataModels) {
                if (!iDataModel.getName().equals(entityName) || !StringUtils.isEmpty((CharSequence)schema) && !iDataModel.getSchemaName().equals(schema)) continue;
                result = iDataModel;
                break;
            }
        }
        return (IDataModel)SerializationUtils.clone(result);
    }

    public static boolean hasTypeInfoInAdditonalData(Object data) {
        Map fdmAdditionalData;
        return DermisUtils.hasFDMAdditionalDataInfoInData(data) && (fdmAdditionalData = (Map)((Map)data).get("_fdm_additionalData")).containsKey("_type");
    }

    private static boolean hasFDMAdditionalDataInfoInData(Object data) {
        return data instanceof Map && ((Map)data).containsKey("_fdm_additionalData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration(String configPath, boolean isCloudConfig, ResourceResolverFactory resourceResolverFactory, ConfigurationResolver configurationResolver, ConfigurationResourceResolver configurationResourceResolver, Class<? extends Configuration> configClass) throws DermisException {
        Configuration configuration;
        Resource configResource = null;
        Assert.assertNotNull((String)configPath, (String)"AEM-FDM-001-012", (String[])new String[]{"Configuration"}, (int)1);
        if (isCloudConfig) {
            try (ResourceResolver resourceResolver = DermisUtils.getFnDServiceUserResourceResolver(resourceResolverFactory, "readCloudService");){
                ValueMap vm = null;
                String configName = configPath;
                if (configName.startsWith(Constants.CONF_ROOT)) {
                    String configRef = "null";
                    for (String bucketPath : DermisConstants.FDM_CLOUD_SERVICE_BUCKET_PATHS) {
                        if (!configName.contains(Constants.CONF_CONTAINER_BUCKET_NAME + "/" + bucketPath)) continue;
                        configRef = configName.substring(0, configName.indexOf(Constants.CONF_CONTAINER_BUCKET_NAME + "/" + bucketPath));
                        configName = configName.substring(configName.indexOf(bucketPath));
                    }
                    ValueMapDecorator resourceValueMap = new ValueMapDecorator(new HashMap());
                    if (!configRef.equals("null")) {
                        resourceValueMap.put((Object)Constants.PN_CONF_REF, (Object)configRef);
                    }
                    ArrayList<ValueMapResource> children = new ArrayList<ValueMapResource>();
                    ValueMapResource childResource = new ValueMapResource(resourceResolver, "/content/dam/formsanddocuments-fdm/jcr:content", null, (ValueMap)resourceValueMap);
                    children.add(childResource);
                    ValueMapResource contextResource = new ValueMapResource(resourceResolver, "/content/dam/formsanddocuments-fdm", null, null, children);
                    ConfigurationBuilder configurationBuilder = configurationResolver.get((Resource)contextResource);
                    configurationBuilder = configurationBuilder.name(configName);
                    vm = configurationBuilder.asValueMap();
                    configResource = configurationResourceResolver.getResource((Resource)contextResource, Constants.CONF_CONTAINER_BUCKET_NAME, configName);
                } else if (configName.startsWith("/etc/cloudservices/fdm")) {
                    configResource = resourceResolver.getResource(configName);
                }
                if (configResource == null) {
                    throw new DermisException("AEM-AUT-001-008", new String[]{configPath}, 1);
                }
                Resource jcrResource = configResource.getChild("jcr:content");
                if (jcrResource == null) {
                    throw new DermisException("AEM-AUT-001-008", new String[]{configPath}, 1);
                }
                if (vm != null) {
                    jcrResource = new ConfigurationResourceWrapper(jcrResource, vm);
                }
                configuration = (Configuration)jcrResource.adaptTo(configClass);
            }
        } else {
            configuration = new Configuration(null);
            configuration.setId(configPath);
        }
        return configuration;
    }

    public static String getQueryParamsValue(String url, String key, String charset) throws URISyntaxException {
        String value = null;
        List params = URLEncodedUtils.parse((URI)new URI(url), (String)charset);
        for (NameValuePair pair : params) {
            if (!key.equals(pair.getName())) continue;
            value = pair.getValue();
        }
        return value;
    }

    public static URIBuilder addQueryParameter(URIBuilder uriBuilder, String key, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value) && StringUtils.isNotEmpty((CharSequence)key) && uriBuilder != null) {
            uriBuilder.addParameter(key, value);
        }
        return uriBuilder;
    }
}

