/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aem.dermis.util;

import com.adobe.aem.dermis.exception.DermisException;
import com.adobe.aem.dermis.model.value.IValue;
import com.adobe.aem.dermis.model.value.IValueList;
import com.adobe.aem.dermis.model.value.IValueMap;
import com.adobe.aem.dermis.util.SlingJSONWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.JSONTokener;
import org.apache.sling.commons.json.jcr.JsonItemWriter;

public class JsonUtils {
    public static Object jsonToObject(String data) throws JSONException {
        Object result = null;
        if (StringUtils.isNotEmpty((String)data)) {
            Object json = new JSONTokener(data).nextValue();
            if (json instanceof JSONArray) {
                result = JsonUtils.toList((JSONArray)json);
            } else if (json instanceof JSONObject) {
                result = JsonUtils.jsonToMap((JSONObject)json);
            }
        }
        return result;
    }

    public static Map<String, Object> jsonToMap(JSONObject json) throws JSONException {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != JSONObject.NULL && json != null) {
            retMap = JsonUtils.toMap(json);
        }
        return retMap;
    }

    public static Map<String, Object> toMap(JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = JsonUtils.getValue(object, key);
            if (value instanceof JSONArray) {
                value = JsonUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonUtils.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private static List<Object> toList(JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = JsonUtils.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = JsonUtils.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public static JSONObject resourceToJSON(Resource resource) throws DermisException {
        HashSet<String> jcrPropertiesToIgnore = new HashSet<String>(){
            {
                this.add("jcr:created");
                this.add("jcr:createdBy");
                this.add("jcr:versionHistory");
                this.add("jcr:predecessors");
                this.add("jcr:baseVersion");
                this.add("jcr:uuid");
                this.add("jcr:primaryType");
                this.add("jcr:lastModified");
            }
        };
        HashSet<String> fdmPropertiesToIgnore = new HashSet<String>(){
            {
                this.add("fdm:bindRef");
            }
        };
        HashSet<String> propertiesToIgnore = new HashSet<String>();
        propertiesToIgnore.addAll(jcrPropertiesToIgnore);
        propertiesToIgnore.addAll(fdmPropertiesToIgnore);
        Node node = (Node)resource.adaptTo(Node.class);
        StringWriter stringWriter = new StringWriter();
        JsonItemWriter jsonWriter = new JsonItemWriter(propertiesToIgnore);
        JSONObject jsonObject = null;
        try {
            jsonWriter.dump(node, (Writer)stringWriter, -1);
            jsonObject = new JSONObject(stringWriter.toString());
        }
        catch (RepositoryException | JSONException e) {
            throw new DermisException("Could not create JSON from resource at path " + resource.getPath());
        }
        return jsonObject;
    }

    public static Object getJSON(IValue value) throws DermisException {
        JSONObject json = null;
        try {
            StringWriter stringWriter = new StringWriter();
            SlingJSONWriter writer = new SlingJSONWriter(stringWriter);
            writer.write(value);
            if (value instanceof IValueMap) {
                json = new JSONObject(stringWriter.toString());
            } else if (value instanceof IValueList) {
                json = new JSONArray(stringWriter.toString());
            }
        }
        catch (JSONException e) {
            throw new DermisException(e);
        }
        return json;
    }

    public static Object getValue(JSONObject jsonInput, String name) {
        Object result = null;
        if (jsonInput != null && jsonInput.has(name) && (result = jsonInput.opt(name)) != null && result.equals(JSONObject.NULL)) {
            result = null;
        }
        return result;
    }
}

