/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.addon.dor;

import com.adobe.aemds.guide.addon.dor.MetaTemplateParser;
import com.adobe.aemds.guide.addon.dor.XFADocument;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.day.cq.i18n.I18n;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaTemplate {
    private static final Logger log = LoggerFactory.getLogger(MetaTemplate.class);
    private static final String DEFAULT_METATEMPLATE = "/com/adobe/aemds/guide/addon/dor/metatemplate/defaultmetatemplate.xdp";
    private String metaTemplateRef = "";
    private Document document;
    private NodeList masterPage;
    private Map<String, Map<String, Element>> elements;
    private Element variables;
    private Element fontFamily;
    private Element accentColor;
    private Element hyphenation;
    private Element spaceFiller;
    private Document defaultDocument;
    private Element defaultMasterPage;
    private Map<String, Map<String, Element>> defaultElements;
    private Element defaultVariables;
    private Element defaultFontFamily;
    private Element defaultAccentColor;
    private Element defaultHyphenation;
    private Element defaultSpaceFiller;

    public MetaTemplate(byte[] metaTemplateBytes, String metaTemplateRef) {
        this.document = XFADocument.loadXFADocument(metaTemplateBytes);
        this.metaTemplateRef = metaTemplateRef;
        MetaTemplateParser parser = new MetaTemplateParser(this.document, metaTemplateRef);
        this.masterPage = parser.getMasterPageList();
        this.elements = parser.getDefaultElements();
        this.variables = parser.getVariables();
        this.fontFamily = parser.getFontFamily();
        this.accentColor = parser.getAccentColor();
        this.hyphenation = parser.getHyphenationElement();
        this.spaceFiller = parser.getFillerElement();
        try {
            InputStream inputStream = MetaTemplate.class.getResourceAsStream(DEFAULT_METATEMPLATE);
            byte[] defaultTemplateBytes = IOUtils.toByteArray((InputStream)inputStream);
            this.defaultDocument = XFADocument.loadXFADocument(defaultTemplateBytes);
            MetaTemplateParser defaultDocumentParser = new MetaTemplateParser(this.defaultDocument);
            this.defaultMasterPage = (Element)defaultDocumentParser.getMasterPageList().item(0);
            this.defaultElements = defaultDocumentParser.getDefaultElements();
            this.defaultVariables = defaultDocumentParser.getVariables();
            this.defaultFontFamily = defaultDocumentParser.getFontFamily();
            this.defaultAccentColor = defaultDocumentParser.getAccentColor();
            this.defaultHyphenation = defaultDocumentParser.getHyphenationElement();
            this.defaultSpaceFiller = defaultDocumentParser.getFillerElement();
            this.handleBackwardCompatibility();
        }
        catch (Exception e) {
            log.error("Failed to load default meta template", (Throwable)e);
        }
    }

    public MetaTemplate(byte[] metaTemplateBytes) {
        this(metaTemplateBytes, null);
    }

    public NodeList getMasterPage() {
        return this.masterPage != null ? this.masterPage : new ArrayNodeList(new ArrayList<Element>(Collections.singleton(this.defaultMasterPage)));
    }

    public Element getDefaultMasterPage() {
        return this.defaultMasterPage;
    }

    public Map<String, Element> getElement(String elementName) {
        Map<String, Element> element = this.elements.get(elementName);
        return element != null && element.size() > 0 ? element : this.defaultElements.get(elementName);
    }

    public Element getDefaultElement(String elementName) {
        return this.defaultElements.get(elementName).get("Default");
    }

    public Node getVariable(String varName) {
        return this.variables != null ? this.variables.resolveNode(varName) : null;
    }

    public Node getDefaultVariable(String varName) {
        return this.defaultVariables.resolveNode(varName);
    }

    public Element getVariables() {
        return this.variables;
    }

    public Element getDefaultVariables() {
        return this.defaultVariables;
    }

    public Element getFontFamily() {
        return this.fontFamily != null ? this.fontFamily : this.defaultFontFamily;
    }

    public Element getDefaultFontFamily() {
        return this.defaultFontFamily;
    }

    public Element getAccentColor() {
        return this.accentColor != null ? this.accentColor : this.defaultAccentColor;
    }

    public Element getDefaultAccentColor() {
        return this.defaultAccentColor;
    }

    public Element getHyphenationElement() {
        return this.hyphenation != null ? this.hyphenation : this.defaultHyphenation;
    }

    public Element getDefaultHyphenationElement() {
        return this.defaultHyphenation;
    }

    public Element getSpaceFillerElement() {
        return this.spaceFiller != null ? this.spaceFiller : this.defaultSpaceFiller;
    }

    public Element getDefaultSpaceFillerElement() {
        return this.defaultSpaceFiller;
    }

    public Document getDocument() {
        if (this.document != null) {
            return this.document;
        }
        return this.defaultDocument;
    }

    public Document getDefaultDocument() {
        return this.defaultDocument;
    }

    public String getMetaTemplateRef() {
        return this.metaTemplateRef;
    }

    public JSONObject getBrandingComponents(I18n i18n) {
        MetaTemplateParser parser = new MetaTemplateParser(this.document, this.metaTemplateRef);
        return parser.getBrandingComponents(i18n);
    }

    public Map<String, List> getPageAndContentAreaList() {
        MetaTemplateParser parser = new MetaTemplateParser(this.document, this.metaTemplateRef);
        HashMap<String, List> pageAndContentAreaList = new HashMap<String, List>();
        NodeList masterPageList = parser.getMasterPageList();
        if (masterPageList != null) {
            pageAndContentAreaList.put("masterPages", parser.getMasterPageList(masterPageList));
            pageAndContentAreaList.put("contentAreas", parser.getContentAreaList(masterPageList));
        }
        return pageAndContentAreaList;
    }

    public JSONObject getConfigProperties(I18n i18n) {
        MetaTemplateParser parser = new MetaTemplateParser(this.document, this.metaTemplateRef);
        return parser.getConfigProperties(i18n);
    }

    private void handleBackwardCompatibility() {
        this.handleBackwardCompatibilityForRadioButtonList();
    }

    private void handleBackwardCompatibilityForRadioButtonList() {
        Element element = this.elements.get("AF_RADIOBUTTONLIST_XFO").get("Default");
        if (element != null && element.resolveNode("HiddenTextField") == null) {
            Element hiddenNode = (Element)this.defaultElements.get("AF_RADIOBUTTONLIST_XFO").get("Default").resolveNode("HiddenTextField");
            element.appendChild((Node)hiddenNode.clone(null, true));
        }
    }
}

