/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.common;

import com.adobe.aemds.guide.common.GuideItemsContainer;
import com.adobe.aemds.guide.utils.GuideConstants;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.wcm.api.WCMMode;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.script.SimpleBindings;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class GuidePanel
extends GuideItemsContainer
implements Serializable {
    public int getMinOccur() {
        return (Integer)this.resourceProps.get("minOccur", (Object)1);
    }

    public int getMaxOccur() {
        return (Integer)this.resourceProps.get("maxOccur", (Object)1);
    }

    public int getInitialOccur() {
        return (Integer)this.resourceProps.get("initialOccur", (Object)1);
    }

    public String getFragRefPropertyFromResource() {
        return (String)this.resourceProps.get("fragRef", (Object)"");
    }

    public String getFragRef() {
        String fragRefAssetPath = this.getFragRefPropertyFromResource();
        String fragRefContainerPath = "";
        String fragRefRootPanelPath = "";
        if (fragRefAssetPath.length() > 0) {
            fragRefContainerPath = GuideUtils.convertFMAssetPathToContainerPath(fragRefAssetPath);
            Resource fragRefRootPanel = GuideUtils.getRootPanel(this.getResource().getResourceResolver().getResource(fragRefContainerPath));
            if (fragRefRootPanel != null) {
                fragRefRootPanelPath = fragRefRootPanel.getPath();
            }
        }
        return fragRefRootPanelPath;
    }

    public boolean isFragmentAvailable() {
        String fragRefAssetPath = this.getFragRefPropertyFromResource();
        ResourceResolver resourceResolver = this.getResource().getResourceResolver();
        Resource fragmentContainer = resourceResolver.getResource(fragRefAssetPath);
        if (fragmentContainer != null) {
            String fragRefContainerPath = GuideUtils.convertFMAssetPathToContainerPath(fragRefAssetPath);
            Resource fragRefRootPanel = GuideUtils.getRootPanel(this.getResource().getResourceResolver().getResource(fragRefContainerPath));
            if (fragRefRootPanel != null) {
                return true;
            }
        }
        return false;
    }

    public Map<String, String> getFragmentDetails() {
        ResourceResolver resourceResolver;
        HashMap<String, String> fragDetails = new HashMap<String, String>();
        String fragRef = this.getFragRef();
        XSSAPI xssApi = this.getXssapi();
        StringBuilder fragFieldDetails = new StringBuilder("");
        if (fragRef.length() > 0 && (resourceResolver = this.getResource().getResourceResolver()) != null) {
            Resource fragment = resourceResolver.getResource(fragRef.substring(0, fragRef.indexOf("guideContainer") - 1));
            String title = (String)((ValueMap)fragment.adaptTo(ValueMap.class)).get((Object)"jcr:title");
            fragDetails.put("title", GuideUtils.encodeForHtml(title, xssApi));
            Resource fragRefRootPanel = fragment.getChild("guideContainer").getChild("rootPanel");
            if (fragRefRootPanel != null) {
                int numberOfFieldsListed = 0;
                for (Resource itemResource : fragRefRootPanel.getChild("items").getChildren()) {
                    ValueMap itemValueMap = ResourceUtil.getValueMap((Resource)itemResource);
                    String fieldLabel = (String)itemValueMap.get("jcr:title", (Object)"");
                    if (fieldLabel == null || fieldLabel.length() == 0) {
                        fieldLabel = (String)itemValueMap.get("name", (Object)"");
                    }
                    if (!StringUtils.isEmpty((String)fieldLabel)) {
                        GuideUtils.encodeForHtml(fieldLabel, xssApi);
                        fragFieldDetails.append(fieldLabel).append("<br>");
                    }
                    if (++numberOfFieldsListed != GuideConstants.NO_OF_FIELDS_TO_DISPLAY_FOR_FRAG_PLACEHOLDER) continue;
                    break;
                }
                fragDetails.put("fieldDetails", fragFieldDetails.toString());
            }
        }
        return fragDetails;
    }

    public String getOptimizeRenderPerformance() {
        return (String)this.resourceProps.get("optimizeRenderPerformance", (Object)"");
    }

    public String getAssetRef() {
        String fragRefAssetPath = this.getFragRefPropertyFromResource();
        String optimizeRenderLayout = this.getOptimizeRenderPerformance();
        if (StringUtils.isNotEmpty((String)fragRefAssetPath) && StringUtils.isNotEmpty((String)optimizeRenderLayout)) {
            return fragRefAssetPath;
        }
        return null;
    }

    public String getLayoutFromFragRootPanel() {
        Resource layout;
        ResourceResolver resourceResolver;
        Resource fragRefRootPanel;
        String fragRef = this.getFragRef();
        if (fragRef.length() > 0 && (fragRefRootPanel = (resourceResolver = this.getResource().getResourceResolver()).getResource(fragRef)) != null && (layout = fragRefRootPanel.getChild("layout")) != null) {
            return (String)((ValueMap)layout.adaptTo(ValueMap.class)).get((Object)"sling:resourceType");
        }
        return null;
    }

    public String getAfFragmentMarker() {
        String afFragmentClass = "";
        SlingHttpServletRequest request = this.slingRequest;
        String fragRefAssetPath = this.getFragRefPropertyFromResource();
        if (fragRefAssetPath.length() > 0 && WCMMode.EDIT.equals((Object)WCMMode.fromRequest((ServletRequest)request))) {
            afFragmentClass = "afFragmentMarker";
        }
        return afFragmentClass;
    }

    public Boolean isNewResponsiveLayout() {
        Resource panelResource = this.getResource();
        Resource layoutResource = panelResource.getChild("layout");
        return layoutResource.isResourceType("fd/af/layouts/gridFluidLayout2");
    }

    @Override
    public Map<String, Object> getAuthoringConfig() {
        Map<String, Object> authoringConfig = super.getAuthoringConfig();
        Boolean nonNavigable = this.getNonNavigableProperty();
        String dorLayoutType = this.getDoRLayoutType();
        this.updateFragmentLayoutInformation(authoringConfig);
        authoringConfig.put("nonNavigable", nonNavigable);
        authoringConfig.put("dorLayoutType", dorLayoutType);
        authoringConfig.put("isNewResponsiveLayout", this.isNewResponsiveLayout());
        GuideUtils.setMasterAuthoringConfig(authoringConfig, this.resourceProps);
        return authoringConfig;
    }

    private void updateFragmentLayoutInformation(Map<String, Object> authoringConfig) {
        Resource fragRootPanelResource;
        String fragRef = this.getFragRefPropertyFromResource();
        String fragRefRootPanel = this.getFragRef();
        Boolean isOldResponsiveFragment = false;
        if (StringUtils.isNotEmpty((String)fragRef) && StringUtils.isNotEmpty((String)fragRefRootPanel) && (fragRootPanelResource = this.slingRequest.getResourceResolver().getResource(fragRefRootPanel)) != null) {
            isOldResponsiveFragment = GuideUtils.isOldResponsiveLayout(fragRootPanelResource);
            isOldResponsiveFragment = isOldResponsiveFragment == null ? false : isOldResponsiveFragment;
            authoringConfig.put("isNewResponsiveFragment", isOldResponsiveFragment);
        }
    }

    public String getDoRLayoutType() {
        String dorLayoutType = "";
        try {
            dorLayoutType = (String)this.getLayoutProperty("dorLayoutType");
        }
        catch (Exception e) {
            this.logger.error("Unable to fetch dorLayoutType property " + e.getMessage(), (Throwable)e);
        }
        return dorLayoutType;
    }

    public String getPanelInlineStyles() {
        return this.getInlineStyles("Panel");
    }

    public String getPanelDescriptionInlineStyles() {
        return this.getInlineStyles("PanelDescription");
    }

    @Override
    public boolean getIsRepeatable() {
        return this.getMinOccur() != 1 || this.getMaxOccur() != 1;
    }

    public boolean isHasToolbar() {
        return this.getResource().getChild("toolbar") != null;
    }

    public String getLongDescription() {
        return this.externalize((String)this.resourceProps.get("longDescription", (Object)""), "longDescription");
    }

    public GuideItemsContainer getToolbar() {
        Resource toolbarResource = this.getResource().getChild("toolbar");
        if (toolbarResource != null) {
            GuideItemsContainer guideItemsContainer = new GuideItemsContainer();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put("resource", (Object)toolbarResource);
            bindings.put("request", (Object)this.slingRequest);
            guideItemsContainer.init(bindings);
            return guideItemsContainer;
        }
        return null;
    }

    @Override
    public boolean validate(ResourceResolver serviceResourceResolver) {
        Resource layout = this.getResource().getChild("layout");
        if (layout != null) {
            if (this.getIsEditMode().booleanValue()) {
                try {
                    this.updateCompletionAndSummary(layout);
                }
                catch (PersistenceException e) {
                    this.logger.error("AF: Unable to set layout Properties" + e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.updatePanelLayoutProperties(layout, serviceResourceResolver);
            }
            catch (RepositoryException | PersistenceException e) {
                this.logger.info("[AF] Unable to modify layout properties {}" + e.getMessage(), e);
            }
        }
        return true;
    }

    private void updateCompletionAndSummary(Resource layoutNode) throws PersistenceException {
        try {
            Resource getChildrenResource;
            Resource panel;
            ModifiableValueMap layoutproperties = (ModifiableValueMap)layoutNode.adaptTo(ModifiableValueMap.class);
            if (layoutproperties == null) {
                return;
            }
            String layoutCmpPath = (String)layoutproperties.get((Object)"sling:resourceType");
            if (layoutCmpPath != null && (panel = layoutNode.getParent()) != null && (getChildrenResource = panel.getChild("items")) != null) {
                Iterator it = getChildrenResource.listChildren();
                while (it.hasNext()) {
                    Resource child = (Resource)it.next();
                    ModifiableValueMap childMap = (ModifiableValueMap)child.adaptTo(ModifiableValueMap.class);
                    String guideNodeClass = (String)childMap.get("guideNodeClass", (Object)"");
                    if (!guideNodeClass.equals("rootPanelNode") && !guideNodeClass.equals("guidePanel")) continue;
                    String oldValue = (String)childMap.get("summaryExpVisible", (Object)"");
                    if (layoutCmpPath.equals("fd/af/layouts/panel/accordion")) {
                        if (oldValue.length() != 0 && oldValue.equals("yes")) continue;
                        childMap.put((Object)"summaryExpVisible", (Object)"yes");
                        child.getResourceResolver().commit();
                        continue;
                    }
                    if (oldValue.length() <= 0) continue;
                    childMap.remove((Object)"summaryExpVisible");
                    child.getResourceResolver().commit();
                }
            }
        }
        catch (PersistenceException e) {
            this.logger.error("Unable to commit summary expression visible property on " + layoutNode.getPath(), (Throwable)e);
        }
    }

    private void updatePanelLayoutProperties(@Nonnull Resource layoutResource, @Nonnull ResourceResolver serviceResourceResolver) throws PersistenceException, RepositoryException {
        String layoutResourceType;
        ModifiableValueMap layoutProperties;
        String[] layoutWhiteListProperties = new String[]{"enableLayoutOptimization", "guideNavigatorTab", "nonNavigable"};
        String[] panelLayouts = new String[]{"fd/af/layouts/panel/accordion", "fd/af/layouts/panel/tabbedPanelLayout", "fd/af/layouts/panel/verticalTabbedPanelLayout", "fd/af/layouts/panel/wizard", "fd/af/layouts/gridFluidLayout", "fd/af/layouts/gridFluidLayout2"};
        ResourceResolver resourceResolver = layoutResource.getResourceResolver();
        Session currentSession = (Session)resourceResolver.adaptTo(Session.class);
        if (currentSession != null && currentSession.hasPermission(layoutResource.getPath(), "set_property") && currentSession.hasPermission(layoutResource.getPath(), "remove") && (layoutProperties = (ModifiableValueMap)layoutResource.adaptTo(ModifiableValueMap.class)) != null && (layoutResourceType = (String)layoutProperties.get((Object)"sling:resourceType")) != null) {
            for (String panelLayout : panelLayouts) {
                Resource panelLayoutResource;
                if (!layoutResource.isResourceType(panelLayout) || (panelLayoutResource = serviceResourceResolver.getResource(panelLayout)) == null) continue;
                Resource graniteData = panelLayoutResource.getChild("granite:data");
                if (graniteData == null) break;
                boolean isModified = false;
                for (String layoutProperty : layoutWhiteListProperties) {
                    Object oldValue = layoutProperties.get((Object)layoutProperty);
                    Object newValue = graniteData.getValueMap().get((Object)layoutProperty);
                    if (newValue != null) {
                        if (newValue.equals(oldValue)) continue;
                        isModified = true;
                        layoutProperties.put((Object)layoutProperty, newValue);
                        this.logger.info("[AF] Layout Property - {} updated with new value - {} ", (Object)layoutProperty, newValue);
                        continue;
                    }
                    if (oldValue == null) continue;
                    isModified = true;
                    layoutProperties.remove((Object)layoutProperty);
                    this.logger.info("[AF] Layout Property - {} deleted ", (Object)layoutProperty);
                }
                if (!isModified) break;
                resourceResolver.commit();
                break;
            }
        }
    }
}

