/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.forms.foundation.usc.fdinternal.api.USCConfigurationService;
import com.adobe.forms.foundation.usc.fdinternal.model.USCClient;
import com.adobe.forms.foundation.usc.model.USCException;
import com.adobe.granite.toggle.api.ToggleRouter;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.resourceTypes=fd/af/rendercondition/autosave"})
public class AutoSaveRenderCondition
extends SlingSafeMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoSaveRenderCondition.class);
    @Reference
    private USCConfigurationService uscConfigurationService;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private ToggleRouter toggleRouter;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) {
        boolean autoSaveEnable = this.isFeatureEnabled("FT_FORMS-11581") && this.isPortalUSCConfigAvailable();
        request.setAttribute(RenderCondition.class.getName(), (Object)new SimpleRenderCondition(autoSaveEnable));
    }

    private boolean isFeatureEnabled(String featureName) {
        return this.toggleRouter != null && this.toggleRouter.isEnabled(featureName);
    }

    private boolean isPortalUSCConfigAvailable() {
        try {
            this.uscConfigurationService.getConfig(USCClient.FORMS_PORTAL);
        }
        catch (USCException e) {
            LOGGER.error("[AF] Auto Save - USC configuration not available for portal");
            return false;
        }
        return true;
    }
}

