/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.servlet;

import com.adobe.aemds.guide.common.GuideContainer;
import com.adobe.aemds.guide.service.GuideModelTransformer;
import com.adobe.aemds.guide.service.GuideSchemaType;
import com.adobe.aemds.guide.utils.GuideUtils;
import com.adobe.aemds.guide.utils.JSONCreationOptions;
import com.adobe.forms.common.service.ContentType;
import com.adobe.forms.common.service.DataOptions;
import com.adobe.forms.common.service.FileAttachmentWrapper;
import com.adobe.forms.common.service.FormDataProviderRegistry;
import com.adobe.forms.common.service.FormsCommonConfigurationService;
import com.adobe.forms.common.service.PrefillData;
import com.adobe.forms.common.service.TestDataProvider;
import com.adobe.forms.foundation.fdinternal.utils.PerformanceLogger;
import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"fd/af/components/guideContainer", "fd/af/components/aemform"}), @Property(name="sling.servlet.methods", value={"POST"}), @Property(name="service.description", value={"Adaptive Form Prefill Data Provider"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.selectors", value={"af.prefilldata"})})
public class GuideDataProviderServlet
extends SlingAllMethodsServlet {
    @Reference
    private FormsCommonConfigurationService formsCommonConfigurationService;
    @Reference
    private TestDataProvider testDataProvider;
    @Reference
    private FormDataProviderRegistry formDataProviderRegistry;
    @Reference
    private GuideModelTransformer guideModelTransformer;

    private ContentType getContentType(GuideContainer container) {
        GuideSchemaType schemaType = container.getSchema();
        if (schemaType == GuideSchemaType.XSD || schemaType == GuideSchemaType.BASIC) {
            return ContentType.XML;
        }
        return ContentType.JSON;
    }

    private Object get(SlingHttpServletRequest request, String parmOrAttribute) {
        Object res = request.getAttribute(parmOrAttribute);
        if (res == null) {
            res = request.getParameter(parmOrAttribute);
        }
        return res;
    }

    private Resource getFormContainer(Resource resource) {
        if (resource.isResourceType("fd/af/components/aemform")) {
            return resource;
        }
        return null;
    }

    private Resource getGuideContainer(Resource resource) {
        Resource retVal = null;
        if (resource.isResourceType("fd/af/components/aemform")) {
            ValueMap values = resource.getValueMap();
            String probableGuideContainer = GuideUtils.convertFMAssetPathToContainerPath((String)values.get((Object)"formRef"));
            Resource gc = resource.getResourceResolver().getResource(probableGuideContainer);
            if (gc != null && gc.isResourceType("fd/af/components/guideContainer")) {
                retVal = gc;
            }
        } else {
            retVal = resource;
        }
        return retVal;
    }

    private String getDataRef(SlingHttpServletRequest request) {
        String retVal = null;
        Object dataRef = this.get(request, "dataRef");
        if (dataRef != null) {
            retVal = dataRef.toString();
        }
        return retVal;
    }

    private boolean useTestDataPrefillService(SlingHttpServletRequest request) {
        boolean useTestDataPrefillService = this.formsCommonConfigurationService.useTestDataPrefillService();
        return WCMMode.fromRequest((ServletRequest)request).equals((Object)WCMMode.PREVIEW) && useTestDataPrefillService;
    }

    protected void doPost(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        PerformanceLogger perfLogger = new PerformanceLogger("GuideDataProviderServlet.doGet");
        Resource resource = request.getResource();
        Resource gcResource = this.getGuideContainer(resource);
        GuideContainer container = GuideContainer.from(gcResource);
        GuideSchemaType schemaType = container.getSchema();
        ContentType contentType = this.getContentType(container);
        String prefillService = container.getPrefillService();
        String dataRef = this.getDataRef(request);
        Resource formContainer = this.getFormContainer(resource);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            String paramValue = request.getParameter(paramName);
            paramMap.put(paramName, paramValue);
        }
        response.setContentType(ContentType.JSON.toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (dataRef == null && prefillService == null && !this.useTestDataPrefillService(request)) {
            map.put("data", "");
        } else if (schemaType == GuideSchemaType.XDP) {
            JSONCreationOptions options = new JSONCreationOptions();
            I18n i18n = GuideUtils.getI18n(request, gcResource);
            options.setI18n(i18n).setDataRef(dataRef);
            if (formContainer != null) {
                options.setFormContainerPath(formContainer.getPath());
            }
            options.setPrefillServiceParams(paramMap);
            String res = this.guideModelTransformer.getDataJson(gcResource, options);
            map.put("data", res);
            map.put("isMergedJson", true);
        } else {
            DataOptions dataOptions = new DataOptions();
            if (dataRef != null) {
                dataOptions.setDataRef(dataRef);
            } else if (prefillService != null) {
                dataOptions.setServiceName(prefillService);
            }
            dataOptions.setAemFormContainer(this.getFormContainer(resource));
            dataOptions.setFormResource(gcResource);
            dataOptions.setExtras(paramMap);
            dataOptions.setContentType(contentType);
            InputStream inputStream = null;
            PrefillData prefillData = null;
            prefillData = this.useTestDataPrefillService(request) && dataRef == null ? this.testDataProvider.getPrefillData(dataOptions) : this.formDataProviderRegistry.getDataFromService(dataOptions);
            if (prefillData != null) {
                inputStream = prefillData.getInputStream();
            }
            if (inputStream == null) {
                map.put("data", "");
            } else {
                Map<String, String> context = prefillData.getCustomContext();
                Map<String, String> files = prefillData.getFileAttachmentMap();
                List<FileAttachmentWrapper> fileAttachmentWrappers = prefillData.getFileAttachmentWrappers();
                String data = IOUtils.toString((InputStream)inputStream, (String)StandardCharsets.UTF_8.name());
                if (context != null) {
                    map.put("customContext", new JSONObject(context));
                }
                if (fileAttachmentWrappers != null && fileAttachmentWrappers.size() > 0) {
                    JSONArray arr = new JSONArray();
                    for (int i = 0; i < fileAttachmentWrappers.size(); ++i) {
                        arr.put((Object)fileAttachmentWrappers.get(i).toJson());
                    }
                    map.put("attachments", arr.toString());
                } else if (files != null) {
                    map.put("fileAttachmentMap", new JSONObject(files));
                }
                map.put("data", data);
            }
            perfLogger.logPerformance();
        }
        JSONObject json = new JSONObject(map);
        response.getWriter().write(json.toString());
    }

    protected void bindFormsCommonConfigurationService(FormsCommonConfigurationService formsCommonConfigurationService) {
        this.formsCommonConfigurationService = formsCommonConfigurationService;
    }

    protected void unbindFormsCommonConfigurationService(FormsCommonConfigurationService formsCommonConfigurationService) {
        if (this.formsCommonConfigurationService == formsCommonConfigurationService) {
            this.formsCommonConfigurationService = null;
        }
    }

    protected void bindTestDataProvider(TestDataProvider testDataProvider) {
        this.testDataProvider = testDataProvider;
    }

    protected void unbindTestDataProvider(TestDataProvider testDataProvider) {
        if (this.testDataProvider == testDataProvider) {
            this.testDataProvider = null;
        }
    }

    protected void bindFormDataProviderRegistry(FormDataProviderRegistry formDataProviderRegistry) {
        this.formDataProviderRegistry = formDataProviderRegistry;
    }

    protected void unbindFormDataProviderRegistry(FormDataProviderRegistry formDataProviderRegistry) {
        if (this.formDataProviderRegistry == formDataProviderRegistry) {
            this.formDataProviderRegistry = null;
        }
    }

    protected void bindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        this.guideModelTransformer = guideModelTransformer;
    }

    protected void unbindGuideModelTransformer(GuideModelTransformer guideModelTransformer) {
        if (this.guideModelTransformer == guideModelTransformer) {
            this.guideModelTransformer = null;
        }
    }
}

