/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aemds.guide.utils;

import com.adobe.aemds.guide.progressive.GuideProgressiveCompletionInfo;
import com.adobe.aemds.guide.progressive.GuideProgressiveSectionInfo;
import com.adobe.aemds.guide.service.GuideException;
import com.adobe.aemds.guide.utils.GuideConstants;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideProgressiveUtils {
    private static Logger logger = LoggerFactory.getLogger(GuideProgressiveUtils.class);

    private static String getSectionJson(Object section) {
        if (section instanceof GuideProgressiveSectionInfo) {
            return ((GuideProgressiveSectionInfo)section).convertToJSON();
        }
        if (section instanceof GuideProgressiveCompletionInfo) {
            return ((GuideProgressiveCompletionInfo)section).convertToJSON();
        }
        return null;
    }

    public static String convertToJson(List<Object> allSections) {
        if (allSections.size() == 1) {
            return GuideProgressiveUtils.getSectionJson(allSections.get(0));
        }
        StringWriter jsonStringWriter = new StringWriter();
        JSONWriter jsonWriter = new JSONWriter((Writer)jsonStringWriter);
        try {
            jsonWriter.array();
            for (int i = 0; i < allSections.size(); ++i) {
                jsonWriter.value((Object)GuideProgressiveUtils.getSectionJson(allSections.get(i)));
            }
            jsonWriter.endArray();
        }
        catch (JSONException ex) {
            throw new GuideException(ex.getMessage(), (Exception)((Object)ex));
        }
        return jsonStringWriter.toString();
    }

    public static boolean isGuideProgressiveFieldModel(String guideNodeClass) {
        return GuideConstants.GUIDE_PROGRESSIVE_FIELDS_CLASS_NAMES.indexOf(guideNodeClass) >= 0;
    }
}

