/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fd.signatures;

import com.adobe.fd.signatures.CredentialProviderService;
import com.adobe.fd.signatures.truststore.businessobject.HSMProfileBO;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Modified;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyOption;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="HSM Credentials Configuration Service", description="Registers HSM Credentials", metatype=true, configurationFactory=true)
public class HSMCredentialConfigurationService {
    public static final String NAME = "com.adobe.fd.signatures.HSMCredentialConfigurationService";
    @Property(label="Credential Alias", description="Alias of the HSM Credential")
    static final String PROP_CREDENTIAL_ALIAS = "credential.alias";
    @Property(label="HSM Library Path", description="Path of the HSM Client Library to be used for HSM operations")
    static final String PROP_DLL_PATH = "hsm.client.library.path";
    @Property(label="HSM Pin", description="HSM Pin. For AwsCloudHsm, Please provide Crypto username and password in <CU_username>:<CU_password> format.")
    static final String PROP_HSM_PIN = "hsm.pin";
    @Property(label="HSM Slot Id", description="Slot id where the certificate is accessible, not required for E-Token. For AwsCloudHsm provide token label instead of slot ID.")
    static final String PROP_SLOT_ID = "slot.id";
    @Property(label="Certificate SHA1", description="SHA1 of the certificate to be configured")
    static final String PROP_CERT_SHA1 = "cert.sha1";
    @Property(label="HSM Device Type", description="HSM Device Type", options={@PropertyOption(name="LunaSA", value="LunaSA"), @PropertyOption(name="EToken", value="EToken"), @PropertyOption(name="Other", value="Other"), @PropertyOption(name="AwsCloudHsm", value="AwsCloudHsm")})
    static final String PROP_HSM_DEVICE_TYPE = "hsm.device.type";
    private CredentialProviderService credentialProviderService = CredentialProviderService.getInstance();
    private String alias;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, ?> config) throws Exception {
        if (config.containsKey(PROP_CREDENTIAL_ALIAS)) {
            HSMProfileBO hsmProfile = this.readConfiguration(config);
            if (this.credentialProviderService.getHSMProfile(hsmProfile.getAlias()) != null) {
                throw new IllegalArgumentException(String.format("alias specified via [%s] property already exists", PROP_CREDENTIAL_ALIAS));
            }
            this.alias = hsmProfile.getAlias();
            this.credentialProviderService.addHSMProfile(this.alias, hsmProfile);
        }
    }

    @Deactivate
    protected void deactivate() {
        this.credentialProviderService.removeHSMProfile(this.alias);
    }

    @Modified
    protected void modified(Map<String, ?> config) throws Exception {
        HSMProfileBO newHSMProfile = this.readConfiguration(config);
        if (newHSMProfile.getAlias().equals(this.alias)) {
            this.credentialProviderService.addHSMProfile(this.alias, newHSMProfile);
        } else {
            this.credentialProviderService.removeHSMProfile(this.alias);
            this.alias = newHSMProfile.getAlias();
            this.credentialProviderService.addHSMProfile(this.alias, newHSMProfile);
        }
    }

    private HSMProfileBO readConfiguration(Map<String, ?> config) {
        String device = (String)config.get(PROP_HSM_DEVICE_TYPE);
        HSMProfileBO.HSMDevice hsmDeviceType = null;
        hsmDeviceType = device.equalsIgnoreCase("LunaSA") ? HSMProfileBO.HSMDevice.LunaSA : (device.equalsIgnoreCase("EToken") ? HSMProfileBO.HSMDevice.EToken : (device.equalsIgnoreCase("AwsCloudHsm") ? HSMProfileBO.HSMDevice.AwsCloudHsm : HSMProfileBO.HSMDevice.Other));
        String alias = (String)config.get(PROP_CREDENTIAL_ALIAS);
        if (alias == null || alias.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("alias must be specified via [%s] property", PROP_CREDENTIAL_ALIAS));
        }
        String dll = (String)config.get(PROP_DLL_PATH);
        if (dll == null || dll.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("dll path must be specified via [%s] property", PROP_DLL_PATH));
        }
        String pass = (String)config.get(PROP_HSM_PIN);
        if (pass == null || pass.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("HSM Pin must be specified via [%s] property", PROP_HSM_PIN));
        }
        String sha1 = (String)config.get(PROP_CERT_SHA1);
        if (sha1 == null || sha1.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("certificate SHA1 must be specified via [%s] property", PROP_CERT_SHA1));
        }
        String slot = (String)config.get(PROP_SLOT_ID);
        if (slot == null || slot.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("slot id must be specified via [%s] property", PROP_SLOT_ID));
        }
        HSMProfileBO hsmProfile = null;
        hsmProfile = hsmDeviceType == HSMProfileBO.HSMDevice.AwsCloudHsm ? new HSMProfileBO(alias, dll, sha1, pass.toCharArray(), HSMProfileBO.HSMSlotInfoType.TokenLabel, slot, hsmDeviceType) : new HSMProfileBO(alias, dll, sha1, pass.toCharArray(), HSMProfileBO.HSMSlotInfoType.SlotID, slot, hsmDeviceType);
        return hsmProfile;
    }
}

