/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.adobe.livecycle.content.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Blob;
import net.sf.beanlib.provider.BeanTransformer;
import net.sf.beanlib.provider.finder.PublicReaderMethodFinder;
import net.sf.beanlib.provider.replicator.BeanReplicator;
import net.sf.beanlib.spi.BeanMethodFinder;
import net.sf.beanlib.spi.BeanTransformerSpi;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;

@Component(immediate=true)
@Service(value={BeanUtils.class})
public class BeanUtils {
    public Object clearContent(Object bean) {
        return this.clearContent(bean, false);
    }

    public Object clearContent(Object bean, boolean retainTextAndImageBinary) {
        if (bean == null) {
            return null;
        }
        BeanTransformer beanTransformer = new BeanTransformer().initReaderMethodFinder((BeanMethodFinder)new ContentExclusionReaderMethodFinder(retainTextAndImageBinary));
        BeanReplicator beanReplicator = new BeanReplicator((BeanTransformerSpi)beanTransformer);
        Object contentLessbean = beanReplicator.replicateBean(bean);
        return contentLessbean;
    }

    class ContentExclusionReaderMethodFinder
    implements BeanMethodFinder {
        boolean retainTextAndImageBinary = true;

        public ContentExclusionReaderMethodFinder(boolean excludeTextAndImageBinary) {
            this.retainTextAndImageBinary = excludeTextAndImageBinary;
        }

        public Method find(String propertyName, Object bean) {
            Class<?> dataType;
            Method method = new PublicReaderMethodFinder().find(propertyName, bean);
            if (method == null || method.getReturnType() == null) {
                return method;
            }
            if (this.retainTextAndImageBinary && (propertyName.equals("ContentXML") || propertyName.equals("ImageBlob"))) {
                return method;
            }
            Class<?> returnType = method.getReturnType();
            if (returnType.isArray() ? (dataType = returnType.getComponentType()) != null && (Byte.class.isAssignableFrom(dataType) || Byte.TYPE.isAssignableFrom(dataType)) : InputStream.class.isAssignableFrom(returnType) || Blob.class.isAssignableFrom(returnType) || propertyName.contains("ContentXML") || File.class.isAssignableFrom(returnType)) {
                return null;
            }
            return method;
        }
    }
}

