/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.dbforms.util;

import com.rits.cloning.Cloner;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepCopyMaker {
    private static final Logger logger = LoggerFactory.getLogger(DeepCopyMaker.class);

    public static Object makeDeepCopy(Object obj2DeepCopy) throws IOException {
        long time1 = System.currentTimeMillis();
        Cloner cloner = new Cloner();
        Object clonedObj = cloner.deepClone(obj2DeepCopy);
        long time2 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("CM PERF: Time taken in making deep copy of " + obj2DeepCopy.getClass().getName() + ":" + (time2 - time1) + "ms");
        }
        return clonedObj;
    }

    public static Object makeDeepCopy(Object obj2DeepCopy, Class<?> ... c) throws IOException {
        long time1 = System.currentTimeMillis();
        Cloner cloner = new Cloner();
        cloner.dontClone((Class[])c);
        Object clonedObj = cloner.deepClone(obj2DeepCopy);
        long time2 = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug("CM PERF: Time taken in making deep copy of " + obj2DeepCopy.getClass().getName() + ":" + (time2 - time1) + "ms");
        }
        return clonedObj;
    }
}

