/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.icc.render;

import com.adobe.icc.render.RenderAuditForm;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"/fd/cm/AuditReport"})
public class AuditReport
extends HttpServlet {
    private static final long serialVersionUID = -6168170407080707090L;
    private static final Logger logger = LoggerFactory.getLogger(AuditReport.class);
    private String defaultCharacterEncoding = "UTF-8";
    @Reference
    private RenderAuditForm renderAuditForm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        try {
            String characterEncoding;
            String uri = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + "/tmp/audit.xci";
            byte[] bytes = this.renderAuditForm.render(uri);
            if (bytes == null) {
                bytes = "There was a problem rendering the PDF. The PDF Result was null.".getBytes();
            }
            if ((characterEncoding = AuditReport.getEncoding(bytes, this.defaultCharacterEncoding)) == null || "".equals(characterEncoding)) {
                characterEncoding = this.defaultCharacterEncoding;
            }
            response.setContentType("application/pdf;charset=" + this.defaultCharacterEncoding);
            try {
                out.write(bytes);
            }
            catch (Exception e) {
                logger.debug("Http Connection is closed.", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("There was a problem rendering the PDF. ", (Throwable)e);
        }
        finally {
            out.flush();
            out.close();
        }
    }

    protected static String getEncoding(byte[] data, String defaultEncoding) {
        String dataUtf8 = null;
        try {
            dataUtf8 = data != null ? new String(data, defaultEncoding) : new String(data, Charset.forName("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            dataUtf8 = new String(data, Charset.forName("UTF-8"));
            logger.debug(" Unsupported encoding, using default UTF-8", (Throwable)e);
        }
        return AuditReport.getEncoding(dataUtf8);
    }

    protected static String getEncoding(String sData) {
        String searchString = "<?xml version=\"1.0\" encoding=\"";
        int searchResult = sData.indexOf(searchString);
        int searchLength = searchString.length() + searchResult;
        if (searchResult > -1) {
            searchResult = sData.indexOf("\"", searchLength);
            String encoding = sData.substring(searchLength, searchResult);
            return encoding;
        }
        return null;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.defaultCharacterEncoding = defaultCharacterEncoding;
    }

    protected void bindRenderAuditForm(RenderAuditForm renderAuditForm) {
        this.renderAuditForm = renderAuditForm;
    }

    protected void unbindRenderAuditForm(RenderAuditForm renderAuditForm) {
        if (this.renderAuditForm == renderAuditForm) {
            this.renderAuditForm = null;
        }
    }
}

